/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingcap.tidb.tipb.TableInfo;
import com.pingcap.tikv.meta.CIStr;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiFlashReplicaInfo;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.meta.TiPartitionInfo;
import com.pingcap.tikv.meta.TiSequenceInfo;
import com.pingcap.tikv.meta.TiViewInfo;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.DataTypeFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.shade.com.google.common.collect.ImmutableList;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TiTableInfo
implements Serializable {
    private final long id;
    private final String name;
    private final String charset;
    private final String collate;
    private final List<TiColumnInfo> columns;
    private final Map<String, TiColumnInfo> columnsMap;
    private final List<TiIndexInfo> indices;
    private final boolean pkIsHandle;
    private final boolean isCommonHandle;
    private final int commonHandleVersion;
    private final String comment;
    private final long autoIncId;
    private final long maxColumnId;
    private final long maxIndexId;
    private final long oldSchemaId;
    private final long rowSize;
    private final TiPartitionInfo partitionInfo;
    private final TiColumnInfo primaryKeyColumn;
    private final TiViewInfo viewInfo;
    private final TiFlashReplicaInfo tiflashReplicaInfo;
    private final long version;
    private final long updateTimestamp;
    private final long maxShardRowIDBits;
    private final TiSequenceInfo sequenceInfo;
    private final long autoRandomBits;
    private final List<TiColumnInfo> columnsWithoutHidden;
    private final List<TiIndexInfo> indicesWithoutHiddenAndInvisible;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public TiTableInfo(@JsonProperty(value="id") long id, @JsonProperty(value="name") CIStr name, @JsonProperty(value="charset") String charset, @JsonProperty(value="collate") String collate, @JsonProperty(value="pk_is_handle") boolean pkIsHandle, @JsonProperty(value="is_common_handle") boolean isCommonHandle, @JsonProperty(value="common_handle_version") int commonHandleVersion, @JsonProperty(value="cols") List<TiColumnInfo> columns, @JsonProperty(value="index_info") List<TiIndexInfo> indices, @JsonProperty(value="comment") String comment, @JsonProperty(value="auto_inc_id") long autoIncId, @JsonProperty(value="max_col_id") long maxColumnId, @JsonProperty(value="max_idx_id") long maxIndexId, @JsonProperty(value="old_schema_id") long oldSchemaId, @JsonProperty(value="partition") TiPartitionInfo partitionInfo, @JsonProperty(value="view") TiViewInfo viewInfo, @JsonProperty(value="tiflash_replica") TiFlashReplicaInfo tiFlashReplicaInfo, @JsonProperty(value="version") long version, @JsonProperty(value="update_timestamp") long updateTimestamp, @JsonProperty(value="max_shard_row_id_bits") long maxShardRowIDBits, @JsonProperty(value="sequence") TiSequenceInfo sequenceInfo, @JsonProperty(value="auto_random_bits") long autoRandomBits) {
        this.id = id;
        this.name = name.getL();
        this.charset = charset;
        this.collate = collate;
        if (sequenceInfo == null) {
            this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
            this.columnsWithoutHidden = columns.stream().filter(col -> !col.isHidden()).collect(Collectors.toList());
            this.columnsMap = new HashMap<String, TiColumnInfo>();
            for (TiColumnInfo col2 : this.columns) {
                this.columnsMap.put(col2.getName(), col2);
            }
            this.rowSize = columns.stream().mapToLong(TiColumnInfo::getSize).sum();
        } else {
            this.columns = null;
            this.columnsWithoutHidden = null;
            this.columnsMap = null;
            this.rowSize = 9L;
        }
        this.pkIsHandle = pkIsHandle;
        this.isCommonHandle = isCommonHandle;
        this.commonHandleVersion = commonHandleVersion;
        this.indices = indices != null ? ImmutableList.copyOf(indices) : ImmutableList.of();
        this.indicesWithoutHiddenAndInvisible = this.indices.stream().filter(idx -> {
            if (idx.isInvisible()) {
                return false;
            }
            for (TiIndexColumn idc : idx.getIndexColumns()) {
                if (!this.getColumn(idc.getName()).isHidden()) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (this.columns != null) {
            this.indices.forEach(x -> x.calculateIndexSize(columns));
        }
        this.comment = comment;
        this.autoIncId = autoIncId;
        this.maxColumnId = maxColumnId;
        this.maxIndexId = maxIndexId;
        this.oldSchemaId = oldSchemaId;
        this.partitionInfo = partitionInfo;
        this.viewInfo = viewInfo;
        this.tiflashReplicaInfo = tiFlashReplicaInfo;
        this.version = version;
        this.updateTimestamp = updateTimestamp;
        this.maxShardRowIDBits = maxShardRowIDBits;
        this.sequenceInfo = sequenceInfo;
        this.autoRandomBits = autoRandomBits;
        TiColumnInfo primaryKey = null;
        if (sequenceInfo == null) {
            for (TiColumnInfo col3 : this.columns) {
                if (!col3.isPrimaryKey()) continue;
                primaryKey = col3;
                break;
            }
        }
        this.primaryKeyColumn = primaryKey;
    }

    public boolean isView() {
        return this.viewInfo != null;
    }

    public boolean isSequence() {
        return this.sequenceInfo != null;
    }

    public boolean hasAutoIncrementColumn() {
        for (TiColumnInfo tiColumnInfo : this.getColumns(true)) {
            if (!tiColumnInfo.isAutoIncrement()) continue;
            return true;
        }
        return false;
    }

    public TiColumnInfo getAutoIncrementColInfo() {
        for (TiColumnInfo tiColumnInfo : this.getColumns(true)) {
            if (!tiColumnInfo.isAutoIncrement()) continue;
            return tiColumnInfo;
        }
        return null;
    }

    public boolean isAutoIncColUnsigned() {
        TiColumnInfo col = this.getAutoIncrementColInfo();
        if (col == null) {
            return false;
        }
        return col.getType().isUnsigned();
    }

    public long getMaxShardRowIDBits() {
        return this.maxShardRowIDBits;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollate() {
        return this.collate;
    }

    public List<TiColumnInfo> getColumns() {
        return this.getColumns(false);
    }

    public List<TiColumnInfo> getColumns(boolean includingAll) {
        if (includingAll) {
            return this.columns;
        }
        return this.columnsWithoutHidden;
    }

    public long getEstimatedRowSizeInByte() {
        return this.rowSize;
    }

    public TiColumnInfo getColumn(String name) {
        return this.columnsMap.get(name.toLowerCase());
    }

    public TiColumnInfo getColumn(int offset) {
        return this.getColumn(offset, false);
    }

    public TiColumnInfo getColumn(int offset, boolean includingHidden) {
        List<TiColumnInfo> tiColumnList = this.getColumns(includingHidden);
        if (offset < 0 || offset >= tiColumnList.size()) {
            throw new TiClientInternalException(String.format("Column offset %d out of bound", offset));
        }
        return tiColumnList.get(offset);
    }

    public boolean isPkHandle() {
        return this.pkIsHandle;
    }

    public boolean isCommonHandle() {
        return this.isCommonHandle;
    }

    public int getCommonHandleVersion() {
        return this.commonHandleVersion;
    }

    public List<TiIndexInfo> getIndices() {
        return this.getIndices(false);
    }

    public List<TiIndexInfo> getIndices(boolean includingAll) {
        if (includingAll) {
            return this.indices;
        }
        return this.indicesWithoutHiddenAndInvisible;
    }

    public TiIndexInfo getPrimaryKey() {
        for (TiIndexInfo index : this.getIndices()) {
            if (!index.isPrimary()) continue;
            return index;
        }
        return null;
    }

    public List<TiIndexColumn> convertIndexColToPrefixCols(TiIndexInfo indexInfo) {
        List<TiIndexColumn> tiIndexColumns = indexInfo.getIndexColumns();
        ArrayList<TiIndexColumn> result = new ArrayList<TiIndexColumn>(tiIndexColumns.size());
        for (TiIndexColumn tiIndexColumn : tiIndexColumns) {
            TiColumnInfo columnInfo = this.getColumn(tiIndexColumn.getName());
            if (tiIndexColumn.getLength() != -1L && tiIndexColumn.getLength() == columnInfo.getLength()) {
                result.add(columnInfo.toUnSpecifiedLenIndexColumn());
                continue;
            }
            result.add(tiIndexColumn);
        }
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    private long getAutoIncId() {
        return this.autoIncId;
    }

    private long getMaxColumnId() {
        return this.maxColumnId;
    }

    private long getMaxIndexId() {
        return this.maxIndexId;
    }

    private long getOldSchemaId() {
        return this.oldSchemaId;
    }

    public TiPartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public long getAutoRandomBits() {
        return this.autoRandomBits;
    }

    public boolean hasAutoRandomColumn() {
        return this.autoRandomBits > 0L;
    }

    public TiColumnInfo getAutoRandomColInfo() {
        if (!this.hasAutoRandomColumn()) {
            return null;
        }
        for (TiColumnInfo tiColumnInfo : this.getColumns(true)) {
            if (!tiColumnInfo.isPrimaryKey()) continue;
            return tiColumnInfo;
        }
        return null;
    }

    public boolean isAutoRandomColUnsigned() {
        TiColumnInfo col = this.getAutoRandomColInfo();
        return col.getType().isUnsigned();
    }

    public TiFlashReplicaInfo getTiflashReplicaInfo() {
        return this.tiflashReplicaInfo;
    }

    TableInfo toProto() {
        return TableInfo.newBuilder().setTableId(this.getId()).addAllColumns(this.getColumns().stream().map(col -> col.toProto(this)).collect(Collectors.toList())).build();
    }

    public boolean hasPrimaryKey() {
        return this.primaryKeyColumn != null;
    }

    public TiColumnInfo getPKIsHandleColumn() {
        if (this.isPkHandle()) {
            for (TiColumnInfo col : this.getColumns(true)) {
                if (!col.isPrimaryKey()) continue;
                return col;
            }
        }
        return null;
    }

    private TiColumnInfo copyColumn(TiColumnInfo col) {
        DataType type = col.getType();
        TiColumnInfo.InternalTypeHolder typeHolder = type.toTypeHolder();
        typeHolder.setFlag(type.getFlag() & 0xFFFFFFFD);
        DataType newType = DataTypeFactory.of(typeHolder);
        return new TiColumnInfo(col.getId(), col.getName(), col.getOffset(), newType, col.getSchemaState(), col.getOriginDefaultValue(), col.getDefaultValue(), col.getDefaultValueBit(), col.getComment(), col.getVersion(), col.getGeneratedExprString(), col.isHidden()).copyWithoutPrimaryKey();
    }

    public TiTableInfo copyTableWithRowId() {
        if (!this.isPkHandle() && !this.isCommonHandle) {
            ImmutableList.Builder newColumns = ImmutableList.builder();
            for (TiColumnInfo col : this.getColumns(true)) {
                newColumns.add(this.copyColumn(col));
            }
            newColumns.add(TiColumnInfo.getRowIdColumn(this.getColumns(true).size()));
            return new TiTableInfo(this.getId(), CIStr.newCIStr(this.getName()), this.getCharset(), this.getCollate(), true, this.isCommonHandle, this.commonHandleVersion, (List<TiColumnInfo>)((Object)newColumns.build()), this.getIndices(true), this.getComment(), this.getAutoIncId(), this.getMaxColumnId(), this.getMaxIndexId(), this.getOldSchemaId(), this.partitionInfo, null, this.getTiflashReplicaInfo(), this.version, this.updateTimestamp, this.maxShardRowIDBits, null, this.autoRandomBits);
        }
        return this;
    }

    public String toString() {
        return this.toProto().toString();
    }

    public boolean isPartitionEnabled() {
        if (this.partitionInfo == null) {
            return false;
        }
        return this.partitionInfo.isEnable();
    }

    public boolean hasGeneratedColumn() {
        for (TiColumnInfo col : this.getColumns(true)) {
            if (!col.isGeneratedColumn()) continue;
            return true;
        }
        return false;
    }

    public long getVersion() {
        return this.version;
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }
}

