/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.meta.collate;

import com.pingcap.tikv.meta.Collation;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.util.Pair;

public class UnicodeCICollator {
    private static final Logger logger = LoggerFactory.getLogger(UnicodeCICollator.class);
    private static final String UNICODE_MAP_TABLE = "unicode_map_table";
    private static final long[] mapTable;
    private static final Map<Integer, long[]> longRuneMap;

    /*
     * Unable to fully structure code
     */
    public static int compare(String a, String b) {
        a = Collation.truncateTailingSpace(a);
        b = Collation.truncateTailingSpace(b);
        an = 0L;
        bn = 0L;
        as = 0L;
        bs = 0L;
        ar = 0;
        br = 0;
        ai = 0;
        bi = 0;
        block0: while (true) {
            if (an == 0L) {
                if (as == 0L) {
                    while (an == 0L && ai < a.length()) {
                        pair = Collation.decodeRune(a, ai);
                        ar = (Integer)pair.first;
                        ai = (Integer)pair.second;
                        pairL = UnicodeCICollator.convertRuneUnicodeCI(ar);
                        an = (Long)pairL.first;
                        as = (Long)pairL.second;
                    }
                } else {
                    an = as;
                    as = 0L;
                }
            }
            if (bn == 0L) {
                if (bs == 0L) {
                    while (bn == 0L && bi < b.length()) {
                        pair = Collation.decodeRune(b, bi);
                        br = (Integer)pair.first;
                        bi = (Integer)pair.second;
                        pairL = UnicodeCICollator.convertRuneUnicodeCI(br);
                        bn = (Long)pairL.first;
                        bs = (Long)pairL.second;
                    }
                } else {
                    bn = bs;
                    bs = 0L;
                }
            }
            if (an == 0L || bn == 0L) {
                return Collation.sign((int)an - (int)bn);
            }
            if (an == bn) {
                an = 0L;
                bn = 0L;
                continue;
            }
            while (true) {
                if (an != 0L && bn != 0L) ** break;
                continue block0;
                if (((an ^ bn) & 65535L) != 0L) {
                    return Collation.sign((int)(an & 65535L) - (int)(bn & 65535L));
                }
                an >>= 16;
                bn >>= 16;
            }
            break;
        }
    }

    public static byte[] key(String key) {
        return UnicodeCICollator.keyWithoutTrimRightSpace(Collation.truncateTailingSpace(key));
    }

    public static byte[] keyWithoutTrimRightSpace(String key) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int r = 0;
        int si = 0;
        long sn = 0L;
        long ss = 0L;
        while (si < key.getBytes().length) {
            Pair<Integer, Integer> pair = Collation.decodeRune(key, si);
            r = (Integer)pair.first;
            si = (Integer)pair.second;
            Pair<Long, Long> pair2 = UnicodeCICollator.convertRuneUnicodeCI(r);
            ss = (Long)pair2.second;
            for (sn = ((Long)pair2.first).longValue(); sn != 0L; sn >>= 16) {
                buf.write((byte)((sn & 0xFF00L) >> 8));
                buf.write((byte)(sn & 0xFFL));
            }
            while (ss != 0L) {
                buf.write((byte)((ss & 0xFF00L) >> 8));
                buf.write((byte)(ss & 0xFFL));
                ss >>= 16;
            }
        }
        return buf.toByteArray();
    }

    public static Pair<Long, Long> convertRuneUnicodeCI(int r) {
        if (r > 65535) {
            return new Pair<Long, Long>(65533L, 0L);
        }
        if (mapTable[r] == 65533L) {
            return new Pair<Long, Long>(longRuneMap.get(r)[0], longRuneMap.get(r)[1]);
        }
        return new Pair<Long, Long>(mapTable[r], 0L);
    }

    static {
        try {
            String line2;
            Long startTime = System.currentTimeMillis();
            InputStream inputStream = UnicodeCICollator.class.getClassLoader().getResourceAsStream(UNICODE_MAP_TABLE);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line2 = reader.readLine()) != null) {
                lines.add(line2);
            }
            logger.info("Read unicode_map_table file cost " + (System.currentTimeMillis() - startTime) + "ms");
            startTime = System.currentTimeMillis();
            mapTable = lines.stream().map(line -> line.split(",")).flatMap(Arrays::stream).mapToLong(s -> {
                if (s.startsWith("0x")) {
                    return Long.parseUnsignedLong(s.substring(2), 16);
                }
                return Long.parseUnsignedLong(s, 16);
            }).toArray();
            logger.info("Load unicode_map_table cost " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        longRuneMap = Arrays.stream(new Object[][]{{12829, new long[]{2120665211272495752L, 2787937295810L}}, {12830, new long[]{2122354061132759688L, 42540491L}}, {12924, new long[]{2117287825089895792L, 7622L}}, {13063, new long[]{1011935909385215573L, 7781L}}, {13077, new long[]{2195538186455490136L, 7794L}}, {13078, new long[]{1011936021056331352L, 511319653L}}, {13079, new long[]{2189627366563389016L, 7781L}}, {13081, new long[]{2190190269271907929L, 7809L}}, {13082, new long[]{2185123638086868569L, 7804L}}, {13088, new long[]{1011935948042215004L, 7794L}}, {13099, new long[]{2198071486739848811L, 7781L}}, {13102, new long[]{2190190183370071660L, 7802L}}, {13106, new long[]{2189627345085800045L, 7781L}}, {13108, new long[]{2185686579448847981L, 7802L}}, {13110, new long[]{1011935943744626286L, 7802L}}, {13127, new long[]{2195256728658976368L, 7809L}}, {13130, new long[]{1011935986696396401L, 7802L}}, {13142, new long[]{2187093988694105723L, 7809L}}, {13183, new long[]{-2373402222409352384L, -486675453938304192L}}, {13230, new long[]{303727361423249344L, 4074L}}, {13231, new long[]{303727361423249344L, 237703146L}}, {65019, new long[]{1395555172539372382L, 1420625832943031211L}}}).collect(Collectors.toMap(o -> (Integer)o[0], o -> (long[])o[1]));
    }
}

