/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.operation.iterator;

import com.pingcap.tidb.tipb.Chunk;
import java.util.Iterator;
import java.util.List;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.shade.com.google.protobuf.ByteString;

public abstract class ChunkIterator<T>
implements Iterator<T> {
    private final List<Chunk> chunks;
    protected int chunkIndex;
    protected int metaIndex;
    protected int bufOffset;
    protected boolean eof;

    protected ChunkIterator(List<Chunk> chunks) {
        this.chunks = chunks;
        this.chunkIndex = 0;
        this.metaIndex = 0;
        this.bufOffset = 0;
        if (chunks.size() == 0 || chunks.get(0).getRowsMetaCount() == 0 || chunks.get(0).getRowsData().size() == 0) {
            this.eof = true;
        }
    }

    public static ChunkIterator<ByteString> getRawBytesChunkIterator(final List<Chunk> chunks) {
        return new ChunkIterator<ByteString>(chunks){

            @Override
            public ByteString next() {
                Chunk c = (Chunk)chunks.get(this.chunkIndex);
                long endOffset = c.getRowsMeta(this.metaIndex).getLength() + (long)this.bufOffset;
                if (endOffset > Integer.MAX_VALUE) {
                    throw new TiClientInternalException("Offset exceeded MAX_INT.");
                }
                ByteString result = c.getRowsData().substring(this.bufOffset, (int)endOffset);
                this.advance();
                return result;
            }
        };
    }

    public static ChunkIterator<Long> getHandleChunkIterator(final List<Chunk> chunks) {
        return new ChunkIterator<Long>(chunks){

            @Override
            public Long next() {
                Chunk c = (Chunk)chunks.get(this.chunkIndex);
                long result = c.getRowsMeta(this.metaIndex).getHandle();
                this.advance();
                return result;
            }
        };
    }

    @Override
    public boolean hasNext() {
        return !this.eof;
    }

    private boolean seekNextNonEmptyChunk() {
        do {
            ++this.chunkIndex;
        } while (this.chunkIndex < this.chunks.size() && this.chunks.get(this.chunkIndex).getRowsMetaCount() == 0);
        return this.chunkIndex < this.chunks.size();
    }

    protected void advance() {
        if (this.eof) {
            return;
        }
        Chunk c = this.chunks.get(this.chunkIndex);
        this.bufOffset = Math.toIntExact((long)this.bufOffset + c.getRowsMeta(this.metaIndex++).getLength());
        if (this.metaIndex >= c.getRowsMetaCount()) {
            if (this.seekNextNonEmptyChunk()) {
                this.metaIndex = 0;
                this.bufOffset = 0;
            } else {
                this.eof = true;
            }
        }
    }
}

