/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.operation.iterator;

import com.pingcap.tikv.ClientSession;
import com.pingcap.tikv.Snapshot;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.handle.Handle;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.operation.iterator.CoprocessorIterator;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.util.RangeSplitter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorCompletionService;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.util.RangeSplitter;

public class IndexScanIterator
implements Iterator<Row> {
    private final Iterator<Handle> handleIterator;
    private final TiDAGRequest dagReq;
    private final Snapshot snapshot;
    private final ExecutorCompletionService<Iterator<Row>> completionService;
    private final int batchSize;
    private Iterator<Row> rowIterator;
    private int batchCount = 0;

    public IndexScanIterator(Snapshot snapshot, TiDAGRequest req, Iterator<Handle> handleIterator) {
        ClientSession clientSession = snapshot.getClientSession();
        TiConfiguration conf = clientSession.getConf();
        this.dagReq = req;
        this.handleIterator = handleIterator;
        this.snapshot = snapshot;
        this.batchSize = conf.getIndexScanBatchSize();
        this.completionService = new ExecutorCompletionService(clientSession.getTiKVSession().getThreadPoolForIndexScan());
    }

    private List<Handle> feedBatch() {
        ArrayList<Handle> handles = new ArrayList<Handle>(512);
        while (this.handleIterator.hasNext()) {
            handles.add(this.handleIterator.next());
            if (this.batchSize > handles.size()) continue;
            break;
        }
        return handles;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.rowIterator == null) {
                ClientSession clientSession = this.snapshot.getClientSession();
                while (this.handleIterator.hasNext()) {
                    List<Handle> handles = this.feedBatch();
                    ++this.batchCount;
                    this.completionService.submit(() -> {
                        ArrayList<RangeSplitter.RegionTask> tasks = new ArrayList<RangeSplitter.RegionTask>();
                        List<Long> ids = this.dagReq.getPrunedPhysicalIds();
                        tasks.addAll(RangeSplitter.newSplitter(clientSession.getTiKVSession().getRegionManager()).splitAndSortHandlesByRegion(ids, handles));
                        return CoprocessorIterator.getRowIterator(this.dagReq, tasks, clientSession);
                    });
                }
                while (this.batchCount > 0) {
                    this.rowIterator = this.completionService.take().get();
                    --this.batchCount;
                    if (!this.rowIterator.hasNext()) continue;
                    return true;
                }
            }
            if (this.rowIterator == null) {
                return false;
            }
        }
        catch (Exception e) {
            throw new TiClientInternalException("Error reading rows from handle", e);
        }
        return this.rowIterator.hasNext();
    }

    @Override
    public Row next() {
        if (this.hasNext()) {
            return this.rowIterator.next();
        }
        throw new NoSuchElementException();
    }
}

