/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.parser;

import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.parser.AstBuilder;
import com.pingcap.tikv.parser.CaseChangingCharStream;
import com.pingcap.tikv.parser.MySqlLexer;
import com.pingcap.tikv.parser.MySqlParser;
import com.pingcap.tikv.parser.MySqlParserBaseVisitor;
import com.pingcap.tikv.parser.PartitionWriteAstBuilder;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.tikv.common.exception.UnsupportedSyntaxException;

public class TiParser
extends MySqlParserBaseVisitor {
    private final AstBuilder astBuilder;

    public TiParser() {
        this.astBuilder = new AstBuilder();
    }

    public TiParser(TiTableInfo tblInfo) {
        this(new AstBuilder(tblInfo));
    }

    public TiParser(AstBuilder astBuilder) {
        this.astBuilder = astBuilder;
    }

    public static TiParser createParserForPartitionWrite(TiTableInfo tblInfo) {
        return new TiParser(new PartitionWriteAstBuilder(tblInfo));
    }

    public Expression parseExpression(String command) {
        if (command.equals("")) {
            throw new UnsupportedSyntaxException("cannot parse empty command");
        }
        MySqlLexer lexer = new MySqlLexer(new CaseChangingCharStream(CharStreams.fromString(command), true));
        CommonTokenStream cmnTokStrm = new CommonTokenStream(lexer);
        MySqlParser parser = new MySqlParser(cmnTokStrm);
        try {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return (Expression)this.astBuilder.visitExpressions(parser.expressions());
        }
        catch (ParseCancellationException e) {
            cmnTokStrm.seek(0);
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return (Expression)this.astBuilder.visitExpressions(parser.expressions());
        }
    }
}

