/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.partition;

import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.Constant;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.FuncCallExpr;
import com.pingcap.tikv.expression.PartitionPruner;
import com.pingcap.tikv.expression.visitor.RangePartitionLocator;
import com.pingcap.tikv.meta.TiPartitionDef;
import com.pingcap.tikv.meta.TiPartitionInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.parser.TiParser;
import com.pingcap.tikv.partition.PartitionExpression;
import com.pingcap.tikv.partition.TableCommon;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.types.DateType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PartitionedTable
implements Serializable {
    private static final RangePartitionLocator partitionLocator = new RangePartitionLocator();
    private final TableCommon logicalTable;
    private final TableCommon[] physicalTables;
    private final PartitionExpression partitionExpr;
    private final TiPartitionInfo partitionInfo;

    public static PartitionedTable newPartitionTable(TableCommon logicalTable, TiTableInfo tableInfo) {
        PartitionExpression partitionExpr = PartitionedTable.generatePartitionExpr(tableInfo);
        List<TiPartitionDef> partitionDefs = tableInfo.getPartitionInfo().getDefs();
        TableCommon[] physicalTables = new TableCommon[partitionDefs.size()];
        for (int i = 0; i < partitionDefs.size(); ++i) {
            TiPartitionDef tiPartitionDef = partitionDefs.get(i);
            physicalTables[i] = new TableCommon(logicalTable.getLogicalTableId(), tiPartitionDef.getId(), logicalTable.getTableInfo());
        }
        return new PartitionedTable(logicalTable, physicalTables, partitionExpr, tableInfo.getPartitionInfo());
    }

    public static PartitionExpression generatePartitionExpr(TiTableInfo tableInfo) {
        TiPartitionInfo partitionInfo = tableInfo.getPartitionInfo();
        switch (partitionInfo.getType()) {
            case RangePartition: {
                if (partitionInfo.getColumns().isEmpty()) {
                    return PartitionedTable.generateRangePartitionExpr(tableInfo);
                }
                return PartitionedTable.generateRangeColumnPartitionExpr(tableInfo);
            }
            case HashPartition: {
                return PartitionedTable.generateHashPartitionExpr(tableInfo);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported partition type %s", new Object[]{partitionInfo.getType()}));
    }

    private static PartitionExpression generateRangeColumnPartitionExpr(TiTableInfo tableInfo) {
        PartitionExpression partitionExpr = new PartitionExpression();
        TiPartitionInfo partitionInfo = tableInfo.getPartitionInfo();
        if (partitionInfo.getColumns().size() > 1) {
            throw new UnsupportedOperationException("Currently only support partition on a single column");
        }
        HashMap<String, List<Expression>> column2PartitionExps = new HashMap<String, List<Expression>>();
        TiParser parser = TiParser.createParserForPartitionWrite(tableInfo);
        for (int i = 0; i < partitionInfo.getColumns().size(); ++i) {
            ArrayList<Expression> partExprs = new ArrayList<Expression>();
            String colRefName = partitionInfo.getColumns().get(i);
            PartitionPruner.generateRangeExprs(partitionInfo, partExprs, parser, colRefName, i);
            column2PartitionExps.put(colRefName, partExprs);
        }
        partitionExpr.setRangeColumnRefBoundExpressions(column2PartitionExps);
        return partitionExpr;
    }

    private static PartitionExpression generateHashPartitionExpr(TiTableInfo tableInfo) {
        PartitionExpression partitionExpr = new PartitionExpression();
        partitionExpr.setOriginExpression(PartitionedTable.generateOriginExpression(tableInfo));
        return partitionExpr;
    }

    private static Expression generateOriginExpression(TiTableInfo tableInfo) {
        TiParser parser = TiParser.createParserForPartitionWrite(tableInfo);
        return parser.parseExpression(tableInfo.getPartitionInfo().getExpr());
    }

    private static PartitionExpression generateRangePartitionExpr(TiTableInfo tableInfo) {
        PartitionExpression partitionExpr = new PartitionExpression();
        TiPartitionInfo partitionInfo = tableInfo.getPartitionInfo();
        String originExpr = partitionInfo.getExpr();
        TiParser parser = TiParser.createParserForPartitionWrite(tableInfo);
        partitionExpr.setOriginExpression(parser.parseExpression(originExpr));
        ArrayList<Expression> rangePartitionExps = new ArrayList<Expression>();
        PartitionPruner.generateRangeExprs(partitionInfo, rangePartitionExps, parser, originExpr, 0);
        partitionExpr.setRangePartitionBoundExpressions(rangePartitionExps);
        return partitionExpr;
    }

    public TableCommon locatePartition(Row row) {
        switch (this.partitionInfo.getType()) {
            case RangePartition: {
                if (this.partitionInfo.getColumns().isEmpty()) {
                    return this.locateRangePartition(row);
                }
                return this.locateRangeColumnPartition(row);
            }
            case HashPartition: {
                return this.locateHashPartition(row);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported partition type %s", new Object[]{this.partitionInfo.getType()}));
    }

    private TableCommon locateHashPartition(Row row) {
        Expression originalExpr = Objects.requireNonNull(this.partitionExpr.getOriginExpression(), "originalExpression should not be null");
        if (originalExpr instanceof ColumnRef) {
            ColumnRef columnRef = (ColumnRef)originalExpr;
            columnRef.resolve(this.logicalTable.getTableInfo());
            Number id = (Number)row.get(columnRef.getColumnOffset(), columnRef.getDataType());
            int partitionId = (int)(id.longValue() % (long)this.physicalTables.length);
            return this.physicalTables[partitionId];
        }
        if (originalExpr instanceof FuncCallExpr) {
            FuncCallExpr partitionFuncExpr = (FuncCallExpr)originalExpr;
            if (partitionFuncExpr.getFuncTp() == FuncCallExpr.Type.YEAR) {
                Expression expression = partitionFuncExpr.getChildren().get(0);
                ColumnRef columnRef = (ColumnRef)expression;
                columnRef.resolve(this.logicalTable.getTableInfo());
                int result = (Integer)partitionFuncExpr.eval(Constant.create(row.get(columnRef.getColumnOffset(), DateType.DATE))).getValue();
                int partitionId = result % this.physicalTables.length;
                return this.physicalTables[partitionId];
            }
            throw new UnsupportedOperationException("Hash partition write only support YEAR() function");
        }
        throw new UnsupportedOperationException(String.format("Unsupported partition expr %s", this.partitionExpr));
    }

    private TableCommon locateRangeColumnPartition(Row row) {
        Map<String, List<Expression>> rangeColumnRefExpressions = Objects.requireNonNull(this.partitionExpr.getRangeColumnRefBoundExpressions(), "RangeColumnRefBoundExpressions should not be null");
        if (rangeColumnRefExpressions.size() != 1) {
            throw new UnsupportedOperationException("Currently only support range column partition on a single column");
        }
        int partitionIndex = -1;
        for (Map.Entry<String, List<Expression>> entry : rangeColumnRefExpressions.entrySet()) {
            List<Expression> value = entry.getValue();
            partitionIndex = this.getPartitionIndex(row, value);
        }
        return this.physicalTables[partitionIndex];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TableCommon locateRangePartition(Row row) {
        Expression originalExpr = Objects.requireNonNull(this.partitionExpr.getOriginExpression(), "originalExpression should not be null");
        List<Expression> rangePartitionBoundExpressions = Objects.requireNonNull(this.partitionExpr.getRangePartitionBoundExpressions(), "RangePartitionBoundExpressions should not be null");
        int partitionIndex = -1;
        if (originalExpr instanceof ColumnRef) {
            ColumnRef columnRef = (ColumnRef)originalExpr;
            columnRef.resolve(this.logicalTable.getTableInfo());
            partitionIndex = this.getPartitionIndex(row, rangePartitionBoundExpressions);
            return this.physicalTables[partitionIndex];
        } else {
            if (!(originalExpr instanceof FuncCallExpr)) throw new UnsupportedOperationException(String.format("Unsupported partition expr %s", this.partitionExpr));
            FuncCallExpr partitionFuncExpr = (FuncCallExpr)originalExpr;
            if (partitionFuncExpr.getFuncTp() != FuncCallExpr.Type.YEAR) throw new UnsupportedOperationException("Range partition write only support YEAR() function");
            partitionIndex = this.getPartitionIndex(row, rangePartitionBoundExpressions);
        }
        return this.physicalTables[partitionIndex];
    }

    private int getPartitionIndex(Row row, List<Expression> rangePartitionBoundExpressions) {
        for (int i = 0; i < rangePartitionBoundExpressions.size(); ++i) {
            Expression expression = rangePartitionBoundExpressions.get(i);
            Boolean match = expression.accept(partitionLocator, new PartitionLocatorContext(this.logicalTable.getTableInfo(), row));
            if (!match.booleanValue()) continue;
            return i;
        }
        throw new IllegalArgumentException("Cannot find partition for row " + row);
    }

    private PartitionedTable(TableCommon logicalTable, TableCommon[] physicalTables, PartitionExpression partitionExpr, TiPartitionInfo partitionInfo) {
        this.logicalTable = logicalTable;
        this.physicalTables = physicalTables;
        this.partitionExpr = partitionExpr;
        this.partitionInfo = partitionInfo;
    }

    public TableCommon getLogicalTable() {
        return this.logicalTable;
    }

    public TableCommon[] getPhysicalTables() {
        return this.physicalTables;
    }

    public PartitionExpression getPartitionExpr() {
        return this.partitionExpr;
    }

    public TiPartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public static class PartitionLocatorContext {
        private final TiTableInfo tableInfo;
        private final Row row;

        public PartitionLocatorContext(TiTableInfo tableInfo, Row row) {
            this.tableInfo = tableInfo;
            this.row = row;
        }

        public TiTableInfo getTableInfo() {
            return this.tableInfo;
        }

        public Row getRow() {
            return this.row;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartitionLocatorContext)) {
                return false;
            }
            PartitionLocatorContext other = (PartitionLocatorContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TiTableInfo this$tableInfo = this.getTableInfo();
            TiTableInfo other$tableInfo = other.getTableInfo();
            if (this$tableInfo == null ? other$tableInfo != null : !this$tableInfo.equals(other$tableInfo)) {
                return false;
            }
            Row this$row = this.getRow();
            Row other$row = other.getRow();
            return !(this$row == null ? other$row != null : !this$row.equals(other$row));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartitionLocatorContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TiTableInfo $tableInfo = this.getTableInfo();
            result = result * 59 + ($tableInfo == null ? 43 : $tableInfo.hashCode());
            Row $row = this.getRow();
            result = result * 59 + ($row == null ? 43 : $row.hashCode());
            return result;
        }

        public String toString() {
            return "PartitionedTable.PartitionLocatorContext(tableInfo=" + this.getTableInfo() + ", row=" + this.getRow() + ")";
        }
    }
}

