/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.types;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.types.AbstractDateTimeType;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tikv.types.MySQLType;
import java.sql.Date;
import java.sql.Timestamp;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;

public class DateType
extends AbstractDateTimeType {
    private static final LocalDate EPOCH = new LocalDate(1970, 1, 1);
    public static final DateType DATE = new DateType(MySQLType.TypeDate);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeDate};

    private DateType(MySQLType tp) {
        super(tp);
    }

    DateType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    public DateTimeZone getTimezone() {
        return Converter.getLocalTimezone();
    }

    @Override
    public Date getOriginDefaultValueNonNull(String value, long version) {
        return Converter.convertToDate(value);
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return this.convertToMysqlDate(value);
    }

    private Date convertToMysqlDate(Object value) throws ConvertNotSupportException {
        Date result;
        if (value instanceof Long) {
            result = new Date((Long)value);
        } else if (value instanceof String) {
            result = Date.valueOf((String)value);
        } else if (value instanceof Date) {
            result = (Date)value;
        } else if (value instanceof Timestamp) {
            result = new Date(((Timestamp)value).getTime());
        } else {
            throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
        }
        return result;
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        Date dt = Converter.convertToDate(value);
        Codec.DateCodec.writeDateFully(cdo, dt, this.getTimezone());
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        Date dt = Converter.convertToDate(value);
        Codec.DateCodec.writeDateProto(cdo, dt, this.getTimezone());
    }

    @Override
    public String getName() {
        return "DATE";
    }

    public int getDays(LocalDate d) {
        return Days.daysBetween(EPOCH, d).getDays();
    }

    @Override
    protected Long decodeNotNull(int flag, CodecDataInput cdi) {
        LocalDate date = this.decodeDate(flag, cdi);
        if (date == null) {
            return null;
        }
        return this.getDays(date);
    }

    @Override
    protected Date decodeNotNullForBatchWrite(int flag, CodecDataInput cdi) {
        LocalDate date = this.decodeDate(flag, cdi);
        if (date == null) {
            return null;
        }
        return new Date(date.toDate().getTime());
    }
}

