/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.types;

import com.pingcap.tidb.tipb.ExprType;
import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.codec.MyDecimal;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.MySQLType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.InvalidCodecFormatException;

public class DecimalType
extends DataType {
    public static final DecimalType DECIMAL = new DecimalType(MySQLType.TypeNewDecimal);
    public static final DecimalType BIG_INT_DECIMAL = new DecimalType(38, 0);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeNewDecimal};

    private DecimalType(MySQLType tp) {
        super(tp);
    }

    public DecimalType(int prec, int scale) {
        super(MySQLType.TypeNewDecimal, prec, scale);
    }

    DecimalType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        if (flag != 6) {
            throw new InvalidCodecFormatException("Invalid Flag type for decimal type: " + flag);
        }
        return Codec.DecimalCodec.readDecimal(cdi);
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return this.convertToMysqlDecimal(value);
    }

    private MyDecimal convertToMysqlDecimal(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        BigDecimal result;
        if (value instanceof Boolean) {
            result = ((Boolean)value).booleanValue() ? BigDecimal.ONE : BigDecimal.ZERO;
        } else if (value instanceof Byte) {
            result = BigDecimal.valueOf(((Byte)value).longValue());
        } else if (value instanceof Short) {
            result = BigDecimal.valueOf(((Short)value).longValue());
        } else if (value instanceof Integer) {
            result = BigDecimal.valueOf(((Integer)value).longValue());
        } else if (value instanceof Long) {
            result = BigDecimal.valueOf((Long)value);
        } else if (value instanceof Float) {
            result = BigDecimal.valueOf(((Float)value).doubleValue());
        } else if (value instanceof Double) {
            result = BigDecimal.valueOf((Double)value);
        } else if (value instanceof String) {
            result = new BigDecimal((String)value);
        } else if (value instanceof BigDecimal) {
            result = (BigDecimal)value;
        } else {
            throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
        }
        int precision = (int)this.getLength();
        int frac = this.getDecimal();
        return this.toGivenPrecisionAndFrac(result, precision, frac);
    }

    private MyDecimal toGivenPrecisionAndFrac(BigDecimal value, int precision, int frac) throws ConvertOverflowException {
        BigDecimal roundedValue = value.setScale(frac, RoundingMode.HALF_UP);
        if (roundedValue.precision() > precision) {
            throw ConvertOverflowException.newOutOfRange();
        }
        MyDecimal roundedMyDecimal = new MyDecimal();
        roundedMyDecimal.fromString(roundedValue.toPlainString());
        int[] bin = roundedMyDecimal.toBin(precision, frac);
        MyDecimal resultMyDecimal = new MyDecimal();
        resultMyDecimal.fromBin(precision, frac, bin);
        return resultMyDecimal;
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        if (value instanceof BigDecimal) {
            MyDecimal dec = new MyDecimal();
            dec.fromString(((BigDecimal)value).toPlainString());
            Codec.DecimalCodec.writeDecimalFully(cdo, dec, (int)this.length, this.decimal);
        } else {
            Codec.DecimalCodec.writeDecimalFully(cdo, (MyDecimal)value, (int)this.length, this.decimal);
        }
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        this.encodeKey(cdo, value);
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        BigDecimal val = Converter.convertToBigDecimal(value);
        MyDecimal dec = new MyDecimal();
        dec.fromString(val.toPlainString());
        Codec.DecimalCodec.writeDecimal(cdo, dec, dec.precision(), dec.frac());
    }

    @Override
    public String getName() {
        return String.format("DECIMAL(%d, %d)", this.length, this.decimal);
    }

    @Override
    public ExprType getProtoExprType() {
        return ExprType.MysqlDecimal;
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        return new BigDecimal(value);
    }
}

