/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.types;

import com.pingcap.tidb.tipb.ExprType;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.MySQLType;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.InvalidCodecFormatException;
import org.tikv.common.util.JsonUtils;

public class JsonType
extends DataType {
    public static final JsonType JSON = new JsonType(MySQLType.TypeJSON);
    public static MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeJSON};

    protected JsonType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    public JsonType(MySQLType type) {
        super(type);
    }

    public JsonType(MySQLType type, int flag, int len, int decimal, String charset, int collation) {
        super(type, flag, len, decimal, charset, collation);
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        if (flag != 10) {
            throw new InvalidCodecFormatException("Invalid Flag type for " + this.getClass().getSimpleName() + ": " + flag);
        }
        return JsonUtils.parseJson(cdi).toString();
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        throw new UnsupportedOperationException("JsonType.encodeKey|value=" + value);
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        throw new UnsupportedOperationException("JsonType.encodeValue|value=" + value);
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        throw new UnsupportedOperationException("JsonType.encodeProto|value=" + value);
    }

    @Override
    public String getName() {
        return "JSON";
    }

    @Override
    public ExprType getProtoExprType() {
        return ExprType.MysqlJson;
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        throw new AssertionError((Object)"json can't have a default value");
    }

    @Override
    public boolean isPushDownSupported() {
        return false;
    }
}

