/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.types;

import com.pingcap.tidb.tipb.ExprType;
import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.MySQLType;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.InvalidCodecFormatException;
import org.tikv.common.exception.TypeException;

public class RealType
extends DataType {
    public static final RealType DOUBLE = new RealType(MySQLType.TypeDouble);
    public static final RealType FLOAT = new RealType(MySQLType.TypeFloat);
    public static final RealType REAL = DOUBLE;
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeDouble, MySQLType.TypeFloat};

    private RealType(MySQLType tp) {
        super(tp);
    }

    RealType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        if (flag == 6) {
            return Codec.DecimalCodec.readDecimal(cdi).doubleValue();
        }
        if (flag == 5) {
            return Codec.RealCodec.readDouble(cdi);
        }
        throw new InvalidCodecFormatException("Invalid Flag type for float type: " + flag);
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return this.convertToReal(value);
    }

    private Object convertToReal(Object value) throws ConvertNotSupportException {
        Double result;
        if (value instanceof Boolean) {
            result = ((Boolean)value).booleanValue() ? Double.valueOf(1.0) : Double.valueOf(0.0);
        } else if (value instanceof Byte) {
            result = ((Byte)value).doubleValue();
        } else if (value instanceof Short) {
            result = ((Short)value).doubleValue();
        } else if (value instanceof Integer) {
            result = ((Integer)value).doubleValue();
        } else if (value instanceof Long) {
            result = ((Long)value).doubleValue();
        } else if (value instanceof Float) {
            result = ((Float)value).doubleValue();
        } else if (value instanceof Double) {
            result = (Double)value;
        } else if (value instanceof String) {
            result = Converter.stringToDouble((String)value);
        } else {
            throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
        }
        if (this.getType() == MySQLType.TypeFloat) {
            return Float.valueOf(result.floatValue());
        }
        return result;
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        double val = Converter.convertToDouble(value);
        Codec.RealCodec.writeDoubleFully(cdo, val);
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        double val = Converter.convertToDouble(value);
        Codec.RealCodec.writeDoubleFully(cdo, val);
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        double val = Converter.convertToDouble(value);
        Codec.RealCodec.writeDouble(cdo, val);
    }

    @Override
    public String getName() {
        if (this.tp == MySQLType.TypeDouble) {
            return "DOUBLE";
        }
        return "FLOAT";
    }

    @Override
    public ExprType getProtoExprType() {
        if (this.tp == MySQLType.TypeDouble) {
            return ExprType.Float64;
        }
        if (this.tp == MySQLType.TypeFloat) {
            return ExprType.Float32;
        }
        throw new TypeException("Unknown Type encoding proto " + (Object)((Object)this.tp));
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        return Double.parseDouble(value);
    }
}

