/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.types;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.meta.Collation;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.collate.BinPaddingCollator;
import com.pingcap.tikv.meta.collate.GeneralCICollator;
import com.pingcap.tikv.meta.collate.UnicodeCICollator;
import com.pingcap.tikv.types.BytesType;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tikv.types.MySQLType;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import org.tikv.common.exception.CodecException;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;

public class StringType
extends BytesType {
    public static final StringType VARCHAR = new StringType(MySQLType.TypeVarchar);
    public static final StringType CHAR = new StringType(MySQLType.TypeString);
    public static final StringType VAR_STRING = new StringType(MySQLType.TypeVarString);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeVarchar, MySQLType.TypeString, MySQLType.TypeVarString};

    protected StringType(MySQLType tp) {
        super(tp);
    }

    public StringType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    public boolean isPushDownSupported() {
        return true;
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException {
        return this.convertToString(value);
    }

    @Override
    public String getName() {
        if (this.length != -1L) {
            return String.format("VARCHAR(%d)", this.length);
        }
        return "VARCHAR";
    }

    private String convertToString(Object value) throws ConvertNotSupportException {
        String result;
        if (value instanceof Boolean) {
            result = ((Boolean)value).booleanValue() ? "1" : "0";
        } else if (value instanceof Byte) {
            result = value.toString();
        } else if (value instanceof Short) {
            result = value.toString();
        } else if (value instanceof Integer) {
            result = value.toString();
        } else if (value instanceof Long) {
            result = value.toString();
        } else {
            if (value instanceof Float || value instanceof Double) {
                throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
            }
            if (value instanceof String) {
                result = value.toString();
            } else if (value instanceof BigDecimal) {
                result = value.toString();
            } else if (value instanceof Date) {
                result = value.toString();
            } else if (value instanceof Timestamp) {
                result = value.toString();
                if (((Timestamp)value).getNanos() == 0) {
                    int len = result.length();
                    result = result.substring(0, len - 2);
                }
            } else {
                throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
            }
        }
        if ((long)result.codePointCount(0, result.length()) > this.getLength()) {
            throw ConvertOverflowException.newMaxLengthException(result, this.getLength());
        }
        return result;
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        return new String((byte[])super.decodeNotNull(flag, cdi), StandardCharsets.UTF_8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        if (Collation.isNewCollationEnabled().booleanValue()) {
            if (Collation.isUTF8GeneralCICollation(this.collation)) {
                Codec.BytesCodec.writeBytesFully(cdo, GeneralCICollator.key(Converter.convertToUTF8String(value)));
                return;
            } else if (Collation.isUTF8UnicodeCICollation(this.collation)) {
                Codec.BytesCodec.writeBytesFully(cdo, UnicodeCICollator.key(Converter.convertToUTF8String(value)));
                return;
            } else {
                if (!Collation.isUTF8BinCollation(this.collation)) throw new CodecException("Unsupported collation: " + Collation.translate(this.collation));
                Codec.BytesCodec.writeBytesFully(cdo, BinPaddingCollator.key(Converter.convertToUTF8String(value)));
            }
            return;
        } else {
            byte[] bytes = Converter.convertToBytes(value);
            Codec.BytesCodec.writeBytesFully(cdo, bytes);
        }
    }
}

