/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import com.pingcap.tikv.TiConfiguration;
import java.util.Objects;
import java.util.stream.Collectors;
import org.tikv.common.PDClient;
import org.tikv.common.StoreVersion;

public class ConvertUpstreamUtils {
    public static org.tikv.common.TiConfiguration convertTiConfiguration(TiConfiguration conf) {
        org.tikv.common.TiConfiguration tikvConf = conf == null ? org.tikv.common.TiConfiguration.createDefault() : org.tikv.common.TiConfiguration.createDefault(conf.getPdAddrs().stream().map(Objects::toString).collect(Collectors.joining(",")));
        tikvConf.setTimeout(conf.getTimeoutUnit().toMillis(conf.getTimeout()));
        tikvConf.setMaxFrameSize(conf.getMaxFrameSize());
        tikvConf.setHostMapping(conf.getHostMapping());
        tikvConf.setIndexScanBatchSize(conf.getIndexScanBatchSize());
        tikvConf.setIndexScanConcurrency(conf.getIndexScanConcurrency());
        tikvConf.setTableScanConcurrency(conf.getTableScanConcurrency());
        tikvConf.setKvClientConcurrency(conf.getKvClientConcurrency());
        tikvConf.setConnRecycleTimeInSeconds(Math.toIntExact(conf.getConnRecycleTime()));
        tikvConf.setCertReloadIntervalInSeconds(conf.getCertReloadInterval());
        tikvConf.setBatchGetConcurrency(conf.getBatchGetConcurrency());
        tikvConf.setBatchPutConcurrency(conf.getBatchPutConcurrency());
        tikvConf.setBatchDeleteConcurrency(conf.getBatchDeleteConcurrency());
        tikvConf.setBatchScanConcurrency(conf.getBatchScanConcurrency());
        tikvConf.setDeleteRangeConcurrency(conf.getDeleteRangeConcurrency());
        tikvConf.setCommandPriority(conf.getCommandPriority());
        tikvConf.setIsolationLevel(conf.getIsolationLevel());
        tikvConf.setShowRowId(conf.isShowRowId());
        tikvConf.setDBPrefix(conf.getDBPrefix());
        tikvConf.setTlsEnable(conf.isTlsEnable());
        tikvConf.setTrustCertCollectionFile(conf.getTrustCertCollectionFile());
        tikvConf.setKeyCertChainFile(conf.getKeyCertChainFile());
        tikvConf.setKeyFile(conf.getKeyFile());
        tikvConf.setJksKeyPath(conf.getJksKeyPath());
        tikvConf.setJksKeyPassword(conf.getJksKeyPassword());
        tikvConf.setJksTrustPath(conf.getJksTrustPath());
        tikvConf.setJksTrustPassword(conf.getJksTrustPassword());
        tikvConf.setJksEnable(conf.isJksEnable());
        tikvConf.setReplicaSelector(conf.getReplicaReadPolicy());
        tikvConf.setEnableGrpcForward(conf.isEnableGrpcForward());
        tikvConf.setGrpcHealthCheckTimeout(conf.getHealthCheckTimeout());
        tikvConf.setHealthCheckPeriodDuration(conf.getHealthCheckPeriod());
        return tikvConf;
    }

    public static boolean isTiKVVersionGreatEqualThanVersion(PDClient pdClient, String version) {
        return StoreVersion.minTiKVVersion(version, pdClient);
    }
}

