/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import com.pingcap.tikv.handle.Handle;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.key.RowKey;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.region.TiStoreType;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.FastByteComparisons;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.common.util.Pair;
import org.tikv.common.util.RangeSplitter;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.common.collect.ImmutableList;
import org.tikv.shade.com.google.protobuf.ByteString;

public class RangeSplitter {
    private final RegionManager regionManager;
    private static final Logger LOG = LoggerFactory.getLogger(RangeSplitter.class);

    private RangeSplitter(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    public static RangeSplitter newSplitter(RegionManager mgr) {
        return new RangeSplitter(mgr);
    }

    public Map<Pair<TiRegion, TiStore>, List<Handle>> groupByAndSortHandlesByRegionId(long tableId, List<Handle> handles) {
        TLongObjectHashMap<List> regionHandles = new TLongObjectHashMap<List>();
        TLongObjectHashMap<Pair<TiRegion, TiStore>> idToRegionStorePair = new TLongObjectHashMap<Pair<TiRegion, TiStore>>();
        HashMap<Pair<TiRegion, TiStore>, List<Handle>> result = new HashMap<Pair<TiRegion, TiStore>, List<Handle>>();
        handles.sort(Handle::compare);
        byte[] endKey = null;
        TiRegion curRegion = null;
        ArrayList<Handle> handlesInCurRegion = new ArrayList<Handle>();
        for (Handle curHandle : handles) {
            RowKey key = RowKey.toRowKey(tableId, curHandle);
            if (endKey == null || endKey.length != 0 && FastByteComparisons.compareTo(key.getBytes(), endKey) >= 0) {
                if (curRegion != null) {
                    regionHandles.put(curRegion.getId(), handlesInCurRegion);
                    handlesInCurRegion = new ArrayList();
                }
                Pair<TiRegion, TiStore> regionStorePair = this.regionManager.getRegionStorePairByKey(ByteString.copyFrom(key.getBytes()));
                curRegion = (TiRegion)regionStorePair.first;
                idToRegionStorePair.put(curRegion.getId(), regionStorePair);
                endKey = curRegion.getEndKey().toByteArray();
            }
            handlesInCurRegion.add(curHandle);
        }
        if (!handlesInCurRegion.isEmpty()) {
            regionHandles.put(curRegion.getId(), handlesInCurRegion);
        }
        regionHandles.forEachEntry((k, v) -> {
            Pair regionStorePair = (Pair)idToRegionStorePair.get(k);
            result.put(regionStorePair, (List<Handle>)v);
            return true;
        });
        return result;
    }

    public List<RangeSplitter.RegionTask> splitAndSortHandlesByRegion(List<Long> ids, List<Handle> handles) {
        HashSet<RangeSplitter.RegionTask> regionTasks = new HashSet<RangeSplitter.RegionTask>();
        for (Long id : ids) {
            regionTasks.addAll(this.splitAndSortHandlesByRegion(id, handles));
        }
        return new ArrayList<RangeSplitter.RegionTask>(regionTasks);
    }

    private List<RangeSplitter.RegionTask> splitAndSortHandlesByRegion(long tableId, List<Handle> handles) {
        ImmutableList.Builder regionTasks = ImmutableList.builder();
        Map<Pair<TiRegion, TiStore>, List<Handle>> regionHandlesMap = this.groupByAndSortHandlesByRegionId(tableId, handles);
        regionHandlesMap.forEach((k, v) -> this.createTask(0, v.size(), tableId, (List<Handle>)v, (Pair<TiRegion, TiStore>)k, regionTasks));
        return regionTasks.build();
    }

    private void createTask(int startPos, int endPos, long tableId, List<Handle> handles, Pair<TiRegion, TiStore> regionStorePair, ImmutableList.Builder<RangeSplitter.RegionTask> regionTasks) {
        Handle startHandle;
        ArrayList<Coprocessor.KeyRange> newKeyRanges = new ArrayList<Coprocessor.KeyRange>(endPos - startPos + 1);
        Handle endHandle = startHandle = handles.get(startPos);
        for (int i = startPos + 1; i < endPos; ++i) {
            Handle curHandle = handles.get(i);
            if (endHandle.next().equals(curHandle)) {
                endHandle = curHandle;
                continue;
            }
            newKeyRanges.add(KeyRangeUtils.makeCoprocRange(RowKey.toRowKey(tableId, startHandle).toByteString(), RowKey.toRowKey(tableId, endHandle.next()).toByteString()));
            endHandle = startHandle = curHandle;
        }
        newKeyRanges.add(KeyRangeUtils.makeCoprocRange(RowKey.toRowKey(tableId, startHandle).toByteString(), RowKey.toRowKey(tableId, endHandle.next()).toByteString()));
        regionTasks.add((Object)RangeSplitter.RegionTask.newInstance((TiRegion)regionStorePair.first, (TiStore)regionStorePair.second, newKeyRanges));
    }

    public List<RangeSplitter.RegionTask> splitRangeByRegion(List<Coprocessor.KeyRange> keyRanges, TiStoreType storeType) {
        if (keyRanges == null || keyRanges.size() == 0) {
            return ImmutableList.of();
        }
        int i = 0;
        Coprocessor.KeyRange range = keyRanges.get(i++);
        HashMap<Long, List> idToRange = new HashMap<Long, List>();
        HashMap<Long, Pair<TiRegion, TiStore>> idToRegion = new HashMap<Long, Pair<TiRegion, TiStore>>();
        while (true) {
            Pair<TiRegion, TiStore> regionStorePair = null;
            ConcreteBackOffer bo = ConcreteBackOffer.newGetBackOff(40000L);
            while (regionStorePair == null || regionStorePair.first == null || regionStorePair.second == null) {
                try {
                    regionStorePair = this.regionManager.getRegionStorePairByKey(range.getStart(), storeType, bo);
                    if (regionStorePair == null) {
                        throw new NullPointerException("fail to get region/store pair by key " + RangeSplitter.formatByteString(range.getStart()));
                    }
                    if (regionStorePair.second != null) continue;
                    LOG.warn("Cannot find valid store on " + (Object)((Object)storeType));
                    throw new NullPointerException("fail to get store in regionStorePair by key " + RangeSplitter.formatByteString(range.getStart()));
                }
                catch (Exception e) {
                    LOG.warn("getRegionStorePairByKey error", (Throwable)e);
                    bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                }
            }
            TiRegion region = (TiRegion)regionStorePair.first;
            idToRegion.putIfAbsent(region.getId(), regionStorePair);
            if (Key.toRawKey(range.getEnd()).compareTo(Key.toRawKey(region.getEndKey())) > 0) {
                Coprocessor.KeyRange cutRange = Coprocessor.KeyRange.newBuilder().setStart(range.getStart()).setEnd(region.getEndKey()).build();
                List ranges = idToRange.computeIfAbsent(region.getId(), k -> new ArrayList());
                ranges.add(cutRange);
                range = Coprocessor.KeyRange.newBuilder().setStart(region.getEndKey()).setEnd(range.getEnd()).build();
                continue;
            }
            List ranges = idToRange.computeIfAbsent(region.getId(), k -> new ArrayList());
            ranges.add(range);
            if (i >= keyRanges.size()) break;
            range = keyRanges.get(i++);
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        idToRange.forEach((k, v) -> {
            Pair regionStorePair = (Pair)idToRegion.get(k);
            resultBuilder.add(RangeSplitter.RegionTask.newInstance((TiRegion)regionStorePair.first, (TiStore)regionStorePair.second, v));
        });
        return resultBuilder.build();
    }

    public List<RangeSplitter.RegionTask> splitRangeByRegion(List<Coprocessor.KeyRange> keyRanges) {
        return this.splitRangeByRegion(keyRanges, TiStoreType.TiKV);
    }

    static String formatByteString(ByteString key) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < key.size(); ++i) {
            sb.append(key.byteAt(i) & 0xFF);
            if (i >= key.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

