/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import com.pingcap.tikv.ClientSession;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.predicates.TiKVScanAnalyzer;
import com.pingcap.tikv.util.RangeSplitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.tikv.common.util.RangeSplitter;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.common.collect.ImmutableList;

public class RegionUtils {
    public static Map<String, Integer> getRegionDistribution(ClientSession session, String databaseName, String tableName) {
        List<RangeSplitter.RegionTask> tasks = RegionUtils.getRegionTasks(session, databaseName, tableName);
        HashMap<String, Integer> regionMap = new HashMap<String, Integer>();
        for (RangeSplitter.RegionTask task : tasks) {
            regionMap.merge(task.getHost() + "_" + task.getStore().getId(), 1, Integer::sum);
        }
        return regionMap;
    }

    public static Map<Long, List<Long>> getStoreRegionIdDistribution(ClientSession session, String databaseName, String tableName) {
        List<RangeSplitter.RegionTask> tasks = RegionUtils.getRegionTasks(session, databaseName, tableName);
        HashMap<Long, List<Long>> storeMap = new HashMap<Long, List<Long>>();
        for (RangeSplitter.RegionTask task : tasks) {
            long regionId = task.getRegion().getId();
            long storeId = task.getStore().getId();
            storeMap.putIfAbsent(storeId, new ArrayList());
            ((List)storeMap.get(storeId)).add(regionId);
        }
        return storeMap;
    }

    private static List<RangeSplitter.RegionTask> getRegionTasks(ClientSession session, String databaseName, String tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        TiTableInfo table = session.getCatalog().getTable(databaseName, tableName);
        Objects.requireNonNull(table, String.format("Table not found %s.%s", databaseName, tableName));
        TiKVScanAnalyzer builder = new TiKVScanAnalyzer();
        TiDAGRequest dagRequest = builder.buildTiDAGReq(ImmutableList.of(), ImmutableList.of(), table, session.getTiKVSession().getTimestamp(), new TiDAGRequest(TiDAGRequest.PushDownType.NORMAL));
        ArrayList<Coprocessor.KeyRange> ranges = new ArrayList<Coprocessor.KeyRange>();
        dagRequest.getRangesMaps().forEach((k, v) -> ranges.addAll((Collection<Coprocessor.KeyRange>)v));
        return RangeSplitter.newSplitter(session.getTiKVSession().getRegionManager()).splitRangeByRegion(ranges);
    }
}

