/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.Impl;
import io.perfmark.Link;
import io.perfmark.StringFunction;
import io.perfmark.Tag;
import io.perfmark.impl.Generator;
import io.perfmark.impl.NoopGenerator;
import io.perfmark.impl.Storage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class SecretPerfMarkImpl {
    private SecretPerfMarkImpl() {
    }

    public static final class PerfMarkImpl
    extends Impl {
        private static final Tag NO_TAG;
        private static final Link NO_LINK;
        private static final long INCREMENT = 256L;
        private static final AtomicLong linkIdAlloc;
        private static final Generator generator;
        private static final Object logger;
        private static long actualGeneration;

        public PerfMarkImpl(Tag key) {
            super(key);
        }

        @Override
        protected synchronized void setEnabled(boolean value) {
            PerfMarkImpl.logEnabledChange(value, PerfMarkImpl.setEnabledQuiet(value));
        }

        private static synchronized void logEnabledChange(boolean value, boolean success) {
            Logger localLogger;
            if (success && logger != null && (localLogger = (Logger)logger).isLoggable(Level.FINE)) {
                localLogger.fine((value ? "Enabling" : "Disabling") + " PerfMark recorder");
            }
        }

        private static synchronized boolean setEnabledQuiet(boolean value) {
            if (PerfMarkImpl.isEnabled(actualGeneration) == value) {
                return false;
            }
            if (actualGeneration == -512L) {
                return false;
            }
            generator.setGeneration(actualGeneration += 256L);
            return true;
        }

        @Override
        protected void startTask(String taskName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyway(gen, taskName, PerfMarkImpl.unpackTagName(tag), PerfMarkImpl.unpackTagId(tag));
        }

        @Override
        protected void startTask(String taskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyway(gen, taskName);
        }

        protected void startTask(String taskName, String subTaskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyway(gen, taskName, subTaskName);
        }

        protected <T> void startTask(T taskNameObject, StringFunction<? super T> stringFunction) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            String taskName = PerfMarkImpl.deriveTaskValue(taskNameObject, stringFunction);
            Storage.startAnyway(gen, taskName);
        }

        protected void stopTask() {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyway(gen);
        }

        @Override
        protected void stopTask(String taskName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyway(gen, taskName, PerfMarkImpl.unpackTagName(tag), PerfMarkImpl.unpackTagId(tag));
        }

        @Override
        protected void stopTask(String taskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyway(gen, taskName);
        }

        protected void stopTask(String taskName, String subTaskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyway(gen, taskName, subTaskName);
        }

        @Override
        protected void event(String eventName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyway(gen, eventName, PerfMarkImpl.unpackTagName(tag), PerfMarkImpl.unpackTagId(tag));
        }

        @Override
        protected void event(String eventName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyway(gen, eventName);
        }

        protected void event(String eventName, String subEventName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyway(gen, eventName, subEventName);
        }

        @Override
        protected void attachTag(Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.attachTagAnyway(gen, PerfMarkImpl.unpackTagName(tag), PerfMarkImpl.unpackTagId(tag));
        }

        protected void attachTag(String tagName, String tagValue) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.attachKeyedTagAnyway(gen, tagName, tagValue);
        }

        protected <T> void attachTag(String tagName, T tagObject, StringFunction<? super T> stringFunction) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            String tagValue = PerfMarkImpl.deriveTagValue(tagName, tagObject, stringFunction);
            Storage.attachKeyedTagAnyway(gen, tagName, tagValue);
        }

        static <T> String deriveTagValue(String tagName, T tagObject, StringFunction<? super T> stringFunction) {
            try {
                return stringFunction.apply(tagObject);
            }
            catch (Throwable t) {
                PerfMarkImpl.handleTagValueFailure(tagName, tagObject, stringFunction, t);
                return "PerfMarkTagError:" + t.getClass().getName();
            }
        }

        static <T> String deriveTaskValue(T taskNameObject, StringFunction<? super T> stringFunction) {
            try {
                return stringFunction.apply(taskNameObject);
            }
            catch (Throwable t) {
                PerfMarkImpl.handleTaskNameFailure(taskNameObject, stringFunction, t);
                return "PerfMarkTaskError:" + t.getClass().getName();
            }
        }

        static <T> void handleTagValueFailure(String tagName, T tagObject, StringFunction<? super T> stringFunction, Throwable cause) {
            if (logger == null) {
                return;
            }
            Logger localLogger = (Logger)logger;
            try {
                if (localLogger.isLoggable(Level.FINE)) {
                    LogRecord lr = new LogRecord(Level.FINE, "PerfMark.attachTag failed: tagName={0}, tagObject={1}, stringFunction={2}");
                    lr.setParameters(new Object[]{tagName, tagObject, stringFunction});
                    lr.setThrown(cause);
                    localLogger.log(lr);
                }
            }
            catch (Throwable t) {
                localLogger.log(Level.FINE, "PerfMark.attachTag failed for {0}: {1}", new Object[]{tagName, t.getClass()});
            }
        }

        static <T> void handleTaskNameFailure(T taskNameObject, StringFunction<? super T> stringFunction, Throwable cause) {
            if (logger == null) {
                return;
            }
            Logger localLogger = (Logger)logger;
            try {
                if (localLogger.isLoggable(Level.FINE)) {
                    LogRecord lr = new LogRecord(Level.FINE, "PerfMark.startTask failed: taskObject={0}, stringFunction={1}");
                    lr.setParameters(new Object[]{taskNameObject, stringFunction});
                    lr.setThrown(cause);
                    localLogger.log(lr);
                }
            }
            catch (Throwable t) {
                localLogger.log(Level.FINE, "PerfMark.startTask failed for {0}", new Object[]{t.getClass()});
            }
        }

        protected void attachTag(String tagName, long tagValue) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.attachKeyedTagAnyway(gen, tagName, tagValue);
        }

        protected void attachTag(String tagName, long tagValue0, long tagValue1) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.attachKeyedTagAnyway(gen, tagName, tagValue0, tagValue1);
        }

        @Override
        protected Tag createTag(@Nullable String tagName, long tagId) {
            if (!PerfMarkImpl.isEnabled(PerfMarkImpl.getGen())) {
                return NO_TAG;
            }
            return PerfMarkImpl.packTag(tagName, tagId);
        }

        @Override
        protected Link linkOut() {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return NO_LINK;
            }
            long linkId = linkIdAlloc.getAndIncrement();
            Storage.linkAnyway(gen, linkId);
            return PerfMarkImpl.packLink(linkId);
        }

        @Override
        protected void linkIn(Link link) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.linkAnyway(gen, -PerfMarkImpl.unpackLinkId(link));
        }

        private static long getGen() {
            return generator.getGeneration();
        }

        private static boolean isEnabled(long gen) {
            return (gen >>> 8 & 1L) != 0L;
        }

        static {
            Class<?> clz;
            NO_TAG = PerfMarkImpl.packTag("", Long.MIN_VALUE);
            NO_LINK = PerfMarkImpl.packLink(Long.MIN_VALUE);
            linkIdAlloc = new AtomicLong(1L);
            Generator gen = null;
            Throwable[] problems = new Throwable[4];
            if (gen == null) {
                try {
                    clz = Class.forName("io.perfmark.java7.SecretMethodHandleGenerator$MethodHandleGenerator");
                    gen = clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    problems[0] = t;
                }
            }
            if (gen == null) {
                try {
                    clz = Class.forName("io.perfmark.java9.SecretVarHandleGenerator$VarHandleGenerator");
                    gen = clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    problems[1] = t;
                }
            }
            if (gen == null) {
                try {
                    clz = Class.forName("io.perfmark.java6.SecretVolatileGenerator$VolatileGenerator");
                    gen = clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    problems[2] = t;
                }
            }
            generator = gen == null ? new NoopGenerator() : gen;
            boolean startEnabled = false;
            boolean startEnabledSuccess = false;
            try {
                startEnabled = Boolean.getBoolean("io.perfmark.PerfMark.startEnabled");
                if (startEnabled) {
                    startEnabledSuccess = PerfMarkImpl.setEnabledQuiet(startEnabled);
                }
            }
            catch (Throwable t) {
                problems[3] = t;
            }
            Logger log = null;
            try {
                if (Boolean.getBoolean("io.perfmark.PerfMark.debug")) {
                    Logger localLogger;
                    log = localLogger = Logger.getLogger(PerfMarkImpl.class.getName());
                    for (Throwable problem : problems) {
                        if (problem == null) continue;
                        localLogger.log(Level.FINE, "Error loading Generator", problem);
                    }
                    localLogger.log(Level.FINE, "Using {0}", new Object[]{generator.getClass().getName()});
                    PerfMarkImpl.logEnabledChange(startEnabled, startEnabledSuccess);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger = log;
        }
    }
}

