/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.AbstractDateTimeType;
import org.tikv.common.types.Converter;
import org.tikv.common.types.MySQLType;

public class DateTimeType
extends AbstractDateTimeType {
    public static final DateTimeType DATETIME = new DateTimeType(MySQLType.TypeDatetime);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeDatetime};

    private DateTimeType(MySQLType tp) {
        super(tp);
    }

    DateTimeType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    public DateTimeZone getTimezone() {
        return Converter.getLocalTimezone();
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return this.convertToMysqlDateTime(value);
    }

    @Override
    public String getName() {
        return "DATETIME@" + this.getTimezone().getID();
    }

    @Override
    protected Long decodeNotNull(int flag, CodecDataInput cdi) {
        return this.decodeDateTime(flag, cdi);
    }

    @Override
    protected Timestamp decodeNotNullForBatchWrite(int flag, CodecDataInput cdi) {
        return this.decodeDateTimeForBatchWrite(flag, cdi);
    }

    @Override
    public DateTime getOriginDefaultValueNonNull(String value, long version) {
        return Converter.convertToDateTime(value).getDateTime();
    }
}

