/*
 * Decompiled with CFR 0.152.
 */
package shade.io.netty.handler.codec.protobuf;

import java.util.List;
import shade.com.google.protobuf.nano.MessageNano;
import shade.io.netty.buffer.ByteBuf;
import shade.io.netty.buffer.ByteBufUtil;
import shade.io.netty.channel.ChannelHandler;
import shade.io.netty.channel.ChannelHandlerContext;
import shade.io.netty.handler.codec.MessageToMessageDecoder;
import shade.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ProtobufDecoderNano
extends MessageToMessageDecoder<ByteBuf> {
    private final Class<? extends MessageNano> clazz;

    public ProtobufDecoderNano(Class<? extends MessageNano> clazz) {
        this.clazz = ObjectUtil.checkNotNull(clazz, "You must provide a Class");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int offset;
        byte[] array;
        int length = msg.readableBytes();
        if (msg.hasArray()) {
            array = msg.array();
            offset = msg.arrayOffset() + msg.readerIndex();
        } else {
            array = ByteBufUtil.getBytes(msg, msg.readerIndex(), length, false);
            offset = 0;
        }
        MessageNano prototype = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        out.add(MessageNano.mergeFrom((MessageNano)prototype, (byte[])array, (int)offset, (int)length));
    }
}

