/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.codec;

import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.RowV2;
import com.pingcap.tikv.codec.TableCodecV1;
import com.pingcap.tikv.codec.TableCodecV2;
import com.pingcap.tikv.exception.CodecException;
import com.pingcap.tikv.key.CommonHandle;
import com.pingcap.tikv.key.Handle;
import com.pingcap.tikv.key.IntHandle;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.row.Row;
import java.util.List;

public class TableCodec {
    public static byte[] encodeRow(List<TiColumnInfo> columnInfos, Object[] values, boolean isPkHandle, boolean encodeWithNewRowFormat) throws IllegalAccessException {
        if (columnInfos.size() != values.length) {
            throw new IllegalAccessException(String.format("encodeRow error: data and columnID count not match %d vs %d", columnInfos.size(), values.length));
        }
        if (encodeWithNewRowFormat) {
            return TableCodecV2.encodeRow(columnInfos, values, isPkHandle);
        }
        return TableCodecV1.encodeRow(columnInfos, values, isPkHandle);
    }

    public static Row decodeRow(byte[] value, Handle handle, TiTableInfo tableInfo) {
        if (value.length == 0) {
            throw new CodecException("Decode fails: value length is zero");
        }
        if ((value[0] & 0xFF) == RowV2.CODEC_VER) {
            return TableCodecV2.decodeRow(value, handle, tableInfo);
        }
        return TableCodecV1.decodeRow(value, handle, tableInfo);
    }

    public static Handle decodeHandle(byte[] value, boolean isCommonHandle) {
        if (isCommonHandle) {
            return new CommonHandle(value);
        }
        return new IntHandle(new CodecDataInput(value).readLong());
    }
}

