/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.columnar;

import com.pingcap.tikv.columnar.TiChunkColumnVector;
import com.pingcap.tikv.columnar.TiColumnVector;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

public class BatchedTiChunkColumnVector
extends TiColumnVector {
    private final List<TiChunkColumnVector> childColumns;
    private final int numOfNulls;
    private final int[] rightEndpoints;

    public BatchedTiChunkColumnVector(List<TiChunkColumnVector> child, int numOfRows) {
        super(child.get(0).dataType(), numOfRows);
        this.childColumns = child;
        this.numOfNulls = child.stream().reduce(0, (partialAgeResult, columnVector) -> partialAgeResult + columnVector.numNulls(), Integer::sum);
        int right = 0;
        this.rightEndpoints = new int[child.size() + 1];
        this.rightEndpoints[0] = 0;
        for (int i = 1; i < this.rightEndpoints.length; ++i) {
            this.rightEndpoints[i] = right += child.get(i - 1).numOfRows();
        }
    }

    public final String typeName() {
        return this.dataType().getType().name();
    }

    public void free() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNull() {
        return this.numOfNulls > 0;
    }

    @Override
    public int numNulls() {
        return this.numOfNulls;
    }

    private int[] getColumnVectorIdxAndRowId(int rowId) {
        int offset = Arrays.binarySearch(this.rightEndpoints, rowId);
        int idx = offset >= 0 ? offset : -(offset + 2);
        if (idx >= this.childColumns.size() || idx < 0) {
            throw new UnsupportedOperationException("Something goes wrong, it should never happen");
        }
        return new int[]{idx, rowId - this.rightEndpoints[idx]};
    }

    @Override
    public boolean isNullAt(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).isNullAt(pair[1]);
    }

    @Override
    public boolean getBoolean(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getBoolean(pair[1]);
    }

    @Override
    public byte getByte(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getByte(pair[1]);
    }

    @Override
    public short getShort(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getShort(pair[1]);
    }

    @Override
    public int getInt(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getInt(pair[1]);
    }

    @Override
    public long getLong(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getLong(pair[1]);
    }

    @Override
    public float getFloat(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getFloat(pair[1]);
    }

    @Override
    public double getDouble(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getDouble(pair[1]);
    }

    @Override
    public BigDecimal getDecimal(int rowId, int precision, int scale) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getDecimal(pair[1], precision, scale);
    }

    @Override
    public String getUTF8String(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getUTF8String(pair[1]);
    }

    @Override
    public byte[] getBinary(int rowId) {
        int[] pair = this.getColumnVectorIdxAndRowId(rowId);
        return this.childColumns.get(pair[0]).getBinary(pair[1]);
    }

    @Override
    protected TiColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("TiChunkBatchColumnVector does not support this operation");
    }
}

