/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.columnar.datatypes;

import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.columnar.TiBlockColumnVector;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.util.MemoryUtil;
import java.nio.ByteBuffer;

public abstract class CHType {
    protected int length;
    protected boolean nullable = false;

    abstract String name();

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    protected ByteBuffer decodeNullMap(CodecDataInput cdi, int size) {
        ByteBuffer buffer = MemoryUtil.allocateDirect(size);
        MemoryUtil.readFully(buffer, cdi, size);
        buffer.clear();
        return buffer;
    }

    public abstract DataType toDataType();

    protected int bufferSize(int size) {
        return size * this.length;
    }

    public TiBlockColumnVector decode(CodecDataInput cdi, int size) {
        if (this.length == -1) {
            throw new IllegalStateException("var type should have its own decode method");
        }
        if (size == 0) {
            return new TiBlockColumnVector(this);
        }
        if (this.isNullable()) {
            ByteBuffer nullMap = this.decodeNullMap(cdi, size);
            ByteBuffer buffer = MemoryUtil.allocateDirect(this.bufferSize(size));
            MemoryUtil.readFully(buffer, cdi, this.bufferSize(size));
            buffer.clear();
            return new TiBlockColumnVector(this, nullMap, buffer, size, this.length);
        }
        ByteBuffer buffer = MemoryUtil.allocateDirect(this.bufferSize(size));
        MemoryUtil.readFully(buffer, cdi, this.bufferSize(size));
        buffer.clear();
        return new TiBlockColumnVector(this, buffer, size, this.length);
    }
}

