/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.datatype;

import com.pingcap.tikv.types.AbstractDateTimeType;
import com.pingcap.tikv.types.BytesType;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.DateType;
import com.pingcap.tikv.types.DecimalType;
import com.pingcap.tikv.types.EnumType;
import com.pingcap.tikv.types.IntegerType;
import com.pingcap.tikv.types.JsonType;
import com.pingcap.tikv.types.MySQLType;
import com.pingcap.tikv.types.RealType;
import com.pingcap.tikv.types.SetType;
import com.pingcap.tikv.types.StringType;
import com.pingcap.tikv.types.TimeType;
import org.apache.spark.sql.types.DataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapping {
    private static final Logger logger = LoggerFactory.getLogger((String)TypeMapping.class.getName());
    private static final int MAX_PRECISION = 38;

    private static boolean isStringType(DataType type) {
        return type instanceof EnumType || type instanceof JsonType || type instanceof SetType || type instanceof StringType;
    }

    public static org.apache.spark.sql.types.DataType toSparkType(DataType type) {
        if (type instanceof DateType) {
            return DataTypes.DateType;
        }
        if (type instanceof AbstractDateTimeType) {
            return DataTypes.TimestampType;
        }
        if (type instanceof DecimalType) {
            int len = (int)type.getLength();
            if (len > 38) {
                logger.warn("Decimal precision exceeding MAX_PRECISION=38, value will be truncated");
                len = 38;
            }
            return DataTypes.createDecimalType((int)len, (int)type.getDecimal());
        }
        if (TypeMapping.isStringType(type)) {
            return DataTypes.StringType;
        }
        if (type instanceof RealType) {
            switch (type.getType()) {
                case TypeFloat: {
                    return DataTypes.FloatType;
                }
                case TypeDouble: {
                    return DataTypes.DoubleType;
                }
            }
        }
        if (type instanceof BytesType) {
            return DataTypes.BinaryType;
        }
        if (type instanceof IntegerType) {
            if (type.isUnsigned() && type.getType() == MySQLType.TypeLonglong) {
                return DataTypes.createDecimalType((int)20, (int)0);
            }
            return DataTypes.LongType;
        }
        if (type instanceof TimeType) {
            return DataTypes.LongType;
        }
        throw new UnsupportedOperationException(String.format("found unsupported type %s", type.getClass().getCanonicalName()));
    }
}

