/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.com.google.common.base.Preconditions;
import com.pingcap.tidb.tipb.ByItem;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.visitor.ProtoConverter;
import java.io.Serializable;

public class ByItem
implements Serializable {
    private final Expression expr;
    private final boolean desc;

    private ByItem(Expression expr, boolean desc) {
        Preconditions.checkNotNull(expr, "Expr cannot be null for ByItem");
        this.expr = expr;
        this.desc = desc;
    }

    public static ByItem create(Expression expr, boolean desc) {
        return new ByItem(expr, desc);
    }

    public com.pingcap.tidb.tipb.ByItem toProto(Object context) {
        ByItem.Builder builder = com.pingcap.tidb.tipb.ByItem.newBuilder();
        return builder.setExpr(ProtoConverter.toProto(this.expr, context)).setDesc(this.desc).build();
    }

    public Expression getExpr() {
        return this.expr;
    }

    public boolean isDesc() {
        return this.desc;
    }

    public String toString() {
        return String.format("[%s %s]", this.expr.toString(), this.desc ? "DESC" : "ASC");
    }
}

