/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression.visitor;

import com.pingcap.com.google.common.collect.Range;
import com.pingcap.com.google.common.collect.RangeSet;
import com.pingcap.com.google.common.collect.TreeRangeSet;
import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.StringRegExpression;
import com.pingcap.tikv.expression.visitor.RangeSetBuilder;
import com.pingcap.tikv.key.TypedKey;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.types.DataType;
import java.util.HashMap;
import java.util.Map;

public class IndexRangeSetBuilder
extends RangeSetBuilder<TypedKey> {
    private final Map<ColumnRef, Integer> lengths;

    public IndexRangeSetBuilder(TiTableInfo table, TiIndexInfo index) {
        HashMap<ColumnRef, Integer> result = new HashMap<ColumnRef, Integer>();
        if (table != null && index != null) {
            for (TiIndexColumn indexColumn : index.getIndexColumns()) {
                ColumnRef columnRef = ColumnRef.create(indexColumn.getName(), table);
                result.put(columnRef, (int)indexColumn.getLength());
            }
        }
        this.lengths = result;
    }

    @Override
    protected RangeSet<TypedKey> visit(ComparisonBinaryExpression node, Void context) {
        ComparisonBinaryExpression.NormalizedPredicate predicate = node.normalize();
        if (predicate == null) {
            IndexRangeSetBuilder.throwOnError(node);
        }
        int prefixLen = this.lengths.getOrDefault(predicate.getColumnRef(), -1);
        TypedKey literal = predicate.getTypedLiteral(prefixLen);
        boolean loose = !DataType.isLengthUnSpecified(prefixLen);
        return this.visitComparisonBinaryExpr(node, context, literal, loose);
    }

    @Override
    protected RangeSet<TypedKey> visit(StringRegExpression node, Void context) {
        ColumnRef columnRef = node.getColumnRef();
        int prefixLen = this.lengths.getOrDefault(columnRef, -1);
        TypedKey literal = node.getTypedLiteral(prefixLen);
        TreeRangeSet<TypedKey> ranges = TreeRangeSet.create();
        switch (node.getRegType()) {
            case STARTS_WITH: {
                ranges.add(Range.atLeast(literal).intersection(Range.lessThan(literal.next())));
                break;
            }
            default: {
                IndexRangeSetBuilder.throwOnError(node);
            }
        }
        return ranges;
    }
}

