/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression.visitor;

import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.Constant;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.FuncCallExpr;
import com.pingcap.tikv.expression.LogicalBinaryExpression;
import com.pingcap.tikv.expression.visitor.DefaultVisitor;
import com.pingcap.tikv.predicates.PredicateUtils;
import java.util.Objects;
import java.util.Set;

public class PartAndFilterExprRewriter
extends DefaultVisitor<Expression, Void> {
    private final Expression partExpr;
    private final Set<ColumnRef> columnRefs;
    private boolean unsupportedPartFnFound;

    public PartAndFilterExprRewriter(Expression partExpr) {
        Objects.requireNonNull(partExpr, "partition expression cannot be null");
        this.partExpr = partExpr;
        this.columnRefs = PredicateUtils.extractColumnRefFromExpression(partExpr);
    }

    private boolean isYear() {
        return this.partExpr instanceof FuncCallExpr && ((FuncCallExpr)this.partExpr).getFuncTp() == FuncCallExpr.Type.YEAR;
    }

    private boolean isColumnRef() {
        return this.partExpr instanceof ColumnRef;
    }

    @Override
    protected Expression process(Expression node, Void context) {
        for (Expression expr : node.getChildren()) {
            expr.accept(this, context);
        }
        return node;
    }

    @Override
    public Expression visit(LogicalBinaryExpression node, Void context) {
        Expression left = node.getLeft().accept(this, null);
        Expression right = node.getRight().accept(this, null);
        return new LogicalBinaryExpression(node.getCompType(), left, right);
    }

    @Override
    public Expression visit(FuncCallExpr node, Void context) {
        if (node.getFuncTp() == FuncCallExpr.Type.YEAR) {
            return node.getExpression();
        }
        return node;
    }

    @Override
    public Expression visit(Constant node, Void context) {
        return node;
    }

    @Override
    public Expression visit(ComparisonBinaryExpression node, Void context) {
        ComparisonBinaryExpression.NormalizedPredicate predicate = node.normalize();
        if (predicate != null) {
            if (!this.columnRefs.contains(predicate.getColumnRef())) {
                return node;
            }
            if (this.isYear()) {
                FuncCallExpr year = new FuncCallExpr(predicate.getValue(), FuncCallExpr.Type.YEAR);
                Constant newLiteral = year.eval(predicate.getValue());
                return new ComparisonBinaryExpression(node.getComparisonType(), node.getLeft(), newLiteral);
            }
            if (this.isColumnRef()) {
                return node;
            }
            this.unsupportedPartFnFound = true;
            return null;
        }
        Expression left = node.getLeft().accept(this, null);
        Expression right = node.getRight().accept(this, null);
        return new ComparisonBinaryExpression(node.getComparisonType(), left, right);
    }

    public Expression rewrite(Expression target) {
        return target.accept(this, null);
    }

    public boolean isUnsupportedPartFnFound() {
        return this.unsupportedPartFnFound;
    }
}

