/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression.visitor;

import com.pingcap.tikv.expression.ComparisonBinaryExpression;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.LogicalBinaryExpression;
import com.pingcap.tikv.expression.visitor.DefaultVisitor;

public class PseudoCostCalculator
extends DefaultVisitor<Double, Void> {
    public static double calculateCost(Expression expr) {
        PseudoCostCalculator calc = new PseudoCostCalculator();
        return expr.accept(calc, null);
    }

    @Override
    protected Double process(Expression node, Void context) {
        return 1.0;
    }

    @Override
    protected Double visit(LogicalBinaryExpression node, Void context) {
        double leftCost = node.getLeft().accept(this, context);
        double rightCost = node.getLeft().accept(this, context);
        switch (node.getCompType()) {
            case AND: {
                return leftCost * rightCost;
            }
            case OR: 
            case XOR: {
                return leftCost + rightCost;
            }
        }
        return 1.0;
    }

    @Override
    protected Double visit(ComparisonBinaryExpression node, Void context) {
        switch (node.getComparisonType()) {
            case EQUAL: {
                return 0.01;
            }
            case GREATER_EQUAL: 
            case GREATER_THAN: 
            case LESS_EQUAL: 
            case LESS_THAN: {
                return 0.3;
            }
            case NOT_EQUAL: {
                return 0.99;
            }
        }
        return 1.0;
    }
}

