/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.key;

import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.exception.TypeException;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.types.BytesType;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.IntegerType;
import com.pingcap.tikv.types.StringType;
import com.pingcap.tikv.util.LogDesensitization;
import java.util.Objects;

public class TypedKey
extends Key {
    private final DataType type;
    private final int prefixLength;

    public TypedKey(Object val, DataType type, int prefixLength) {
        super(TypedKey.encodeKey(val, type, prefixLength));
        this.type = type;
        this.prefixLength = prefixLength;
    }

    private TypedKey(byte[] val, DataType type) {
        super(val);
        this.type = type;
        this.prefixLength = -1;
    }

    public static TypedKey toTypedKey(Object val, DataType type, int prefixLength) {
        Objects.requireNonNull(type, "type is null");
        return new TypedKey(val, type, prefixLength);
    }

    public static TypedKey toTypedKey(Object val, DataType type) {
        return TypedKey.toTypedKey(val, type, -1);
    }

    private static byte[] encodeKey(Object val, DataType type, int prefixLength) {
        CodecDataOutput cdo = new CodecDataOutput();
        type.encodeKey(cdo, val, prefixLength);
        return cdo.toBytes();
    }

    public DataType getType() {
        return this.type;
    }

    public Object getValue() {
        CodecDataInput cdi = new CodecDataInput(this.value);
        return this.type.decode(cdi);
    }

    @Override
    public TypedKey nextPrefix() {
        return this.toRawTypedKey(TypedKey.prefixNext(this.value), this.type);
    }

    private TypedKey toRawTypedKey(byte[] val, DataType type) {
        return new TypedKey(val, type);
    }

    @Override
    public TypedKey next() {
        DataType tp = this.getType();
        Object val = this.getValue();
        if (tp instanceof StringType) {
            return TypedKey.toTypedKey(TypedKey.prefixNext(((String)val).getBytes()), this.type, this.prefixLength);
        }
        if (tp instanceof BytesType) {
            return TypedKey.toTypedKey(TypedKey.prefixNext((byte[])val), this.type, this.prefixLength);
        }
        if (DataType.isLengthUnSpecified(this.prefixLength)) {
            if (tp instanceof IntegerType) {
                return TypedKey.toTypedKey((Long)val + 1L, this.type);
            }
            return this.toRawTypedKey(TypedKey.prefixNext(this.value), this.type);
        }
        throw new TypeException("When prefix length is defined, type for TypedKey in next() function must be either String or Byte array. Actual: " + val.getClass().getName());
    }

    @Override
    public String toString() {
        try {
            CodecDataInput cdi = new CodecDataInput(this.value);
            Object val = this.type.decode(cdi);
            if (val instanceof byte[]) {
                return LogDesensitization.hide(KeyUtils.formatBytes(this.value));
            }
            return val.toString();
        }
        catch (Exception e) {
            return "raw value:" + LogDesensitization.hide(KeyUtils.formatBytesUTF8(this.value));
        }
    }
}

