/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.operation;

import com.pingcap.tikv.expression.ByItem;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.types.DataType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaInfer {
    private final List<DataType> types = new ArrayList<DataType>();

    private SchemaInfer(TiDAGRequest dagRequest, boolean readHandle) {
        dagRequest.init(readHandle);
        this.extractFieldTypes(dagRequest, readHandle);
    }

    public static SchemaInfer create(TiDAGRequest dagRequest) {
        return SchemaInfer.create(dagRequest.copy(), false);
    }

    public static SchemaInfer create(TiDAGRequest dagRequest, boolean readHandle) {
        return new SchemaInfer(dagRequest.copy(), readHandle);
    }

    private void extractFieldTypes(TiDAGRequest dagRequest, boolean readHandle) {
        if (readHandle) {
            this.types.addAll(dagRequest.getIndexDataTypes());
        } else if (dagRequest.hasPushDownAggregate()) {
            this.types.addAll(dagRequest.getPushDownAggregates().stream().map(Expression::getDataType).collect(Collectors.toList()));
            if (dagRequest.hasPushDownGroupBy()) {
                for (ByItem item : dagRequest.getPushDownGroupBys()) {
                    this.types.add(item.getExpr().getDataType());
                }
            }
        } else {
            dagRequest.getFields().forEach(expr -> this.types.add(expr.getDataType()));
        }
    }

    public DataType getType(int index) {
        return this.types.get(index);
    }

    public List<DataType> getTypes() {
        return this.types;
    }
}

