/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.predicates;

import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.exception.TiExpressionException;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.predicates.PredicateUtils;
import com.pingcap.tikv.types.DataType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ScanSpec {
    private final List<Expression> pointPredicates;
    private final Optional<Expression> rangePredicate;
    private final Set<Expression> residualPredicates;

    private ScanSpec(List<Expression> pointPredicates, Optional<Expression> rangePredicate, Set<Expression> residualPredicates) {
        this.pointPredicates = pointPredicates;
        this.rangePredicate = rangePredicate;
        this.residualPredicates = residualPredicates;
    }

    public List<Expression> getPointPredicates() {
        return this.pointPredicates;
    }

    public Optional<Expression> getRangePredicate() {
        return this.rangePredicate;
    }

    public Set<Expression> getResidualPredicates() {
        return this.residualPredicates;
    }

    public static class Builder {
        private final IdentityHashMap<TiIndexColumn, List<Expression>> pointPredicates = new IdentityHashMap();
        private final TiTableInfo table;
        private final TiIndexInfo index;
        private final List<Expression> rangePredicates = new ArrayList<Expression>();
        private final List<Expression> residualPredicates = new ArrayList<Expression>();
        private final Set<Expression> residualCandidates = new HashSet<Expression>();
        private TiIndexColumn rangeColumn;

        public Builder(TiTableInfo table, TiIndexInfo index) {
            this.table = table;
            this.index = index;
        }

        void addResidualPredicate(Expression predicate) {
            this.residualPredicates.add(predicate);
        }

        void addAllPredicates(List<Expression> predicates) {
            this.residualCandidates.addAll(predicates);
        }

        void addPointPredicate(TiIndexColumn col, Expression predicate) {
            Objects.requireNonNull(col, "index column is null");
            Objects.requireNonNull(predicate, "predicate is null");
            if (this.pointPredicates.containsKey(col)) {
                List<Expression> predicates = this.pointPredicates.get(col);
                predicates.add(predicate);
            } else {
                ArrayList<Expression> predicates = new ArrayList<Expression>();
                predicates.add(predicate);
                this.pointPredicates.put(col, predicates);
            }
        }

        void addRangePredicate(TiIndexColumn col, Expression predicate) {
            Objects.requireNonNull(col, "col is null");
            if (this.rangeColumn == null) {
                this.rangeColumn = col;
            } else if (!this.rangeColumn.equals(col)) {
                throw new TiExpressionException("Cannot reset range predicates");
            }
            this.rangePredicates.add(predicate);
        }

        public ScanSpec build() {
            ArrayList<Expression> points = new ArrayList<Expression>();
            ArrayList<DataType> pointTypes = new ArrayList<DataType>();
            HashSet<Expression> pushedPredicates = new HashSet<Expression>();
            if (this.index != null) {
                TiIndexColumn indexColumn;
                List<Expression> predicates;
                Iterator<TiIndexColumn> iterator = this.index.getIndexColumns().iterator();
                while (iterator.hasNext() && (predicates = this.pointPredicates.get(indexColumn = iterator.next())) != null) {
                    pushedPredicates.addAll(predicates);
                    TiColumnInfo tiColumnInfo = this.table.getColumn(indexColumn.getOffset());
                    DataType type = tiColumnInfo.getType();
                    points.add(PredicateUtils.mergeCNFExpressions(predicates));
                    pointTypes.add(type);
                }
            }
            Optional newRangePred = this.rangePredicates.isEmpty() ? Optional.empty() : Optional.ofNullable(PredicateUtils.mergeCNFExpressions(this.rangePredicates));
            pushedPredicates.addAll(this.rangePredicates);
            HashSet<Expression> newResidualPredicates = new HashSet<Expression>(this.residualPredicates);
            for (Expression pred : this.residualCandidates) {
                if (pushedPredicates.contains(pred)) continue;
                newResidualPredicates.add(pred);
            }
            return new ScanSpec(ImmutableList.copyOf(points), newRangePred, newResidualPredicates);
        }
    }
}

