/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.row;

import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.util.LogDesensitization;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class ObjectRowImpl
implements Row {
    private final Object[] values;

    private ObjectRowImpl(Object[] values) {
        this.values = values;
    }

    private ObjectRowImpl(int fieldCount) {
        this.values = new Object[fieldCount];
    }

    public static Row create(Object[] values) {
        return new ObjectRowImpl(values);
    }

    public static Row create(int fieldCount) {
        return new ObjectRowImpl(fieldCount);
    }

    @Override
    public void setNull(int pos) {
        this.values[pos] = null;
    }

    @Override
    public boolean isNull(int pos) {
        return this.values[pos] == null;
    }

    @Override
    public void setFloat(int pos, float v) {
        this.values[pos] = Float.valueOf(v);
    }

    @Override
    public float getFloat(int pos) {
        return ((Float)this.values[pos]).floatValue();
    }

    @Override
    public void setInteger(int pos, int v) {
        this.values[pos] = v;
    }

    @Override
    public int getInteger(int pos) {
        return (Integer)this.values[pos];
    }

    @Override
    public void setShort(int pos, short v) {
        this.values[pos] = v;
    }

    @Override
    public short getShort(int pos) {
        return (Short)this.values[pos];
    }

    @Override
    public void setDouble(int pos, double v) {
        this.values[pos] = v;
    }

    @Override
    public double getDouble(int pos) {
        return (Double)this.values[pos];
    }

    @Override
    public void setLong(int pos, long v) {
        this.values[pos] = v;
    }

    @Override
    public long getLong(int pos) {
        return (Long)this.values[pos];
    }

    @Override
    public long getUnsignedLong(int pos) {
        return ((BigDecimal)this.values[pos]).longValue();
    }

    @Override
    public void setString(int pos, String v) {
        this.values[pos] = v;
    }

    @Override
    public String getString(int pos) {
        return Converter.convertToString(this.values[pos]);
    }

    @Override
    public void setTime(int pos, Time v) {
        this.values[pos] = v;
    }

    @Override
    public Date getTime(int pos) {
        return (Date)this.values[pos];
    }

    @Override
    public void setTimestamp(int pos, Timestamp v) {
        this.values[pos] = v;
    }

    @Override
    public Timestamp getTimestamp(int pos) {
        return (Timestamp)this.values[pos];
    }

    @Override
    public void setDate(int pos, Date v) {
        this.values[pos] = v;
    }

    @Override
    public Date getDate(int pos) {
        return (Date)this.values[pos];
    }

    @Override
    public void setBytes(int pos, byte[] v) {
        this.values[pos] = v;
    }

    @Override
    public byte[] getBytes(int pos) {
        return (byte[])this.values[pos];
    }

    @Override
    public void set(int pos, DataType type, Object v) {
        this.values[pos] = v;
    }

    @Override
    public Object get(int pos, DataType type) {
        return this.values[pos];
    }

    @Override
    public int fieldCount() {
        return this.values.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] instanceof byte[]) {
                builder.append("[");
                builder.append(LogDesensitization.hide(KeyUtils.formatBytes((byte[])this.values[i])));
                builder.append("]");
            } else if (this.values[i] instanceof BigDecimal) {
                builder.append(((BigDecimal)this.values[i]).toPlainString());
            } else {
                builder.append(this.values[i]);
            }
            if (i >= this.values.length - 1) continue;
            builder.append(",");
        }
        builder.append(")");
        return builder.toString();
    }
}

