/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import com.pingcap.tikv.columnar.datatypes.CHType;
import com.pingcap.tikv.columnar.datatypes.CHTypeDate;
import com.pingcap.tikv.columnar.datatypes.CHTypeDateTime;
import com.pingcap.tikv.columnar.datatypes.CHTypeDecimal;
import com.pingcap.tikv.columnar.datatypes.CHTypeFixedString;
import com.pingcap.tikv.columnar.datatypes.CHTypeMyDate;
import com.pingcap.tikv.columnar.datatypes.CHTypeMyDateTime;
import com.pingcap.tikv.columnar.datatypes.CHTypeNumber;
import com.pingcap.tikv.columnar.datatypes.CHTypeString;
import org.apache.commons.lang3.StringUtils;

public class CHTypeMapping {
    public static CHType parseType(String typeName) {
        String remain;
        if (typeName == null || typeName.isEmpty()) {
            throw new UnsupportedOperationException("Empty CH type!");
        }
        switch (typeName = typeName.trim()) {
            case "UInt8": {
                return new CHTypeNumber.CHTypeUInt8();
            }
            case "UInt16": {
                return new CHTypeNumber.CHTypeUInt16();
            }
            case "UInt32": {
                return new CHTypeNumber.CHTypeUInt32();
            }
            case "UInt64": {
                return new CHTypeNumber.CHTypeUInt64();
            }
            case "Int8": {
                return new CHTypeNumber.CHTypeInt8();
            }
            case "Int16": {
                return new CHTypeNumber.CHTypeInt16();
            }
            case "Int32": {
                return new CHTypeNumber.CHTypeInt32();
            }
            case "Int64": {
                return new CHTypeNumber.CHTypeInt64();
            }
            case "Float32": {
                return new CHTypeNumber.CHTypeFloat32();
            }
            case "Float64": {
                return new CHTypeNumber.CHTypeFloat64();
            }
            case "Date": {
                return new CHTypeDate();
            }
            case "DateTime": {
                return new CHTypeDateTime();
            }
            case "MyDateTime": {
                return new CHTypeMyDateTime();
            }
            case "MyDate": {
                return new CHTypeMyDate();
            }
            case "String": {
                return new CHTypeString();
            }
        }
        if (typeName.startsWith("FixedString")) {
            remain = StringUtils.removeStart(typeName, "FixedString");
            remain = StringUtils.removeEnd(StringUtils.removeStart(remain, "("), ")");
            try {
                int length = Integer.parseInt(remain);
                return new CHTypeFixedString(length);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedOperationException("Illegal CH type: " + typeName);
            }
        }
        if (typeName.startsWith("MyDateTime")) {
            return new CHTypeMyDateTime();
        }
        if (typeName.startsWith("Decimal")) {
            remain = StringUtils.removeStart(typeName, "Decimal");
            remain = StringUtils.removeEnd(StringUtils.removeStart(remain, "("), ")");
            try {
                String[] args = remain.split(",");
                int precision = Integer.parseInt(args[0]);
                int scale = Integer.parseInt(args[1]);
                return new CHTypeDecimal(precision, scale);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Illegal CH type: " + typeName);
            }
        }
        if (typeName.startsWith("Nullable")) {
            remain = StringUtils.removeStart(typeName, "Nullable");
            remain = StringUtils.removeEnd(StringUtils.removeStart(remain, "("), ")");
            CHType type = CHTypeMapping.parseType(remain);
            type.setNullable(true);
            return type;
        }
        throw new UnsupportedOperationException("Unsupported CH type: " + typeName);
    }
}

