/*
 * Decompiled with CFR 0.152.
 */
package shade.io.grpc.internal;

import com.pingcap.com.google.common.annotations.VisibleForTesting;
import com.pingcap.com.google.common.base.Verify;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import shade.io.grpc.CallOptions;
import shade.io.grpc.Channel;
import shade.io.grpc.ClientCall;
import shade.io.grpc.ClientInterceptor;
import shade.io.grpc.Deadline;
import shade.io.grpc.MethodDescriptor;
import shade.io.grpc.internal.HedgingPolicy;
import shade.io.grpc.internal.ManagedChannelServiceConfig;
import shade.io.grpc.internal.RetryPolicy;

final class ServiceConfigInterceptor
implements ClientInterceptor {
    @VisibleForTesting
    final AtomicReference<ManagedChannelServiceConfig> managedChannelServiceConfig = new AtomicReference();
    private final boolean retryEnabled;
    private volatile boolean initComplete;
    static final CallOptions.Key<RetryPolicy.Provider> RETRY_POLICY_KEY = CallOptions.Key.create("internal-retry-policy");
    static final CallOptions.Key<HedgingPolicy.Provider> HEDGING_POLICY_KEY = CallOptions.Key.create("internal-hedging-policy");

    ServiceConfigInterceptor(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    void handleUpdate(@Nullable ManagedChannelServiceConfig serviceConfig) {
        this.managedChannelServiceConfig.set(serviceConfig);
        this.initComplete = true;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        Integer existingLimit;
        ManagedChannelServiceConfig.MethodInfo info;
        if (this.retryEnabled) {
            if (this.initComplete) {
                final RetryPolicy retryPolicy = this.getRetryPolicyFromConfig(method);
                final HedgingPolicy hedgingPolicy = this.getHedgingPolicyFromConfig(method);
                Verify.verify(retryPolicy.equals(RetryPolicy.DEFAULT) || hedgingPolicy.equals(HedgingPolicy.DEFAULT), "Can not apply both retry and hedging policy for the method '%s'", method);
                final class ImmediateRetryPolicyProvider
                implements RetryPolicy.Provider {
                    ImmediateRetryPolicyProvider() {
                    }

                    @Override
                    public RetryPolicy get() {
                        return retryPolicy;
                    }
                }
                final class ImmediateHedgingPolicyProvider
                implements HedgingPolicy.Provider {
                    ImmediateHedgingPolicyProvider() {
                    }

                    @Override
                    public HedgingPolicy get() {
                        return hedgingPolicy;
                    }
                }
                callOptions = callOptions.withOption(RETRY_POLICY_KEY, new ImmediateRetryPolicyProvider()).withOption(HEDGING_POLICY_KEY, new ImmediateHedgingPolicyProvider());
            } else {
                final class DelayedRetryPolicyProvider
                implements RetryPolicy.Provider {
                    DelayedRetryPolicyProvider() {
                    }

                    @Override
                    public RetryPolicy get() {
                        if (!ServiceConfigInterceptor.this.initComplete) {
                            return RetryPolicy.DEFAULT;
                        }
                        return ServiceConfigInterceptor.this.getRetryPolicyFromConfig(method);
                    }
                }
                final class DelayedHedgingPolicyProvider
                implements HedgingPolicy.Provider {
                    DelayedHedgingPolicyProvider() {
                    }

                    @Override
                    public HedgingPolicy get() {
                        if (!ServiceConfigInterceptor.this.initComplete) {
                            return HedgingPolicy.DEFAULT;
                        }
                        HedgingPolicy hedgingPolicy = ServiceConfigInterceptor.this.getHedgingPolicyFromConfig(method);
                        Verify.verify(hedgingPolicy.equals(HedgingPolicy.DEFAULT) || ServiceConfigInterceptor.this.getRetryPolicyFromConfig(method).equals(RetryPolicy.DEFAULT), "Can not apply both retry and hedging policy for the method '%s'", (Object)method);
                        return hedgingPolicy;
                    }
                }
                callOptions = callOptions.withOption(RETRY_POLICY_KEY, new DelayedRetryPolicyProvider()).withOption(HEDGING_POLICY_KEY, new DelayedHedgingPolicyProvider());
            }
        }
        if ((info = this.getMethodInfo(method)) == null) {
            return next.newCall(method, callOptions);
        }
        if (info.timeoutNanos != null) {
            Deadline newDeadline = Deadline.after(info.timeoutNanos, TimeUnit.NANOSECONDS);
            Deadline existingDeadline = callOptions.getDeadline();
            if (existingDeadline == null || newDeadline.compareTo(existingDeadline) < 0) {
                callOptions = callOptions.withDeadline(newDeadline);
            }
        }
        if (info.waitForReady != null) {
            CallOptions callOptions2 = callOptions = info.waitForReady != false ? callOptions.withWaitForReady() : callOptions.withoutWaitForReady();
        }
        if (info.maxInboundMessageSize != null) {
            existingLimit = callOptions.getMaxInboundMessageSize();
            callOptions = existingLimit != null ? callOptions.withMaxInboundMessageSize(Math.min(existingLimit, info.maxInboundMessageSize)) : callOptions.withMaxInboundMessageSize(info.maxInboundMessageSize);
        }
        if (info.maxOutboundMessageSize != null) {
            existingLimit = callOptions.getMaxOutboundMessageSize();
            callOptions = existingLimit != null ? callOptions.withMaxOutboundMessageSize(Math.min(existingLimit, info.maxOutboundMessageSize)) : callOptions.withMaxOutboundMessageSize(info.maxOutboundMessageSize);
        }
        return next.newCall(method, callOptions);
    }

    @CheckForNull
    private ManagedChannelServiceConfig.MethodInfo getMethodInfo(MethodDescriptor<?, ?> method) {
        ManagedChannelServiceConfig mcsc = this.managedChannelServiceConfig.get();
        ManagedChannelServiceConfig.MethodInfo info = null;
        if (mcsc != null) {
            info = mcsc.getServiceMethodMap().get(method.getFullMethodName());
        }
        if (info == null && mcsc != null) {
            String serviceName = method.getServiceName();
            info = mcsc.getServiceMap().get(serviceName);
        }
        return info;
    }

    @VisibleForTesting
    RetryPolicy getRetryPolicyFromConfig(MethodDescriptor<?, ?> method) {
        ManagedChannelServiceConfig.MethodInfo info = this.getMethodInfo(method);
        return info == null ? RetryPolicy.DEFAULT : info.retryPolicy;
    }

    @VisibleForTesting
    HedgingPolicy getHedgingPolicyFromConfig(MethodDescriptor<?, ?> method) {
        ManagedChannelServiceConfig.MethodInfo info = this.getMethodInfo(method);
        return info == null ? HedgingPolicy.DEFAULT : info.hedgingPolicy;
    }
}

