/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint;

import com.pinterest.ktlint.KtlintCommandLine;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.ParseException;
import com.pinterest.ktlint.core.Reporter;
import com.pinterest.ktlint.core.ReporterProvider;
import com.pinterest.ktlint.core.RuleExecutionException;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.RuleSetProvider;
import com.pinterest.ktlint.internal.FileUtilsKt;
import com.pinterest.ktlint.internal.KtlintVersionProvider;
import com.pinterest.ktlint.reporter.plain.internal.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(headerHeading="An anti-bikeshedding Kotlin linter with built-in formatter\n(https://github.com/pinterest/ktlint).\n\nUsage:\n  ktlint <flags> [patterns]\n  java -jar ktlint <flags> [patterns]\n\nExamples:\n  # check the style of all Kotlin files inside the current dir (recursively)\n  # (hidden folders will be skipped)\n  ktlint\n\n  # check only certain locations (prepend ! to negate the pattern,\n  # Ktlint uses .gitignore pattern style syntax)\n  ktlint \"src/**/*.kt\" \"!src/**/*Test.kt\"\n\n  # auto-correct style violations\n  ktlint -F \"src/**/*.kt\"\n\n  # custom reporter\n  ktlint --reporter=plain?group_by_file\n  # multiple reporters can be specified like this\n  ktlint --reporter=plain \\\n    --reporter=checkstyle,output=ktlint-checkstyle-report.xml\n  # 3rd-party reporter\n  ktlint --reporter=csv,artifact=com.github.user:repo:master-SNAPSHOT\n\nFlags:", synopsisHeading="", customSynopsis={""}, sortOptions=false, mixinStandardHelpOptions=true, versionProvider=KtlintVersionProvider.class)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002]^B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010-\u001a\u00020.H\u0002J8\u0010/\u001a\u00020.2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u000202012\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r012\u0006\u00104\u001a\u000205H\u0002J8\u00106\u001a\u00020.2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u000202012\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r012\u0006\u00104\u001a\u000205H\u0002J\b\u00107\u001a\u000205H\u0002J*\u00108\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n :*\u0004\u0018\u00010909012\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\r0<H\u0002J*\u0010=\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n :*\u0004\u0018\u000102020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\r0<H\u0002J\u001c\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0A2\u0006\u0010B\u001a\u00020\rH\u0002JF\u0010C\u001a\b\u0012\u0004\u0012\u00020D0<2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u000202012\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r01H\u0002J&\u0010G\u001a\u00020.2\u0006\u0010E\u001a\u00020\r2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020D0<2\u0006\u00104\u001a\u000205H\u0002J\u0006\u0010I\u001a\u00020.J&\u0010J\u001a\b\u0012\u0004\u0012\u0002HK0<\"\u0004\b\u0000\u0010K*\b\u0012\u0004\u0012\u0002HK0<2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010L\u001a\u00020.*\u00020MH\u0002J<\u0010N\u001a\u00020.\"\u0004\b\u0000\u0010K*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0P0O2\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u0002HK\u0012\u0004\u0012\u00020.0R2\b\b\u0002\u0010S\u001a\u00020\u001fH\u0002J \u0010T\u001a\u0010\u0012\f\u0012\n :*\u0004\u0018\u00010U0U0<*\b\u0012\u0004\u0012\u00020\r0<H\u0002J\u0010\u0010V\u001a\u00020W*\u00060Xj\u0002`YH\u0002J \u0010Z\u001a\u000205*\u00020[2\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020901H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001e\u0010\u0015\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\u00020\u001f8B@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\bR\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0#8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0#8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/pinterest/ktlint/KtlintCommandLine;", "", "()V", "android", "", "getAndroid", "()Z", "setAndroid", "(Z)V", "color", "getColor", "setColor", "colorName", "", "getColorName", "()Ljava/lang/String;", "setColorName", "(Ljava/lang/String;)V", "debug", "getDebug", "setDebug", "disabledRules", "getDisabledRules", "setDisabledRules", "editorConfigPath", "errorNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "experimental", "fileNumber", "format", "limit", "", "getLimit", "()I", "patterns", "Ljava/util/ArrayList;", "relative", "getRelative", "setRelative", "reporters", "rulesets", "stdin", "tripped", "Ljava/util/concurrent/atomic/AtomicBoolean;", "verbose", "failOnOldRulesetProviderUsage", "", "lintFiles", "ruleSetProviders", "", "Lcom/pinterest/ktlint/core/RuleSetProvider;", "userData", "reporter", "Lcom/pinterest/ktlint/core/Reporter;", "lintStdin", "loadReporter", "loadReporters", "Lcom/pinterest/ktlint/core/ReporterProvider;", "kotlin.jvm.PlatformType", "externalReportersJarPaths", "", "loadRulesets", "Ljava/util/SortedMap;", "externalRulesetsJarPaths", "parseQuery", "Ljava/util/LinkedHashMap;", "query", "process", "Lcom/pinterest/ktlint/KtlintCommandLine$LintErrorWithCorrectionInfo;", "fileName", "fileContent", "report", "errList", "run", "head", "T", "mkdirsOrFail", "Ljava/io/File;", "parallel", "Lkotlin/sequences/Sequence;", "Ljava/util/concurrent/Callable;", "cb", "Lkotlin/Function1;", "numberOfThreads", "toFilesURIList", "Ljava/net/URL;", "toLintError", "Lcom/pinterest/ktlint/core/LintError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "toReporter", "Lcom/pinterest/ktlint/KtlintCommandLine$ReporterTemplate;", "reporterProviderById", "LintErrorWithCorrectionInfo", "ReporterTemplate", "ktlint"})
public final class KtlintCommandLine {
    @CommandLine.Option(names={"--android", "-a"}, description={"Turn on Android Kotlin Style Guide compatibility"})
    private boolean android;
    @CommandLine.Option(names={"--color"}, description={"Make output colorful"})
    private boolean color;
    @CommandLine.Option(names={"--color-name"}, description={"Customize the output color"})
    @NotNull
    private String colorName = Color.DARK_GRAY.name();
    @CommandLine.Option(names={"--debug"}, description={"Turn on debug output"})
    private boolean debug;
    @CommandLine.Option(names={"--disabled_rules"}, description={"Comma-separated list of rules to globally disable"})
    @NotNull
    private String disabledRules = "";
    @CommandLine.Option(names={"--format", "-F"}, description={"Fix any deviations from the code style"})
    private boolean format;
    @CommandLine.Option(names={"--limit"}, description={"Maximum number of errors to show (default: show all)"})
    private int limit = -1;
    @CommandLine.Option(names={"--relative"}, description={"Print files relative to the working directory (e.g. dir/file.kt instead of /home/user/project/dir/file.kt)"})
    private boolean relative;
    @CommandLine.Option(names={"--reporter"}, description={"A reporter to use (built-in: plain (default), plain?group_by_file, json, checkstyle, html). To use a third-party reporter specify a path to a JAR file on the filesystem."})
    private ArrayList<String> reporters = new ArrayList();
    @CommandLine.Option(names={"--ruleset", "-R"}, description={"A path to a JAR file containing additional ruleset(s)"})
    private ArrayList<String> rulesets = new ArrayList();
    @CommandLine.Option(names={"--stdin"}, description={"Read file from stdin"})
    private boolean stdin;
    @CommandLine.Option(names={"--verbose", "-v"}, description={"Show error codes"})
    private boolean verbose;
    @CommandLine.Option(names={"--editorconfig"}, description={"Path to .editorconfig"})
    private String editorConfigPath;
    @CommandLine.Option(names={"--experimental"}, description={"Enabled experimental rules (ktlint-ruleset-experimental)"})
    private boolean experimental;
    @CommandLine.Parameters(hidden=true)
    private ArrayList<String> patterns = new ArrayList();
    private final AtomicBoolean tripped = new AtomicBoolean();
    private final AtomicInteger fileNumber = new AtomicInteger();
    private final AtomicInteger errorNumber = new AtomicInteger();

    public final boolean getAndroid() {
        return this.android;
    }

    public final void setAndroid(boolean bl) {
        this.android = bl;
    }

    public final boolean getColor() {
        return this.color;
    }

    public final void setColor(boolean bl) {
        this.color = bl;
    }

    @NotNull
    public final String getColorName() {
        return this.colorName;
    }

    public final void setColorName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.colorName = string;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final String getDisabledRules() {
        return this.disabledRules;
    }

    public final void setDisabledRules(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.disabledRules = string;
    }

    private final int getLimit() {
        return this.limit < 0 ? Integer.MAX_VALUE : this.limit;
    }

    public final boolean getRelative() {
        return this.relative;
    }

    public final void setRelative(boolean bl) {
        this.relative = bl;
    }

    public final void run() {
        this.failOnOldRulesetProviderUsage();
        long start = System.currentTimeMillis();
        SortedMap<String, RuleSetProvider> ruleSetProviders = this.loadRulesets((List<String>)this.rulesets);
        Reporter reporter = this.loadReporter();
        Object[] objectArray = new Pair[2];
        objectArray[0] = TuplesKt.to((Object)"android", (Object)String.valueOf(this.android));
        CharSequence charSequence = this.disabledRules;
        int n = 1;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        objectArray2[n] = bl2 ? TuplesKt.to((Object)"disabled_rules", (Object)this.disabledRules) : null;
        Map userData = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray3));
        reporter.beforeAll();
        if (this.stdin) {
            this.lintStdin((Map<String, ? extends RuleSetProvider>)ruleSetProviders, userData, reporter);
        } else {
            this.lintFiles((Map<String, ? extends RuleSetProvider>)ruleSetProviders, userData, reporter);
        }
        reporter.afterAll();
        if (this.debug) {
            System.err.println("[DEBUG] " + (System.currentTimeMillis() - start) + "ms / " + this.fileNumber + " file(s) / " + this.errorNumber + " error(s)");
        }
        if (this.tripped.get()) {
            int n2 = 1;
            bl = false;
            System.exit(n2);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void lintFiles(Map<String, ? extends RuleSetProvider> ruleSetProviders, Map<String, String> userData, Reporter reporter) {
        KtlintCommandLine.parallel$default(this, SequencesKt.map((Sequence)SequencesKt.takeWhile(FileUtilsKt.fileSequence((List<String>)this.patterns), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ KtlintCommandLine this$0;

            public final boolean invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return KtlintCommandLine.access$getErrorNumber$p(this.this$0).get() < KtlintCommandLine.access$getLimit$p(this.this$0);
            }
            {
                this.this$0 = ktlintCommandLine;
                super(1);
            }
        })), (Function1)((Function1)new Function1<File, Callable<Pair<? extends File, ? extends List<? extends LintErrorWithCorrectionInfo>>>>(this, ruleSetProviders, userData){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ Map $ruleSetProviders;
            final /* synthetic */ Map $userData;

            @NotNull
            public final Callable<Pair<File, List<LintErrorWithCorrectionInfo>>> invoke(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                return new Callable<Pair<? extends File, ? extends List<? extends LintErrorWithCorrectionInfo>>>(this, file){
                    final /* synthetic */ lintFiles.2 this$0;
                    final /* synthetic */ File $file;

                    @NotNull
                    public final Pair<File, List<LintErrorWithCorrectionInfo>> call() {
                        KtlintCommandLine ktlintCommandLine = this.this$0.this$0;
                        String string = this.$file.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                        return TuplesKt.to((Object)this.$file, (Object)KtlintCommandLine.access$process(ktlintCommandLine, string, FilesKt.readText$default((File)this.$file, null, (int)1, null), this.this$0.$ruleSetProviders, this.this$0.$userData));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$file = file;
                    }
                };
            }
            {
                this.this$0 = ktlintCommandLine;
                this.$ruleSetProviders = map;
                this.$userData = map2;
                super(1);
            }
        })), (Function1)new Function1<Pair<? extends File, ? extends List<? extends LintErrorWithCorrectionInfo>>, Unit>(this, reporter){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ Reporter $reporter;

            public final void invoke(Pair<? extends File, ? extends List<LintErrorWithCorrectionInfo>> $dstr$file$errList) {
                File file = (File)$dstr$file$errList.component1();
                List errList = (List)$dstr$file$errList.component2();
                String string = FileUtilsKt.location(file, this.this$0.getRelative());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.location(relative)");
                KtlintCommandLine.access$report(this.this$0, string, errList, this.$reporter);
            }
            {
                this.this$0 = ktlintCommandLine;
                this.$reporter = reporter;
                super(1);
            }
        }, 0, 2, null);
    }

    private final void lintStdin(Map<String, ? extends RuleSetProvider> ruleSetProviders, Map<String, String> userData, Reporter reporter) {
        InputStream inputStream = System.in;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"System.`in`");
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        String string = "<stdin>";
        KtlintCommandLine ktlintCommandLine = this;
        String string2 = "<stdin>";
        KtlintCommandLine ktlintCommandLine2 = this;
        boolean bl = false;
        String string3 = new String(byArray, Charsets.UTF_8);
        ktlintCommandLine2.report(string2, ktlintCommandLine.process(string, string3, ruleSetProviders, userData), reporter);
    }

    private final void failOnOldRulesetProviderUsage() {
        ServiceLoader<com.github.shyiko.ktlint.core.RuleSetProvider> serviceLoader = ServiceLoader.load(com.github.shyiko.ktlint.core.RuleSetProvider.class);
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader.load(com.g\u2026eSetProvider::class.java)");
        if (CollectionsKt.any((Iterable)serviceLoader)) {
            System.err.println("[ERROR] Cannot load custom ruleset!");
            System.err.println("[ERROR] RuleSetProvider has moved to com.pinterest.ktlint.core.");
            System.err.println("[ERROR] Please rename META-INF/services/com.github.shyiko.ktlint.core.RuleSetProvider to META-INF/services/com.pinterest.ktlint.core.RuleSetProvider");
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void report(String fileName, List<LintErrorWithCorrectionInfo> errList, Reporter reporter) {
        this.fileNumber.incrementAndGet();
        int n = errList.size();
        int n2 = this.getLimit() - this.errorNumber.get();
        int n3 = 0;
        boolean bl = false;
        n2 = Math.max(n2, n3);
        n3 = 0;
        int errListLimit = Math.min(n, n2);
        this.errorNumber.addAndGet(errListLimit);
        reporter.before(fileName);
        Iterable $this$forEach$iv = this.head(errList, errListLimit);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LintErrorWithCorrectionInfo $dstr$err$corrected = (LintErrorWithCorrectionInfo)element$iv;
            boolean bl2 = false;
            LintError err = $dstr$err$corrected.component1();
            boolean corrected = $dstr$err$corrected.component2();
            reporter.onLintError(fileName, !err.getCanBeAutoCorrected() ? LintError.copy$default((LintError)err, (int)0, (int)0, null, (String)(err.getDetail() + " (cannot be auto-corrected)"), (int)7, null) : err, corrected);
        }
        reporter.after(fileName);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LintErrorWithCorrectionInfo> process(String fileName, String fileContent, Map<String, ? extends RuleSetProvider> ruleSetProviders, Map<String, String> userData) {
        if (this.debug) {
            String fileLocation = Intrinsics.areEqual((Object)fileName, (Object)"<stdin>") ^ true ? FileUtilsKt.location(new File(fileName), this.relative) : fileName;
            System.err.println("[DEBUG] Checking " + fileLocation);
        }
        ArrayList<LintErrorWithCorrectionInfo> result = new ArrayList<LintErrorWithCorrectionInfo>();
        if (this.format) {
            Object object;
            String $this$map$iv2;
            Object object2;
            String string;
            try {
                void $this$mapTo$iv$iv;
                Map<String, ? extends RuleSetProvider> map = ruleSetProviders;
                string = fileContent;
                object2 = fileName;
                boolean $i$f$map = false;
                void var9_16 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList($this$map$iv2.size());
                boolean $i$f$mapTo = false;
                void var12_22 = $this$mapTo$iv$iv;
                boolean bl = false;
                Iterator iterator = var12_22.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv2;
                    Map.Entry entry = item$iv$iv2 = iterator.next();
                    object = destination$iv$iv;
                    boolean bl2 = false;
                    RuleSet ruleSet = ((RuleSetProvider)it.getValue()).get();
                    object.add(ruleSet);
                }
                object = (List)destination$iv$iv;
                $this$map$iv2 = FileUtilsKt.formatFile((String)object2, string, (Iterable)object, userData, this.editorConfigPath, this.debug, (Function2<? super LintError, ? super Boolean, Unit>)((Function2)new Function2<LintError, Boolean, Unit>(this, result){
                    final /* synthetic */ KtlintCommandLine this$0;
                    final /* synthetic */ ArrayList $result;

                    public final void invoke(@NotNull LintError err, boolean corrected) {
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        if (!corrected) {
                            this.$result.add(new LintErrorWithCorrectionInfo(err, corrected));
                            KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                        }
                    }
                    {
                        this.this$0 = ktlintCommandLine;
                        this.$result = arrayList;
                        super(2);
                    }
                }));
            }
            catch (Exception e) {
                result.add(new LintErrorWithCorrectionInfo(this.toLintError(e), false));
                this.tripped.set(true);
                $this$map$iv2 = fileContent;
            }
            String formattedFileContent2 = $this$map$iv2;
            if (this.stdin) {
                boolean $this$map$iv2 = false;
                System.out.print((Object)formattedFileContent2);
            } else if (fileContent != formattedFileContent2) {
                $this$map$iv2 = "UTF-8";
                string = formattedFileContent2;
                object2 = new File(fileName);
                boolean e = false;
                Charset charset = Charset.forName($this$map$iv2);
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                object = charset;
                FilesKt.writeText((File)object2, (String)string, (Charset)object);
            }
        } else {
            try {
                Collection<RuleSet> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map<String, ? extends RuleSetProvider> formattedFileContent2 = ruleSetProviders;
                String string = fileContent;
                String string2 = fileName;
                boolean $i$f$map = false;
                void e = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                void var11_21 = $this$mapTo$iv$iv;
                boolean bl = false;
                Iterator iterator = var11_21.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry item$iv$iv2 = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    RuleSet ruleSet = ((RuleSetProvider)it.getValue()).get();
                    collection.add(ruleSet);
                }
                collection = (List)destination$iv$iv;
                FileUtilsKt.lintFile(string2, string, (List<RuleSet>)collection, userData, this.editorConfigPath, this.debug, (Function1<? super LintError, Unit>)((Function1)new Function1<LintError, Unit>(this, result){
                    final /* synthetic */ KtlintCommandLine this$0;
                    final /* synthetic */ ArrayList $result;

                    public final void invoke(@NotNull LintError err) {
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        this.$result.add(new LintErrorWithCorrectionInfo(err, false));
                        KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                    }
                    {
                        this.this$0 = ktlintCommandLine;
                        this.$result = arrayList;
                        super(1);
                    }
                }));
            }
            catch (Exception e) {
                result.add(new LintErrorWithCorrectionInfo(this.toLintError(e), false));
                this.tripped.set(true);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Reporter loadReporter() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object object;
        String string;
        Object object2;
        void $this$mapTo$iv$iv2;
        List configuredReporters = this.reporters.isEmpty() ? CollectionsKt.listOf((Object)"plain") : (List)this.reporters;
        Iterable $this$map$iv2 = configuredReporters;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            String string2;
            String string3;
            Map map;
            String string4;
            Object $this$lastOrNull$iv;
            boolean $i$f$lastOrNull;
            void var19_41;
            block11: {
                String string5;
                String string6;
                String rawReporterConfig;
                List split;
                block10: {
                    void reporterId;
                    void reporter;
                    String string7 = (String)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl = false;
                    split = StringsKt.split$default((CharSequence)((CharSequence)reporter), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                    Object object3 = new String[]{"?"};
                    boolean bl2 = false;
                    int n = 2;
                    List list = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)((CharSequence)split.get(0)), (String[])object3, (boolean)bl2, (int)n, (int)2, null), (Iterable)CollectionsKt.listOf((Object)""));
                    object3 = list;
                    bl2 = false;
                    string = (String)object3.get(0);
                    object3 = list;
                    bl2 = false;
                    rawReporterConfig = (String)object3.get(1);
                    list = split;
                    var19_41 = reporterId;
                    $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"artifact=", (boolean)false, (int)2, null)) continue;
                        string6 = (String)element$iv;
                        break block10;
                    }
                    string6 = null;
                }
                string4 = string6;
                void v1 = var19_41;
                String string8 = string4;
                if (string8 != null) {
                    $this$lastOrNull$iv = string8;
                    var19_41 = v1;
                    $i$f$lastOrNull = false;
                    boolean iterator$iv = false;
                    String it = $this$lastOrNull$iv;
                    boolean bl = false;
                    string4 = (String)StringsKt.split$default((CharSequence)it, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null).get(1);
                    v1 = var19_41;
                    string5 = string4;
                } else {
                    string5 = null;
                }
                $this$lastOrNull$iv = split;
                map = MapsKt.plus((Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"verbose", (Object)String.valueOf(this.verbose)), TuplesKt.to((Object)"color", (Object)String.valueOf(this.color)), TuplesKt.to((Object)"color_name", (Object)this.colorName)}), (Map)this.parseQuery(rawReporterConfig));
                string4 = string5;
                var19_41 = v1;
                $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"output=", (boolean)false, (int)2, null)) continue;
                    string3 = (String)element$iv;
                    break block11;
                }
                string3 = null;
            }
            String string9 = string3;
            void v5 = var19_41;
            String string10 = string4;
            Map map2 = map;
            String string11 = string9;
            if (string11 != null) {
                $this$lastOrNull$iv = string11;
                map = map2;
                string4 = string10;
                var19_41 = v5;
                $i$f$lastOrNull = false;
                boolean iterator$iv = false;
                Object it = $this$lastOrNull$iv;
                boolean bl = false;
                string9 = (String)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null).get(1);
                v5 = var19_41;
                string10 = string4;
                map2 = map;
                string2 = string9;
            } else {
                string2 = null;
            }
            String string12 = string2;
            Map map3 = map2;
            String string13 = string10;
            void var33_57 = v5;
            object = new ReporterTemplate((String)var33_57, string13, map3, string12);
            object2.add(object);
        }
        List tpls = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = tpls;
        object2 = this;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl4 = false;
            ReporterTemplate it = (ReporterTemplate)element$iv$iv;
            boolean bl5 = false;
            if (it.getArtifact() == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            String it$iv$iv = string;
            boolean bl8 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        object = (List)destination$iv$iv2;
        Map<String, ReporterProvider> reporterProviderById = super.loadReporters((List<String>)object);
        $this$mapNotNull$iv = tpls;
        object2 = Reporter.Companion;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            bl = (ReporterTemplate)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl9 = false;
            Reporter reporter = this.toReporter((ReporterTemplate)it, reporterProviderById);
            object.add(reporter);
        }
        object = (List)destination$iv$iv2;
        $this$map$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Reporter[] reporterArray = thisCollection$iv.toArray(new Reporter[0]);
        if (reporterArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        object = reporterArray;
        Reporter[] reporterArray2 = (Reporter[])object;
        return object2.from(Arrays.copyOf(reporterArray2, reporterArray2.length));
    }

    private final Reporter toReporter(@NotNull ReporterTemplate $this$toReporter, Map<String, ? extends ReporterProvider> reporterProviderById) {
        PrintStream stream;
        PrintStream printStream;
        boolean bl;
        ReporterProvider reporterProvider;
        block7: {
            String string;
            StringBuilder stringBuilder;
            PrintStream printStream2;
            block9: {
                block8: {
                    reporterProvider = reporterProviderById.get($this$toReporter.getId());
                    if (reporterProvider == null) {
                        System.err.println("Error: reporter \"" + $this$toReporter.getId() + "\" wasn't found (available: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)reporterProviderById.keySet()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')');
                        int n = 1;
                        boolean bl2 = false;
                        System.exit(n);
                        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                    if (!this.debug) break block7;
                    printStream2 = System.err;
                    stringBuilder = new StringBuilder().append("[DEBUG] Initializing \"").append($this$toReporter.getId()).append("\" reporter with ").append($this$toReporter.getConfig());
                    string = $this$toReporter.getOutput();
                    if (string == null) break block8;
                    String string2 = string;
                    StringBuilder stringBuilder2 = stringBuilder;
                    PrintStream printStream3 = printStream2;
                    boolean bl3 = false;
                    bl = false;
                    String it = string2;
                    boolean bl4 = false;
                    String string3 = ", output=" + it;
                    printStream2 = printStream3;
                    stringBuilder = stringBuilder2;
                    string = string3;
                    if (string != null) break block9;
                }
                string = "";
            }
            printStream2.println(stringBuilder.append((Object)string).toString());
        }
        if ($this$toReporter.getOutput() != null) {
            File file = new File($this$toReporter.getOutput()).getParentFile();
            if (file != null) {
                this.mkdirsOrFail(file);
            }
            printStream = new PrintStream($this$toReporter.getOutput(), "UTF-8");
        } else {
            printStream = this.stdin ? System.err : System.out;
        }
        PrintStream printStream4 = stream = printStream;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream4, (String)"stream");
        Reporter reporter = reporterProvider.get(printStream4, $this$toReporter.getConfig());
        bl = false;
        boolean bl5 = false;
        Reporter reporter2 = reporter;
        boolean bl6 = false;
        return $this$toReporter.getOutput() != null ? (Reporter)new Reporter(reporter2, this, $this$toReporter, stream){
            private final /* synthetic */ Reporter $$delegate_0;
            final /* synthetic */ Reporter $reporter;
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ ReporterTemplate $this_toReporter$inlined;
            final /* synthetic */ PrintStream $stream$inlined;
            {
                this.$reporter = $captured_local_variable$1;
                this.this$0 = ktlintCommandLine;
                this.$this_toReporter$inlined = reporterTemplate;
                this.$stream$inlined = printStream;
                this.$$delegate_0 = $captured_local_variable$1;
            }

            public void afterAll() {
                this.$reporter.afterAll();
                this.$stream$inlined.close();
                if (KtlintCommandLine.access$getTripped$p(this.this$0).get()) {
                    File file = new File(this.$this_toReporter$inlined.getOutput()).getAbsoluteFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(output).absoluteFile");
                    String outputLocation = FileUtilsKt.location(file, this.this$0.getRelative());
                    System.err.println('\"' + this.$this_toReporter$inlined.getId() + "\" report written to " + outputLocation);
                }
            }

            public void after(@NotNull String file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                this.$$delegate_0.after(file);
            }

            public void before(@NotNull String file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                this.$$delegate_0.before(file);
            }

            public void beforeAll() {
                this.$$delegate_0.beforeAll();
            }

            public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                this.$$delegate_0.onLintError(file, err, corrected);
            }
        } : reporter2;
    }

    private final LintError toLintError(@NotNull Exception $this$toLintError) {
        LintError lintError;
        Exception exception = $this$toLintError;
        boolean bl = false;
        boolean bl2 = false;
        Exception e = exception;
        boolean bl3 = false;
        Exception exception2 = e;
        if (exception2 instanceof ParseException) {
            String string;
            int n = ((ParseException)e).getLine();
            int n2 = ((ParseException)e).getCol();
            String string2 = "";
            StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
            String string3 = e.getMessage();
            if (string3 != null) {
                String string4 = string3;
                StringBuilder stringBuilder2 = stringBuilder;
                String string5 = string2;
                int n3 = n2;
                int n4 = n;
                boolean bl4 = false;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
                String string8 = string7;
                n = n4;
                n2 = n3;
                string2 = string5;
                stringBuilder = stringBuilder2;
                string = string8;
            } else {
                string = null;
            }
            String string9 = stringBuilder.append(string).append(')').toString();
            String string10 = string2;
            int n5 = n2;
            int n6 = n;
            lintError = new LintError(n6, n5, string10, string9);
        } else if (exception2 instanceof RuleExecutionException) {
            if (this.debug) {
                System.err.println("[DEBUG] Internal Error (" + ((RuleExecutionException)e).getRuleId() + ')');
                e.printStackTrace(System.err);
            }
            lintError = new LintError(((RuleExecutionException)e).getLine(), ((RuleExecutionException)e).getCol(), "", "Internal Error (" + ((RuleExecutionException)e).getRuleId() + "). " + "Please create a ticket at https://github.com/pinterest/ktlint/issues " + "(if possible, provide the source code that triggered an error)");
        } else {
            throw (Throwable)e;
        }
        return lintError;
    }

    private final <T> List<T> head(@NotNull List<? extends T> $this$head, int limit) {
        return limit == $this$head.size() ? $this$head : $this$head.subList(0, limit);
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashMap<String, String> parseQuery(String query) {
        void $this$fold$iv;
        Iterable iterable = StringsKt.split$default((CharSequence)query, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
        LinkedHashMap<String, String> initial$iv = new LinkedHashMap<String, String>();
        boolean $i$f$fold = false;
        LinkedHashMap<String, String> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void s;
            String string = (String)element$iv;
            LinkedHashMap<String, String> map = accumulator$iv;
            boolean bl = false;
            Object object = (String[])s;
            boolean bl2 = false;
            if (!(object.length() == 0)) {
                Object object2;
                object = new String[]{"="};
                bl2 = false;
                int n = 2;
                object = StringsKt.split$default((CharSequence)((CharSequence)s), (String[])object, (boolean)bl2, (int)n, (int)2, null);
                bl2 = false;
                n = 0;
                Object e = object;
                boolean bl3 = false;
                Object object3 = e;
                int n2 = 1;
                Object e2 = e.get(0);
                LinkedHashMap<String, String> linkedHashMap = map;
                boolean bl4 = false;
                if (n2 <= CollectionsKt.getLastIndex((List)object3)) {
                    object2 = object3.get(n2);
                } else {
                    int it = n2;
                    boolean bl5 = false;
                    object2 = "true";
                }
                Object e3 = object2;
                linkedHashMap.put((String)e2, URLDecoder.decode((String)e3, "UTF-8"));
            }
            accumulator$iv = map;
        }
        return accumulator$iv;
    }

    private final void mkdirsOrFail(@NotNull File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.isDirectory()) {
            throw (Throwable)new IOException("Unable to create \"" + $this$mkdirsOrFail + "\" directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void parallel(@NotNull Sequence<? extends Callable<T>> $this$parallel, Function1<? super T, Unit> cb, int numberOfThreads) {
        Future pill2 = new Future<T>(){

            public boolean isDone() {
                throw (Throwable)new UnsupportedOperationException();
            }

            public T get(long timeout, @NotNull TimeUnit unit) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
                throw (Throwable)new UnsupportedOperationException();
            }

            public T get() {
                throw (Throwable)new UnsupportedOperationException();
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                throw (Throwable)new UnsupportedOperationException();
            }

            public boolean isCancelled() {
                throw (Throwable)new UnsupportedOperationException();
            }
        };
        ArrayBlockingQueue q = new ArrayBlockingQueue(numberOfThreads);
        Thread producer2 = ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>($this$parallel, q, pill2){
            final /* synthetic */ Sequence $this_parallel;
            final /* synthetic */ ArrayBlockingQueue $q;
            final /* synthetic */ parallel.pill.1 $pill;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                ExecutorService executorService = Executors.newCachedThreadPool();
                try {
                    for (Callable task : this.$this_parallel) {
                        this.$q.put(executorService.submit(task));
                    }
                    this.$q.put(this.$pill);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    executorService.shutdown();
                }
            }
            {
                this.$this_parallel = sequence;
                this.$q = arrayBlockingQueue;
                this.$pill = var3_3;
                super(0);
            }
        }), (int)30, null);
        try {
            Future result;
            while (Intrinsics.areEqual((Object)(result = (Future)q.take()), (Object)pill2) ^ true) {
                cb.invoke(result.get());
            }
        }
        finally {
            producer2.interrupt();
            producer2.join();
        }
    }

    static /* synthetic */ void parallel$default(KtlintCommandLine ktlintCommandLine, Sequence sequence, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        ktlintCommandLine.parallel(sequence, function1, n);
    }

    /*
     * WARNING - void declaration
     */
    private final SortedMap<String, RuleSetProvider> loadRulesets(List<String> externalRulesetsJarPaths) {
        Map $this$associateByTo$iv$iv;
        URL[] uRLArray;
        void $this$toTypedArray$iv;
        Object object = this.toFilesURIList(externalRulesetsJarPaths);
        Object object2 = RuleSetProvider.class;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray2 = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        URL[] uRLArray3 = uRLArray = uRLArray2;
        ServiceLoader<RuleSetProvider> serviceLoader = ServiceLoader.load(object2, new URLClassLoader(uRLArray3));
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader\n        .l\u2026toTypedArray())\n        )");
        Iterable $this$associateBy$iv = serviceLoader;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object element$iv$iv = iterator.next();
            RuleSetProvider ruleSetProvider = (RuleSetProvider)element$iv$iv;
            object2 = destination$iv$iv22;
            boolean bl = false;
            String key = it.get().getId();
            String string = Intrinsics.areEqual((Object)key, (Object)"standard") ? '\u0000' + key : key;
            object2.put(string, element$iv$iv);
        }
        Map $this$filterKeys$iv = destination$iv$iv22;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        $this$associateByTo$iv$iv = $this$filterKeys$iv;
        boolean destination$iv$iv22 = false;
        for (Map.Entry entry$iv : $this$associateByTo$iv$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!(this.experimental || Intrinsics.areEqual((Object)it, (Object)"experimental") ^ true)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        object = MapsKt.toSortedMap((Map)result$iv);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        if (this.debug) {
            Map $this$forEach$iv = (Map)it;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl5 = false;
                String string = "[DEBUG] Discovered ruleset with \"" + (String)entry.getKey() + "\" id.";
                boolean bl6 = false;
                System.out.println((Object)string);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ReporterProvider> loadReporters(List<String> externalReportersJarPaths) {
        void $this$associateByTo$iv$iv;
        URL[] uRLArray;
        void $this$toTypedArray$iv;
        Object object = this.toFilesURIList(externalReportersJarPaths);
        Object object2 = ReporterProvider.class;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray2 = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        URL[] uRLArray3 = uRLArray = uRLArray2;
        ServiceLoader<ReporterProvider> serviceLoader = ServiceLoader.load(object2, new URLClassLoader(uRLArray3));
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader\n        .l\u2026toTypedArray())\n        )");
        Iterable $this$associateBy$iv = serviceLoader;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ReporterProvider reporterProvider = (ReporterProvider)element$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getId();
            object2.put(string, element$iv$iv);
        }
        object = destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        if (this.debug) {
            Object $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            Object object3 = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = object3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl5 = false;
                String string = "[DEBUG] Discovered reporter with \"" + (String)entry.getKey() + "\" id.";
                boolean bl6 = false;
                System.out.println((Object)string);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<URL> toFilesURIList(@NotNull List<String> $this$toFilesURIList) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toFilesURIList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File jarFile = new File(FileUtilsKt.expandTilde((String)it));
            if (!jarFile.exists()) {
                String string2 = "Error: " + (String)it + " does not exist";
                boolean bl2 = false;
                System.out.println((Object)string2);
                int n = 1;
                bl2 = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            URL uRL = jarFile.toURI().toURL();
            collection.add(uRL);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ int access$getLimit$p(KtlintCommandLine $this) {
        return $this.getLimit();
    }

    public static final /* synthetic */ void access$setLimit$p(KtlintCommandLine $this, int n) {
        $this.limit = n;
    }

    public static final /* synthetic */ AtomicInteger access$getErrorNumber$p(KtlintCommandLine $this) {
        return $this.errorNumber;
    }

    public static final /* synthetic */ List access$process(KtlintCommandLine $this, String fileName, String fileContent, Map ruleSetProviders, Map userData) {
        return $this.process(fileName, fileContent, ruleSetProviders, userData);
    }

    public static final /* synthetic */ void access$report(KtlintCommandLine $this, String fileName, List errList, Reporter reporter) {
        $this.report(fileName, errList, reporter);
    }

    public static final /* synthetic */ AtomicBoolean access$getTripped$p(KtlintCommandLine $this) {
        return $this.tripped;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/KtlintCommandLine$LintErrorWithCorrectionInfo;", "", "err", "Lcom/pinterest/ktlint/core/LintError;", "corrected", "", "(Lcom/pinterest/ktlint/core/LintError;Z)V", "getCorrected", "()Z", "getErr", "()Lcom/pinterest/ktlint/core/LintError;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "ktlint"})
    private static final class LintErrorWithCorrectionInfo {
        @NotNull
        private final LintError err;
        private final boolean corrected;

        @NotNull
        public final LintError getErr() {
            return this.err;
        }

        public final boolean getCorrected() {
            return this.corrected;
        }

        public LintErrorWithCorrectionInfo(@NotNull LintError err, boolean corrected) {
            Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
            this.err = err;
            this.corrected = corrected;
        }

        @NotNull
        public final LintError component1() {
            return this.err;
        }

        public final boolean component2() {
            return this.corrected;
        }

        @NotNull
        public final LintErrorWithCorrectionInfo copy(@NotNull LintError err, boolean corrected) {
            Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
            return new LintErrorWithCorrectionInfo(err, corrected);
        }

        public static /* synthetic */ LintErrorWithCorrectionInfo copy$default(LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo, LintError lintError, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                lintError = lintErrorWithCorrectionInfo.err;
            }
            if ((n & 2) != 0) {
                bl = lintErrorWithCorrectionInfo.corrected;
            }
            return lintErrorWithCorrectionInfo.copy(lintError, bl);
        }

        @NotNull
        public String toString() {
            return "LintErrorWithCorrectionInfo(err=" + this.err + ", corrected=" + this.corrected + ")";
        }

        public int hashCode() {
            LintError lintError = this.err;
            int n = (lintError != null ? lintError.hashCode() : 0) * 31;
            int n2 = this.corrected ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LintErrorWithCorrectionInfo)) break block3;
                    LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo = (LintErrorWithCorrectionInfo)object;
                    if (!Intrinsics.areEqual((Object)this.err, (Object)lintErrorWithCorrectionInfo.err) || this.corrected != lintErrorWithCorrectionInfo.corrected) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JA\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/pinterest/ktlint/KtlintCommandLine$ReporterTemplate;", "", "id", "", "artifact", "config", "", "output", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getArtifact", "()Ljava/lang/String;", "getConfig", "()Ljava/util/Map;", "getId", "getOutput", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "ktlint"})
    private static final class ReporterTemplate {
        @NotNull
        private final String id;
        @Nullable
        private final String artifact;
        @NotNull
        private final Map<String, String> config;
        @Nullable
        private final String output;

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getArtifact() {
            return this.artifact;
        }

        @NotNull
        public final Map<String, String> getConfig() {
            return this.config;
        }

        @Nullable
        public final String getOutput() {
            return this.output;
        }

        public ReporterTemplate(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            this.id = id;
            this.artifact = artifact;
            this.config = config;
            this.output = output;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.artifact;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.config;
        }

        @Nullable
        public final String component4() {
            return this.output;
        }

        @NotNull
        public final ReporterTemplate copy(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            return new ReporterTemplate(id, artifact, config, output);
        }

        public static /* synthetic */ ReporterTemplate copy$default(ReporterTemplate reporterTemplate, String string, String string2, Map map, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reporterTemplate.id;
            }
            if ((n & 2) != 0) {
                string2 = reporterTemplate.artifact;
            }
            if ((n & 4) != 0) {
                map = reporterTemplate.config;
            }
            if ((n & 8) != 0) {
                string3 = reporterTemplate.output;
            }
            return reporterTemplate.copy(string, string2, map, string3);
        }

        @NotNull
        public String toString() {
            return "ReporterTemplate(id=" + this.id + ", artifact=" + this.artifact + ", config=" + this.config + ", output=" + this.output + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.artifact;
            Map<String, String> map = this.config;
            String string3 = this.output;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ReporterTemplate)) break block3;
                    ReporterTemplate reporterTemplate = (ReporterTemplate)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)reporterTemplate.id) || !Intrinsics.areEqual((Object)this.artifact, (Object)reporterTemplate.artifact) || !Intrinsics.areEqual(this.config, reporterTemplate.config) || !Intrinsics.areEqual((Object)this.output, (Object)reporterTemplate.output)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

