/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.github.shyiko.klob.Glob;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.internal.FileUtilsKt;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0084\u0001\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u001026\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0012H\u0000\u001ah\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00180\u001cH\u0000\u001a\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e*\b\u0012\u0004\u0012\u00020\u00010\u001aH\u0000\u001a\u001c\u0010 \u001a\n !*\u0004\u0018\u00010\u00010\u0001*\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0010H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006#"}, d2={"workDir", "", "getWorkDir", "()Ljava/lang/String;", "expandTilde", "path", "formatFile", "fileName", "fileContents", "ruleSets", "", "Lcom/pinterest/ktlint/core/RuleSet;", "userData", "", "editorConfigPath", "debug", "", "cb", "Lkotlin/Function2;", "Lcom/pinterest/ktlint/core/LintError;", "Lkotlin/ParameterName;", "name", "e", "corrected", "", "lintFile", "", "lintErrorCallback", "Lkotlin/Function1;", "fileSequence", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "location", "kotlin.jvm.PlatformType", "relative", "ktlint"})
public final class FileUtilsKt {
    @NotNull
    private static final String workDir;

    @NotNull
    public static final String getWorkDir() {
        return workDir;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<File> fileSequence(@NotNull List<String> $this$fileSequence) {
        Iterator kotlinFiles;
        Iterator iterator;
        Intrinsics.checkParameterIsNotNull($this$fileSequence, (String)"$this$fileSequence");
        if ($this$fileSequence.isEmpty()) {
            iterator = Glob.from((String[])new String[]{"**/*.kt", "**/*.kts"}).iterate(Paths.get(workDir, new String[0]), new Glob.IterationOption[]{Glob.IterationOption.SKIP_HIDDEN});
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$fileSequence;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = FileUtilsKt.expandTilde((String)p1);
                collection.add(string2);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] normalizedPatterns = stringArray;
            iterator = Glob.from((String[])Arrays.copyOf(normalizedPatterns, normalizedPatterns.length)).iterate(Paths.get(workDir, new String[0]));
        }
        Iterator iterator2 = kotlinFiles = iterator;
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator2, (String)"kotlinFiles");
        return SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator2), (Function1)fileSequence.1.INSTANCE);
    }

    @NotNull
    public static final String expandTilde(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        CharSequence charSequence = path;
        Regex regex = new Regex("^~");
        String string = System.getProperty("user.home");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"user.home\")");
        String string2 = string;
        boolean bl = false;
        return regex.replaceFirst(charSequence, string2);
    }

    public static final String location(@NotNull File $this$location, boolean relative) {
        Intrinsics.checkParameterIsNotNull((Object)$this$location, (String)"$this$location");
        return relative ? FilesKt.toRelativeString((File)$this$location, (File)new File(workDir)) : $this$location.getPath();
    }

    public static final void lintFile(@NotNull String fileName, @NotNull String fileContents, @NotNull List<RuleSet> ruleSets, @NotNull Map<String, String> userData, @Nullable String editorConfigPath, boolean debug, @NotNull Function1<? super LintError, Unit> lintErrorCallback) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)fileContents, (String)"fileContents");
        Intrinsics.checkParameterIsNotNull(ruleSets, (String)"ruleSets");
        Intrinsics.checkParameterIsNotNull(userData, (String)"userData");
        Intrinsics.checkParameterIsNotNull(lintErrorCallback, (String)"lintErrorCallback");
        boolean bl = debug;
        Function2 function2 = (Function2)new Function2<LintError, Boolean, Unit>(lintErrorCallback){
            final /* synthetic */ Function1 $lintErrorCallback;

            public final void invoke(@NotNull LintError e, boolean $noName_1) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$lintErrorCallback.invoke((Object)e);
            }
            {
                this.$lintErrorCallback = function1;
                super(2);
            }
        };
        String string = editorConfigPath;
        boolean bl2 = !StringsKt.endsWith((String)fileName, (String)".kt", (boolean)true);
        KtLint.INSTANCE.lint(new KtLint.Params(fileName, fileContents, (Iterable)ruleSets, userData, function2, bl2, string, bl));
    }

    public static /* synthetic */ void lintFile$default(String string, String string2, List list, Map map, String string3, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            function1 = lintFile.1.INSTANCE;
        }
        FileUtilsKt.lintFile(string, string2, list, map, string3, bl, (Function1<? super LintError, Unit>)function1);
    }

    @NotNull
    public static final String formatFile(@NotNull String fileName, @NotNull String fileContents, @NotNull Iterable<RuleSet> ruleSets, @NotNull Map<String, String> userData, @Nullable String editorConfigPath, boolean debug, @NotNull Function2<? super LintError, ? super Boolean, Unit> cb) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)fileContents, (String)"fileContents");
        Intrinsics.checkParameterIsNotNull(ruleSets, (String)"ruleSets");
        Intrinsics.checkParameterIsNotNull(userData, (String)"userData");
        Intrinsics.checkParameterIsNotNull(cb, (String)"cb");
        boolean bl = debug;
        Function2<? super LintError, ? super Boolean, Unit> function2 = cb;
        String string = editorConfigPath;
        boolean bl2 = !StringsKt.endsWith((String)fileName, (String)".kt", (boolean)true);
        return KtLint.INSTANCE.format(new KtLint.Params(fileName, fileContents, ruleSets, userData, function2, bl2, string, bl));
    }

    static {
        String string = new File(".").getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(\".\").canonicalPath");
        workDir = string;
    }
}

