/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.KtlintCommandLine;
import com.pinterest.ktlint.core.ParseException;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.internal.CommandLineExtKt;
import com.pinterest.ktlint.internal.FileUtilsKt;
import com.pinterest.ktlint.internal.KtlintVersionProvider;
import com.pinterest.ktlint.test.DumpAST;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(description={"Print AST (useful when writing/debugging rules)", "Usage of \"--print-ast\" command line option is deprecated!"}, aliases={"--print-ast"}, mixinStandardHelpOptions=true, versionProvider=KtlintVersionProvider.class)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/pinterest/ktlint/internal/PrintASTSubCommand;", "Ljava/lang/Runnable;", "()V", "astRuleSet", "", "Lcom/pinterest/ktlint/core/RuleSet;", "getAstRuleSet", "()Ljava/util/List;", "astRuleSet$delegate", "Lkotlin/Lazy;", "commandSpec", "Lpicocli/CommandLine$Model$CommandSpec;", "ktlintCommand", "Lcom/pinterest/ktlint/KtlintCommandLine;", "patterns", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "stdin", "", "printAST", "", "fileName", "fileContent", "run", "Companion", "ktlint"})
public final class PrintASTSubCommand
implements Runnable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @CommandLine.ParentCommand
    private KtlintCommandLine ktlintCommand;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec commandSpec;
    @CommandLine.Parameters(description={"include all files under this .gitignore-like patterns"})
    private ArrayList<String> patterns = new ArrayList();
    @CommandLine.Option(names={"--stdin"}, description={"Read file content from stdin"})
    private boolean stdin;
    private final Lazy astRuleSet$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends RuleSet>>(this){
        final /* synthetic */ PrintASTSubCommand this$0;

        @NotNull
        public final List<RuleSet> invoke() {
            Rule[] ruleArray = new Rule[1];
            PrintStream printStream = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
            ruleArray[0] = (Rule)new DumpAST(printStream, PrintASTSubCommand.access$getKtlintCommand$p(this.this$0).getColor());
            return CollectionsKt.listOf((Object)new RuleSet("debug", ruleArray));
        }
        {
            this.this$0 = printASTSubCommand;
            super(0);
        }
    }));
    @NotNull
    public static final String COMMAND_NAME = "printAST";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PrintASTSubCommand.class), "astRuleSet", "getAstRuleSet()Ljava/util/List;"))};
        Companion = new Companion(null);
    }

    private final List<RuleSet> getAstRuleSet() {
        Lazy lazy = this.astRuleSet$delegate;
        PrintASTSubCommand printASTSubCommand = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @Override
    public void run() {
        CommandLine.Model.CommandSpec commandSpec = this.commandSpec;
        if (commandSpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandSpec");
        }
        CommandLine commandLine = commandSpec.commandLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)commandLine, (String)"commandSpec.commandLine()");
        CommandLineExtKt.printHelpOrVersionUsage$default(commandLine, 0, 1, null);
        if (this.stdin) {
            InputStream inputStream = System.in;
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"System.`in`");
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
            String string = "<stdin>";
            PrintASTSubCommand printASTSubCommand = this;
            boolean bl = false;
            String string2 = new String(byArray, Charsets.UTF_8);
            printASTSubCommand.printAST(string, string2);
        } else {
            for (File file : FileUtilsKt.fileSequence((List<String>)this.patterns)) {
                String string = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                this.printAST(string, FilesKt.readText$default((File)file, null, (int)1, null));
            }
        }
    }

    private final void printAST(String fileName, String fileContent) {
        boolean bl;
        String string;
        KtlintCommandLine ktlintCommandLine = this.ktlintCommand;
        if (ktlintCommandLine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
        }
        if (ktlintCommandLine.getDebug()) {
            String string2;
            if (Intrinsics.areEqual((Object)fileName, (Object)"<stdin>") ^ true) {
                File file = new File(fileName);
                KtlintCommandLine ktlintCommandLine2 = this.ktlintCommand;
                if (ktlintCommandLine2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
                }
                string2 = FileUtilsKt.location(file, ktlintCommandLine2.getRelative());
            } else {
                string2 = "stdin";
            }
            String fileLocation = string2;
            string = "[DEBUG] Analyzing " + fileLocation;
            bl = false;
            System.out.println((Object)string);
        }
        try {
            List<RuleSet> list = this.getAstRuleSet();
            KtlintCommandLine ktlintCommandLine3 = this.ktlintCommand;
            if (ktlintCommandLine3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
            }
            FileUtilsKt.lintFile$default(fileName, fileContent, list, null, null, ktlintCommandLine3.getDebug(), null, 88, null);
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                String string3;
                int n = ((ParseException)e).getLine();
                int n2 = ((ParseException)e).getCol();
                StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
                String string4 = e.getMessage();
                if (string4 != null) {
                    string = string4;
                    StringBuilder stringBuilder2 = stringBuilder;
                    int n3 = n2;
                    int n4 = n;
                    bl = false;
                    String string5 = string;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                    String string7 = string6;
                    n = n4;
                    n2 = n3;
                    stringBuilder = stringBuilder2;
                    string3 = string7;
                } else {
                    string3 = null;
                }
                String string8 = stringBuilder.append(string3).append(')').toString();
                int n5 = n2;
                int n6 = n;
                throw (Throwable)new ParseException(n6, n5, string8);
            }
            throw (Throwable)e;
        }
    }

    public static final /* synthetic */ KtlintCommandLine access$getKtlintCommand$p(PrintASTSubCommand $this) {
        KtlintCommandLine ktlintCommandLine = $this.ktlintCommand;
        if (ktlintCommandLine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
        }
        return ktlintCommandLine;
    }

    public static final /* synthetic */ void access$setKtlintCommand$p(PrintASTSubCommand $this, KtlintCommandLine ktlintCommandLine) {
        $this.ktlintCommand = ktlintCommandLine;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pinterest/ktlint/internal/PrintASTSubCommand$Companion;", "", "()V", "COMMAND_NAME", "", "ktlint"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

