/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.internal.ByteArrayExtKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\b\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/pinterest/ktlint/internal/GitHookInstaller;", "", "()V", "backupExistingHook", "", "hooksDir", "Ljava/io/File;", "hookFile", "expectedHookContent", "", "gitHookName", "", "installGitHook", "gitHookLoader", "Lkotlin/Function0;", "resolveGitHooksDir", "ktlint"})
public final class GitHookInstaller {
    @NotNull
    public static final GitHookInstaller INSTANCE = new GitHookInstaller();

    private GitHookInstaller() {
    }

    public final void installGitHook(@NotNull String gitHookName, @NotNull Function0<byte[]> gitHookLoader) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)gitHookName, (String)"gitHookName");
        Intrinsics.checkParameterIsNotNull(gitHookLoader, (String)"gitHookLoader");
        try {
            file = this.resolveGitHooksDir();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        File gitHooksDir = file;
        File gitHookFile = FilesKt.resolve((File)gitHooksDir, (String)gitHookName);
        byte[] hookContent = (byte[])gitHookLoader.invoke();
        if (gitHookFile.exists()) {
            this.backupExistingHook(gitHooksDir, gitHookFile, hookContent, gitHookName);
        }
        FilesKt.writeBytes((File)gitHookFile, (byte[])hookContent);
        gitHookFile.setExecutable(true);
        String string = ".git/hooks/" + gitHookName + " installed";
        boolean bl = false;
        System.out.println((Object)string);
    }

    private final File resolveGitHooksDir() throws IOException {
        Object root;
        try {
            Object object = Runtime.getRuntime().exec("git rev-parse --show-toplevel").getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getRuntime().exec(\"git rev-parse --show-toplevel\")\n                .inputStream");
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = object;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            object = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            boolean bl3 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            root = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
            root = FilesKt.resolve((File)new File((String)root), (String)".git");
        }
        catch (IOException ex) {
            root = new File(".git");
        }
        File gitDir = root;
        if (!gitDir.isDirectory()) {
            throw new IOException(".git directory not found. Are you sure you are inside project directory?");
        }
        File hooksDir = FilesKt.resolve((File)gitDir, (String)"hooks");
        if (!hooksDir.exists() && !hooksDir.mkdir()) {
            throw new IOException("Failed to create .git/hooks folder");
        }
        return hooksDir;
    }

    private final void backupExistingHook(File hooksDir, File hookFile, byte[] expectedHookContent, String gitHookName) {
        byte[] actualHookContent;
        byte[] byArray = actualHookContent = FilesKt.readBytes((File)hookFile);
        boolean bl = false;
        byte[] byArray2 = byArray;
        boolean bl2 = false;
        if (!(byArray2.length == 0)) {
            byArray = actualHookContent;
            bl = false;
            byArray2 = byArray;
            bl2 = false;
            if (!Arrays.equals(byArray2, expectedHookContent)) {
                File backupFile = FilesKt.resolve((File)hooksDir, (String)(gitHookName + ".ktlint-backup." + ByteArrayExtKt.getHex(actualHookContent)));
                String string = ".git/hooks/" + gitHookName + " -> " + backupFile;
                boolean bl3 = false;
                System.out.println((Object)string);
                FilesKt.copyTo$default((File)hookFile, (File)backupFile, (boolean)true, (int)0, (int)4, null);
            }
        }
    }
}

