/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.KtlintCommandLine;
import com.pinterest.ktlint.core.ParseException;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.internal.CommandLineExtKt;
import com.pinterest.ktlint.internal.FileUtilsKt;
import com.pinterest.ktlint.internal.KtlintVersionProvider;
import com.pinterest.ktlint.internal.PrintASTSubCommand;
import com.pinterest.ruleset.test.DumpASTRule;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(aliases={"--print-ast"}, versionProvider=KtlintVersionProvider.class, mixinStandardHelpOptions=true, description={"Print AST (useful when writing/debugging rules)", "Usage of \"--print-ast\" command line option is deprecated!"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/pinterest/ktlint/internal/PrintASTSubCommand;", "Ljava/lang/Runnable;", "()V", "astRuleSet", "", "Lcom/pinterest/ktlint/core/RuleSet;", "getAstRuleSet", "()Ljava/util/List;", "astRuleSet$delegate", "Lkotlin/Lazy;", "commandSpec", "Lpicocli/CommandLine$Model$CommandSpec;", "ktlintCommand", "Lcom/pinterest/ktlint/KtlintCommandLine;", "patterns", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "stdin", "", "printAST", "", "fileName", "fileContent", "run", "Companion", "ktlint"})
public final class PrintASTSubCommand
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.ParentCommand
    private KtlintCommandLine ktlintCommand;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec commandSpec;
    @CommandLine.Parameters(description={"include all files under this .gitignore-like patterns"})
    @NotNull
    private ArrayList<String> patterns = new ArrayList();
    @CommandLine.Option(names={"--stdin"}, description={"Read file content from stdin"})
    private boolean stdin;
    @NotNull
    private final Lazy astRuleSet$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends RuleSet>>(this){
        final /* synthetic */ PrintASTSubCommand this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final List<RuleSet> invoke() {
            Rule[] ruleArray = new Rule[1];
            Object object = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"out");
            PrintStream printStream = object;
            object = PrintASTSubCommand.access$getKtlintCommand$p(this.this$0);
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
                throw null;
            }
            ruleArray[0] = (Rule)new DumpASTRule(printStream, ((KtlintCommandLine)object).getColor());
            return CollectionsKt.listOf((Object)new RuleSet("debug", ruleArray));
        }
    }));
    @NotNull
    public static final String COMMAND_NAME = "printAST";

    private final List<RuleSet> getAstRuleSet() {
        Lazy lazy = this.astRuleSet$delegate;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @Override
    public void run() {
        CommandLine.Model.CommandSpec commandSpec = this.commandSpec;
        if (commandSpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandSpec");
            throw null;
        }
        Object object = commandSpec.commandLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"commandSpec.commandLine()");
        CommandLineExtKt.printHelpOrVersionUsage$default(object, 0, 1, null);
        if (this.stdin) {
            object = System.in;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"`in`");
            object = ByteStreamsKt.readBytes((InputStream)object);
            boolean bl = false;
            this.printAST("<stdin>", new String((byte[])object, Charsets.UTF_8));
        } else {
            object = FileSystems.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getDefault()");
            Sequence $this$forEach$iv = SequencesKt.map((Sequence)FileUtilsKt.fileSequence$default((FileSystem)object, this.patterns, null, 2, null), (Function1)run.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.path");
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                this.printAST(string, FilesKt.readText$default((File)it, null, (int)1, null));
            }
        }
    }

    private final void printAST(String fileName, String fileContent) {
        Object fileLocation;
        Object object;
        KtlintCommandLine ktlintCommandLine = this.ktlintCommand;
        if (ktlintCommandLine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
            throw null;
        }
        if (ktlintCommandLine.getDebug()) {
            String string;
            if (!Intrinsics.areEqual((Object)fileName, (Object)"<stdin>")) {
                object = this.ktlintCommand;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
                    throw null;
                }
                string = FileUtilsKt.location(new File(fileName), ((KtlintCommandLine)object).getRelative());
            } else {
                string = "stdin";
            }
            fileLocation = string;
            object = Intrinsics.stringPlus((String)"[DEBUG] Analyzing ", (Object)fileLocation);
            boolean bl = false;
            System.out.println(object);
        }
        try {
            fileLocation = this.ktlintCommand;
            if (fileLocation == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
                throw null;
            }
            FileUtilsKt.lintFile$default(fileName, fileContent, this.getAstRuleSet(), null, null, ((KtlintCommandLine)fileLocation).getDebug(), null, 88, null);
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                String string;
                int n = ((ParseException)e).getLine();
                int n2 = ((ParseException)e).getCol();
                StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
                object = e.getMessage();
                if (object == null) {
                    string = null;
                } else {
                    Object object2 = object;
                    boolean bl = false;
                    String string2 = ((String)object2).toLowerCase();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                }
                throw new ParseException(n, n2, stringBuilder.append((Object)string).append(')').toString());
            }
            throw e;
        }
    }

    public static final /* synthetic */ KtlintCommandLine access$getKtlintCommand$p(PrintASTSubCommand $this) {
        return $this.ktlintCommand;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pinterest/ktlint/internal/PrintASTSubCommand$Companion;", "", "()V", "COMMAND_NAME", "", "ktlint"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

