/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint;

import com.pinterest.ktlint.KtlintCommandLine;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.ParseException;
import com.pinterest.ktlint.core.Reporter;
import com.pinterest.ktlint.core.ReporterProvider;
import com.pinterest.ktlint.core.RuleExecutionException;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.RuleSetProvider;
import com.pinterest.ktlint.core.internal.BaselineSupportKt;
import com.pinterest.ktlint.core.internal.CurrentBaseline;
import com.pinterest.ktlint.internal.FileUtilsKt;
import com.pinterest.ktlint.internal.KtlintVersionProvider;
import com.pinterest.ktlint.internal.RuleSetsLoaderKt;
import com.pinterest.ktlint.reporter.plain.internal.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=KtlintVersionProvider.class, mixinStandardHelpOptions=true, headerHeading="\nAn anti-bikeshedding Kotlin linter with built-in formatter.\n(https://github.com/pinterest/ktlint).\n\nUsage:\n  ktlint <flags> [patterns]\n  java -jar ktlint.jar <flags> [patterns]\n\nExamples:\n  # Check the style of all Kotlin files (ending with '.kt' or '.kts') inside the current dir (recursively).\n  #\n  # Hidden folders will be skipped.\n  ktlint\n\n  # Check only certain locations starting from the current directory.\n  #\n  # Prepend ! to negate the pattern, KtLint uses .gitignore pattern style syntax.\n  # Globs are applied starting from the last one.\n  #\n  # Hidden folders will be skipped.\n  # Check all '.kt' files in 'src/' directory, but ignore files ending with 'Test.kt':\n  ktlint \"src/**/*.kt\" \"!src/**/*Test.kt\"\n  # Check all '.kt' files in 'src/' directory, but ignore 'generated' directory and its subdirectories:\n  ktlint \"src/**/*.kt\" \"!src/**/generated/**\"\n\n  # Auto-correct style violations.\n  ktlint -F \"src/**/*.kt\"\n\n  # Using custom reporter jar and overriding report location\n  ktlint --reporter=csv,artifact=/path/to/reporter/csv.jar,output=my-custom-report.csv\nFlags:\n", synopsisHeading="", customSynopsis={""}, sortOptions=false)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002abB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00106\u001a\u000207H\u0002JT\u00108\u001a\u0002072\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020;0:2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0:2\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0+\u0018\u00010:2\u0006\u0010>\u001a\u00020?H\u0002J8\u0010@\u001a\u0002072\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020;0:2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0:2\u0006\u0010>\u001a\u00020?H\u0002J\b\u0010A\u001a\u00020?H\u0002J*\u0010B\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n D*\u0004\u0018\u00010C0C0:2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\n0+H\u0002J\u001c\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0G2\u0006\u0010H\u001a\u00020\nH\u0002JV\u0010I\u001a\b\u0012\u0004\u0012\u00020J0+2\u0006\u0010K\u001a\u00020\n2\u0006\u0010L\u001a\u00020\n2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020;0:2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0:2\u000e\u0010M\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010+H\u0002J&\u0010N\u001a\u0002072\u0006\u0010K\u001a\u00020\n2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020J0+2\u0006\u0010>\u001a\u00020?H\u0002J\u0006\u0010P\u001a\u000207J&\u0010Q\u001a\b\u0012\u0004\u0012\u0002HR0+\"\u0004\b\u0000\u0010R*\b\u0012\u0004\u0012\u0002HR0+2\u0006\u0010!\u001a\u00020\"H\u0002J\f\u0010S\u001a\u000207*\u00020TH\u0002J<\u0010U\u001a\u000207\"\u0004\b\u0000\u0010R*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HR0W0V2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u0002HR\u0012\u0004\u0012\u0002070Y2\b\b\u0002\u0010Z\u001a\u00020\"H\u0002J\u0010\u0010[\u001a\u00020=*\u00060\\j\u0002`]H\u0002J \u0010^\u001a\u00020?*\u00020_2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020C0:H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u001e\u0010\u000e\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\bR\u001e\u0010\u0016\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\bR\u000e\u0010\u001f\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\u00020\"8B@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0006\"\u0004\b)\u0010\bR\u001c\u0010*\u001a\f\u0012\u0004\u0012\u00020\n0+j\u0002`,8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R(\u0010-\u001a\f\u0012\u0004\u0012\u00020\n0+j\u0002`,8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0012\u00102\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/pinterest/ktlint/KtlintCommandLine;", "", "()V", "android", "", "getAndroid", "()Z", "setAndroid", "(Z)V", "baseline", "", "color", "getColor", "setColor", "colorName", "getColorName", "()Ljava/lang/String;", "setColorName", "(Ljava/lang/String;)V", "debug", "getDebug", "setDebug", "disabledRules", "getDisabledRules", "setDisabledRules", "editorConfigPath", "errorNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "experimental", "getExperimental", "setExperimental", "fileNumber", "format", "limit", "", "getLimit", "()I", "patterns", "Ljava/util/ArrayList;", "relative", "getRelative", "setRelative", "reporters", "", "Lcom/pinterest/ktlint/internal/JarFiles;", "rulesets", "getRulesets", "()Ljava/util/List;", "setRulesets", "(Ljava/util/List;)V", "stdin", "tripped", "Ljava/util/concurrent/atomic/AtomicBoolean;", "verbose", "failOnOldRulesetProviderUsage", "", "lintFiles", "ruleSetProviders", "", "Lcom/pinterest/ktlint/core/RuleSetProvider;", "userData", "Lcom/pinterest/ktlint/core/LintError;", "reporter", "Lcom/pinterest/ktlint/core/Reporter;", "lintStdin", "loadReporter", "loadReporters", "Lcom/pinterest/ktlint/core/ReporterProvider;", "kotlin.jvm.PlatformType", "externalReportersJarPaths", "parseQuery", "Ljava/util/LinkedHashMap;", "query", "process", "Lcom/pinterest/ktlint/KtlintCommandLine$LintErrorWithCorrectionInfo;", "fileName", "fileContent", "baselineErrors", "report", "errList", "run", "head", "T", "mkdirsOrFail", "Ljava/io/File;", "parallel", "Lkotlin/sequences/Sequence;", "Ljava/util/concurrent/Callable;", "cb", "Lkotlin/Function1;", "numberOfThreads", "toLintError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "toReporter", "Lcom/pinterest/ktlint/KtlintCommandLine$ReporterTemplate;", "reporterProviderById", "LintErrorWithCorrectionInfo", "ReporterTemplate", "ktlint"})
public final class KtlintCommandLine {
    @CommandLine.Option(names={"--android", "-a"}, description={"Turn on Android Kotlin Style Guide compatibility"})
    private boolean android;
    @CommandLine.Option(names={"--color"}, description={"Make output colorful"})
    private boolean color;
    @CommandLine.Option(names={"--color-name"}, description={"Customize the output color"})
    @NotNull
    private String colorName = Color.DARK_GRAY.name();
    @CommandLine.Option(names={"--debug"}, description={"Turn on debug output"})
    private boolean debug;
    @CommandLine.Option(names={"--disabled_rules"}, description={"Comma-separated list of rules to globally disable. To disable standard ktlint rule-set use --disabled_rules=standard"})
    @NotNull
    private String disabledRules = "";
    @CommandLine.Option(names={"--format", "-F"}, description={"Fix any deviations from the code style"})
    private boolean format;
    @CommandLine.Option(names={"--limit"}, description={"Maximum number of errors to show (default: show all)"})
    private int limit = -1;
    @CommandLine.Option(names={"--relative"}, description={"Print files relative to the working directory (e.g. dir/file.kt instead of /home/user/project/dir/file.kt)"})
    private boolean relative;
    @CommandLine.Option(names={"--reporter"}, description={"A reporter to use (built-in: plain (default), plain?group_by_file, json, sarif, checkstyle, html). To use a third-party reporter specify a path to a JAR file on the filesystem via ',artifact=' option. To override reporter output, use ',output=' option."})
    @NotNull
    private List<String> reporters = new ArrayList();
    @CommandLine.Option(names={"--ruleset", "-R"}, description={"A path to a JAR file containing additional ruleset(s)"})
    @NotNull
    private List<String> rulesets = new ArrayList();
    @CommandLine.Option(names={"--stdin"}, description={"Read file from stdin"})
    private boolean stdin;
    @CommandLine.Option(names={"--verbose", "-v"}, description={"Show error codes"})
    private boolean verbose;
    @CommandLine.Option(names={"--editorconfig"}, description={"Path to .editorconfig"})
    @Nullable
    private String editorConfigPath;
    @CommandLine.Option(names={"--experimental"}, description={"Enabled experimental rules (ktlint-ruleset-experimental)"})
    private boolean experimental;
    @CommandLine.Option(names={"--baseline"}, description={"Defines a baseline file to check against"})
    @NotNull
    private String baseline = "";
    @CommandLine.Parameters(hidden=true)
    @NotNull
    private ArrayList<String> patterns = new ArrayList();
    @NotNull
    private final AtomicBoolean tripped = new AtomicBoolean();
    @NotNull
    private final AtomicInteger fileNumber = new AtomicInteger();
    @NotNull
    private final AtomicInteger errorNumber = new AtomicInteger();

    public final boolean getAndroid() {
        return this.android;
    }

    public final void setAndroid(boolean bl) {
        this.android = bl;
    }

    public final boolean getColor() {
        return this.color;
    }

    public final void setColor(boolean bl) {
        this.color = bl;
    }

    @NotNull
    public final String getColorName() {
        return this.colorName;
    }

    public final void setColorName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.colorName = string;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final String getDisabledRules() {
        return this.disabledRules;
    }

    public final void setDisabledRules(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.disabledRules = string;
    }

    private final int getLimit() {
        return this.limit < 0 ? Integer.MAX_VALUE : this.limit;
    }

    public final boolean getRelative() {
        return this.relative;
    }

    public final void setRelative(boolean bl) {
        this.relative = bl;
    }

    @NotNull
    public final List<String> getRulesets() {
        return this.rulesets;
    }

    public final void setRulesets(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.rulesets = list;
    }

    public final boolean getExperimental() {
        return this.experimental;
    }

    public final void setExperimental(boolean bl) {
        this.experimental = bl;
    }

    public final void run() {
        Object object;
        this.failOnOldRulesetProviderUsage();
        long start = System.currentTimeMillis();
        CurrentBaseline baselineResults = BaselineSupportKt.loadBaseline((String)this.baseline);
        SortedMap<String, RuleSetProvider> ruleSetProviders = RuleSetsLoaderKt.loadRulesets(this.rulesets, this.experimental, this.debug, this.disabledRules);
        Reporter reporter = this.loadReporter();
        if (baselineResults.getBaselineGenerationNeeded()) {
            ReporterTemplate baselineReporter = new ReporterTemplate("baseline", null, MapsKt.emptyMap(), this.baseline);
            Map<String, ReporterProvider> reporterProviderById = this.loadReporters(CollectionsKt.emptyList());
            object = new Reporter[]{reporter, this.toReporter(baselineReporter, reporterProviderById)};
            reporter = Reporter.Companion.from(object);
        }
        Object[] objectArray = new Pair[2];
        objectArray[0] = TuplesKt.to((Object)"android", (Object)String.valueOf(this.android));
        object = this.disabledRules;
        boolean bl = false;
        objectArray[1] = !StringsKt.isBlank((CharSequence)object) ? TuplesKt.to((Object)"disabled_rules", (Object)this.disabledRules) : null;
        Map userData = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        reporter.beforeAll();
        if (this.stdin) {
            this.lintStdin((Map<String, ? extends RuleSetProvider>)ruleSetProviders, userData, reporter);
        } else {
            this.lintFiles((Map<String, ? extends RuleSetProvider>)ruleSetProviders, userData, baselineResults.getBaselineRules(), reporter);
        }
        reporter.afterAll();
        if (this.debug) {
            System.err.println("[DEBUG] " + (System.currentTimeMillis() - start) + "ms / " + this.fileNumber + " file(s) / " + this.errorNumber + " error(s)");
        }
        if (this.tripped.get()) {
            int n = 1;
            boolean bl2 = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void lintFiles(Map<String, ? extends RuleSetProvider> ruleSetProviders, Map<String, String> userData, Map<String, ? extends List<LintError>> baseline, Reporter reporter) {
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem, (String)"getDefault()");
        KtlintCommandLine.parallel$default(this, SequencesKt.map((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.map((Sequence)FileUtilsKt.fileSequence$default(fileSystem, this.patterns, null, 2, null), (Function1)lintFiles.1.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(File it) {
                return KtlintCommandLine.access$getErrorNumber$p(this.this$0).get() < KtlintCommandLine.access$getLimit(this.this$0);
            }
        })), (Function1)((Function1)new Function1<File, Callable<Pair<? extends File, ? extends List<? extends LintErrorWithCorrectionInfo>>>>(this, ruleSetProviders, userData, baseline){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ Map<String, RuleSetProvider> $ruleSetProviders;
            final /* synthetic */ Map<String, String> $userData;
            final /* synthetic */ Map<String, List<LintError>> $baseline;
            {
                this.this$0 = $receiver;
                this.$ruleSetProviders = $ruleSetProviders;
                this.$userData = $userData;
                this.$baseline = $baseline;
                super(1);
            }

            @NotNull
            public final Callable<Pair<File, List<LintErrorWithCorrectionInfo>>> invoke(File file) {
                return () -> lintFiles.3.invoke$lambda-0(file, this.this$0, this.$ruleSetProviders, this.$userData, this.$baseline);
            }

            private static final Pair invoke$lambda-0(File $file, KtlintCommandLine this$0, Map $ruleSetProviders, Map $userData, Map $baseline) {
                Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
                Intrinsics.checkParameterIsNotNull((Object)$ruleSetProviders, (String)"$ruleSetProviders");
                Intrinsics.checkParameterIsNotNull((Object)$userData, (String)"$userData");
                Object object = $file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"file.path");
                String string = object;
                Intrinsics.checkExpressionValueIsNotNull((Object)$file, (String)"file");
                object = $baseline;
                return TuplesKt.to((Object)$file, (Object)KtlintCommandLine.access$process(this$0, string, FilesKt.readText$default((File)$file, null, (int)1, null), $ruleSetProviders, $userData, object == null ? null : (List)object.get(BaselineSupportKt.getRelativeRoute((File)$file))));
            }
        })), (Function1)new Function1<Pair<? extends File, ? extends List<? extends LintErrorWithCorrectionInfo>>, Unit>(this, reporter){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ Reporter $reporter;
            {
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(Pair<? extends File, ? extends List<LintErrorWithCorrectionInfo>> $dstr$file$errList) {
                File file = (File)$dstr$file$errList.component1();
                List errList = (List)$dstr$file$errList.component2();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"file");
                String string = FileUtilsKt.location(file, this.this$0.getRelative());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.location(relative)");
                KtlintCommandLine.access$report(this.this$0, string, errList, this.$reporter);
            }
        }, 0, 2, null);
    }

    private final void lintStdin(Map<String, ? extends RuleSetProvider> ruleSetProviders, Map<String, String> userData, Reporter reporter) {
        Object object = System.in;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"`in`");
        object = ByteStreamsKt.readBytes((InputStream)object);
        boolean bl = false;
        this.report("<stdin>", this.process("<stdin>", new String((byte[])object, Charsets.UTF_8), ruleSetProviders, userData, null), reporter);
    }

    private final void failOnOldRulesetProviderUsage() {
        ServiceLoader<com.github.shyiko.ktlint.core.RuleSetProvider> serviceLoader = ServiceLoader.load(com.github.shyiko.ktlint.core.RuleSetProvider.class);
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"load(com.github.shyiko.ktlint.core.RuleSetProvider::class.java)");
        if (CollectionsKt.any((Iterable)serviceLoader)) {
            System.err.println("[ERROR] Cannot load custom ruleset!");
            System.err.println("[ERROR] RuleSetProvider has moved to com.pinterest.ktlint.core.");
            System.err.println("[ERROR] Please rename META-INF/services/com.github.shyiko.ktlint.core.RuleSetProvider to META-INF/services/com.pinterest.ktlint.core.RuleSetProvider");
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void report(String fileName, List<LintErrorWithCorrectionInfo> errList, Reporter reporter) {
        this.fileNumber.incrementAndGet();
        int n = errList.size();
        int n2 = this.getLimit() - this.errorNumber.get();
        int n3 = 0;
        boolean bl = false;
        n2 = Math.max(n2, n3);
        n3 = 0;
        int errListLimit = Math.min(n, n2);
        this.errorNumber.addAndGet(errListLimit);
        reporter.before(fileName);
        Iterable $this$forEach$iv = this.head(errList, errListLimit);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LintErrorWithCorrectionInfo $dstr$err$corrected = (LintErrorWithCorrectionInfo)element$iv;
            boolean bl2 = false;
            LintError err = $dstr$err$corrected.component1();
            boolean corrected = $dstr$err$corrected.component2();
            reporter.onLintError(fileName, !err.getCanBeAutoCorrected() ? LintError.copy$default((LintError)err, (int)0, (int)0, null, (String)Intrinsics.stringPlus((String)err.getDetail(), (Object)" (cannot be auto-corrected)"), (int)7, null) : err, corrected);
        }
        reporter.after(fileName);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LintErrorWithCorrectionInfo> process(String fileName, String fileContent, Map<String, ? extends RuleSetProvider> ruleSetProviders, Map<String, String> userData, List<LintError> baselineErrors) {
        if (this.debug) {
            String fileLocation = !Intrinsics.areEqual((Object)fileName, (Object)"<stdin>") ? FileUtilsKt.location(new File(fileName), this.relative) : fileName;
            System.err.println(Intrinsics.stringPlus((String)"[DEBUG] Checking ", (Object)fileLocation));
        }
        ArrayList<LintErrorWithCorrectionInfo> result = new ArrayList<LintErrorWithCorrectionInfo>();
        if (this.format) {
            String $this$map$iv2;
            try {
                Collection<RuleSet> collection;
                void $this$mapTo$iv$iv;
                Map<String, ? extends RuleSetProvider> map = ruleSetProviders;
                String string = fileContent;
                String string2 = fileName;
                boolean $i$f$map = false;
                void var10_17 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList($this$map$iv2.size());
                boolean $i$f$mapTo = false;
                void var13_23 = $this$mapTo$iv$iv;
                boolean bl = false;
                Iterator iterator = var13_23.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv2;
                    Map.Entry entry = item$iv$iv2 = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    RuleSet ruleSet = ((RuleSetProvider)it.getValue()).get();
                    collection.add(ruleSet);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv2 = FileUtilsKt.formatFile(string2, string, (Iterable<? extends RuleSet>)collection, userData, this.editorConfigPath, this.debug, (Function2<? super LintError, ? super Boolean, Unit>)((Function2)new Function2<LintError, Boolean, Unit>(baselineErrors, result, this){
                    final /* synthetic */ List<LintError> $baselineErrors;
                    final /* synthetic */ ArrayList<LintErrorWithCorrectionInfo> $result;
                    final /* synthetic */ KtlintCommandLine this$0;
                    {
                        this.$baselineErrors = $baselineErrors;
                        this.$result = $result;
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull LintError err, boolean corrected) {
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        if (!(corrected || this.$baselineErrors != null && BaselineSupportKt.containsLintError(this.$baselineErrors, (LintError)err))) {
                            this.$result.add(new LintErrorWithCorrectionInfo(err, corrected));
                            KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                        }
                    }
                }));
            }
            catch (Exception e) {
                result.add(new LintErrorWithCorrectionInfo(this.toLintError(e), false));
                this.tripped.set(true);
                $this$map$iv2 = fileContent;
            }
            String formattedFileContent2 = $this$map$iv2;
            if (this.stdin) {
                boolean $this$map$iv2 = false;
                System.out.print((Object)formattedFileContent2);
            } else if (fileContent != formattedFileContent2) {
                File file = new File(fileName);
                $this$map$iv2 = "UTF-8";
                boolean e = false;
                Charset charset = Charset.forName($this$map$iv2);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
                FilesKt.writeText((File)file, (String)formattedFileContent2, (Charset)charset);
            }
        } else {
            try {
                Collection<RuleSet> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map<String, ? extends RuleSetProvider> formattedFileContent2 = ruleSetProviders;
                String string = fileContent;
                String string3 = fileName;
                boolean $i$f$map = false;
                void e = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                void var12_22 = $this$mapTo$iv$iv;
                boolean bl = false;
                Iterator iterator = var12_22.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry item$iv$iv2 = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    RuleSet ruleSet = ((RuleSetProvider)it.getValue()).get();
                    collection.add(ruleSet);
                }
                collection = (List)destination$iv$iv;
                FileUtilsKt.lintFile(string3, string, (List<? extends RuleSet>)collection, userData, this.editorConfigPath, this.debug, (Function1<? super LintError, Unit>)((Function1)new Function1<LintError, Unit>(baselineErrors, result, this){
                    final /* synthetic */ List<LintError> $baselineErrors;
                    final /* synthetic */ ArrayList<LintErrorWithCorrectionInfo> $result;
                    final /* synthetic */ KtlintCommandLine this$0;
                    {
                        this.$baselineErrors = $baselineErrors;
                        this.$result = $result;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull LintError err) {
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        if (this.$baselineErrors == null || !BaselineSupportKt.containsLintError(this.$baselineErrors, (LintError)err)) {
                            this.$result.add(new LintErrorWithCorrectionInfo(err, false));
                            KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                        }
                    }
                }));
            }
            catch (Exception e) {
                result.add(new LintErrorWithCorrectionInfo(this.toLintError(e), false));
                this.tripped.set(true);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Reporter loadReporter() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        Object object2;
        Object object3;
        void $this$mapTo$iv$iv2;
        List<String> configuredReporters = this.reporters.isEmpty() ? CollectionsKt.listOf((Object)"plain") : this.reporters;
        Iterable $this$map$iv2 = configuredReporters;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            String string;
            String string2;
            Map map;
            void it;
            String string3;
            Object element$iv;
            boolean $i$f$lastOrNull;
            String string4;
            Object object4;
            block11: {
                String string5;
                String string6;
                String it2;
                ListIterator iterator$iv2;
                Object $this$lastOrNull$iv;
                String rawReporterConfig;
                List split;
                block10: {
                    void reporter;
                    String string7 = (String)item$iv$iv;
                    object3 = destination$iv$iv;
                    boolean bl = false;
                    Object object5 = new String[]{","};
                    split = StringsKt.split$default((CharSequence)((CharSequence)reporter), (String[])object5, (boolean)false, (int)0, (int)6, null);
                    String[] stringArray = new String[]{"?"};
                    Object object6 = object5 = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)((CharSequence)split.get(0)), (String[])stringArray, (boolean)false, (int)2, (int)2, null), (Iterable)CollectionsKt.listOf((Object)""));
                    boolean bl2 = false;
                    String reporterId = (String)object6.get(0);
                    object4 = object5;
                    boolean bl3 = false;
                    rawReporterConfig = (String)object4.get(1);
                    object2 = split;
                    string4 = reporterId;
                    $i$f$lastOrNull = false;
                    iterator$iv2 = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv2.hasPrevious()) {
                        element$iv = iterator$iv2.previous();
                        it2 = (String)element$iv;
                        boolean bl4 = false;
                        if (!StringsKt.startsWith$default((String)it2, (String)"artifact=", (boolean)false, (int)2, null)) continue;
                        string6 = (String)element$iv;
                        break block10;
                    }
                    string6 = null;
                }
                string3 = string6;
                String string8 = string4;
                object4 = string3;
                if (object4 == null) {
                    string5 = null;
                } else {
                    $this$lastOrNull$iv = object4;
                    $i$f$lastOrNull = false;
                    boolean iterator$iv2 = false;
                    element$iv = $this$lastOrNull$iv;
                    string4 = string8;
                    boolean bl = false;
                    String[] bl4 = new String[]{"="};
                    string3 = (String)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])bl4, (boolean)false, (int)0, (int)6, null).get(1);
                    string8 = string4;
                    string5 = string3;
                }
                object4 = new Pair[]{TuplesKt.to((Object)"verbose", (Object)String.valueOf(this.verbose)), TuplesKt.to((Object)"color", (Object)String.valueOf(this.getColor())), TuplesKt.to((Object)"color_name", (Object)this.getColorName())};
                $this$lastOrNull$iv = split;
                map = MapsKt.plus((Map)MapsKt.mapOf((Pair[])object4), (Map)this.parseQuery(rawReporterConfig));
                string3 = string5;
                string4 = string8;
                $i$f$lastOrNull = false;
                iterator$iv2 = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv2.hasPrevious()) {
                    element$iv = iterator$iv2.previous();
                    it2 = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it2, (String)"output=", (boolean)false, (int)2, null)) continue;
                    string2 = (String)element$iv;
                    break block11;
                }
                string2 = null;
            }
            String string9 = string2;
            String string10 = string4;
            String string11 = string3;
            Map map2 = map;
            object4 = string9;
            if (object4 == null) {
                string = null;
            } else {
                object2 = object4;
                $i$f$lastOrNull = false;
                boolean bl = false;
                element$iv = object2;
                map = map2;
                string3 = string11;
                string4 = string10;
                boolean bl5 = false;
                String[] stringArray = new String[]{"="};
                string9 = (String)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                string10 = string4;
                string11 = string3;
                map2 = map;
                string = string9;
            }
            String string12 = string;
            Map map3 = map2;
            String string13 = string11;
            String string14 = string10;
            object = new ReporterTemplate(string14, string13, map3, string12);
            object3.add(object);
        }
        List tpls = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = tpls;
        object3 = this;
        boolean $i$f$mapNotNull22 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl6 = false;
            ReporterTemplate it = (ReporterTemplate)element$iv$iv;
            boolean bl7 = false;
            if (it.getArtifact() == null) continue;
            boolean bl8 = false;
            boolean bl9 = false;
            String it$iv$iv = object2;
            boolean bl10 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        object = (List)destination$iv$iv2;
        Map<String, ReporterProvider> reporterProviderById = super.loadReporters((List<String>)object);
        Iterable $i$f$mapNotNull22 = tpls;
        object3 = Reporter.Companion;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (ReporterTemplate)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl11 = false;
            Reporter reporter = this.toReporter((ReporterTemplate)it, reporterProviderById);
            object.add(reporter);
        }
        object = (List)destination$iv$iv3;
        $this$map$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Reporter[] reporterArray = thisCollection$iv.toArray(new Reporter[0]);
        if (reporterArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Reporter[] reporterArray2 = reporterArray;
        return object3.from(Arrays.copyOf(reporterArray2, reporterArray2.length));
    }

    /*
     * WARNING - void declaration
     */
    private final Reporter toReporter(ReporterTemplate $this$toReporter, Map<String, ? extends ReporterProvider> reporterProviderById) {
        PrintStream printStream;
        Object object;
        boolean bl;
        ReporterProvider reporterProvider = reporterProviderById.get($this$toReporter.getId());
        if (reporterProvider == null) {
            System.err.println("Error: reporter \"" + $this$toReporter.getId() + "\" wasn't found (available: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)reporterProviderById.keySet()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')');
            int n = 1;
            boolean bl2 = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (this.debug) {
            Object object2;
            PrintStream printStream2 = System.err;
            StringBuilder stringBuilder = new StringBuilder().append("[DEBUG] Initializing \"").append($this$toReporter.getId()).append("\" reporter with ").append($this$toReporter.getConfig());
            String string = $this$toReporter.getOutput();
            if (string == null) {
                object2 = "";
            } else {
                void it;
                String string2 = string;
                bl = false;
                boolean bl3 = false;
                String string3 = string2;
                StringBuilder stringBuilder2 = stringBuilder;
                PrintStream printStream3 = printStream2;
                boolean bl4 = false;
                String string4 = Intrinsics.stringPlus((String)", output=", (Object)it);
                printStream2 = printStream3;
                stringBuilder = stringBuilder2;
                object = string4;
                object2 = object == null ? "" : object;
            }
            printStream2.println(stringBuilder.append((String)object2).toString());
        }
        if ($this$toReporter.getOutput() != null) {
            object = new File($this$toReporter.getOutput()).getParentFile();
            if (object != null) {
                this.mkdirsOrFail((File)object);
            }
            printStream = new PrintStream($this$toReporter.getOutput(), "UTF-8");
        } else {
            printStream = this.stdin ? System.err : System.out;
        }
        PrintStream stream = printStream;
        Intrinsics.checkExpressionValueIsNotNull((Object)stream, (String)"stream");
        object = reporterProvider.get(stream, $this$toReporter.getConfig());
        boolean bl5 = false;
        bl = false;
        File reporter = object;
        boolean bl6 = false;
        return $this$toReporter.getOutput() != null ? (Reporter)new Reporter((Reporter)reporter, stream, this, $this$toReporter){
            private final /* synthetic */ Reporter $$delegate_0;
            final /* synthetic */ Reporter $reporter;
            final /* synthetic */ PrintStream $stream;
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ ReporterTemplate $this_toReporter;
            {
                this.$reporter = $reporter;
                this.$stream = $stream;
                this.this$0 = $receiver;
                this.$this_toReporter = $receiver2;
                this.$$delegate_0 = this.$reporter;
            }

            public void after(@NotNull String file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                this.$$delegate_0.after(file);
            }

            public void before(@NotNull String file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                this.$$delegate_0.before(file);
            }

            public void beforeAll() {
                this.$$delegate_0.beforeAll();
            }

            public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                this.$$delegate_0.onLintError(file, err, corrected);
            }

            public void afterAll() {
                this.$reporter.afterAll();
                this.$stream.close();
                if (KtlintCommandLine.access$getTripped$p(this.this$0).get()) {
                    File file = new File(this.$this_toReporter.getOutput()).getAbsoluteFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(output).absoluteFile");
                    String outputLocation = FileUtilsKt.location(file, this.this$0.getRelative());
                    System.err.println('\"' + this.$this_toReporter.getId() + "\" report written to " + outputLocation);
                }
            }
        } : reporter;
    }

    private final LintError toLintError(Exception $this$toLintError) {
        LintError lintError;
        Exception exception = $this$toLintError;
        boolean bl = false;
        boolean bl2 = false;
        Exception e = exception;
        boolean bl3 = false;
        Exception exception2 = e;
        if (exception2 instanceof ParseException) {
            String string;
            int n = ((ParseException)e).getLine();
            int n2 = ((ParseException)e).getCol();
            StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
            String string2 = e.getMessage();
            if (string2 == null) {
                string = null;
            } else {
                String string3 = string2;
                boolean bl4 = false;
                String string4 = string3.toLowerCase();
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            }
            lintError = new LintError(n, n2, "", stringBuilder.append((Object)string).append(')').toString());
        } else if (exception2 instanceof RuleExecutionException) {
            if (this.getDebug()) {
                System.err.println("[DEBUG] Internal Error (" + ((RuleExecutionException)e).getRuleId() + ')');
                e.printStackTrace(System.err);
            }
            lintError = new LintError(((RuleExecutionException)e).getLine(), ((RuleExecutionException)e).getCol(), "", "Internal Error (" + ((RuleExecutionException)e).getRuleId() + "). Please create a ticket at https://github.com/pinterest/ktlint/issues (if possible, provide the source code that triggered an error)");
        } else {
            throw e;
        }
        return lintError;
    }

    private final <T> List<T> head(List<? extends T> $this$head, int limit) {
        return limit == $this$head.size() ? $this$head : $this$head.subList(0, limit);
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashMap<String, String> parseQuery(String query) {
        void $this$fold$iv;
        Object object = new String[]{"&"};
        object = StringsKt.split$default((CharSequence)query, (String[])object, (boolean)false, (int)0, (int)6, null);
        LinkedHashMap<String, String> initial$iv = new LinkedHashMap<String, String>();
        boolean $i$f$fold = false;
        LinkedHashMap<String, String> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void s;
            String string = (String)element$iv;
            LinkedHashMap<String, String> map = accumulator$iv;
            boolean bl = false;
            Object object2 = (String[])s;
            boolean bl2 = false;
            if (!(object2.length() == 0)) {
                Object object3;
                object2 = new String[]{"="};
                object2 = StringsKt.split$default((CharSequence)((CharSequence)s), (String[])object2, (boolean)false, (int)2, (int)2, null);
                bl2 = false;
                boolean bl3 = false;
                Object e = object2;
                boolean bl4 = false;
                LinkedHashMap<String, String> linkedHashMap = map;
                Object e2 = e.get(0);
                Object object4 = e;
                int n = 1;
                boolean bl5 = false;
                if (n <= CollectionsKt.getLastIndex((List)object4)) {
                    object3 = object4.get(n);
                } else {
                    int n2 = n;
                    Object e3 = e2;
                    LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
                    boolean bl6 = false;
                    String string2 = "true";
                    linkedHashMap = linkedHashMap2;
                    e2 = e3;
                    object3 = string2;
                }
                linkedHashMap.put((String)e2, URLDecoder.decode((String)object3, "UTF-8"));
            }
            accumulator$iv = map;
        }
        return accumulator$iv;
    }

    private final void mkdirsOrFail(File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.isDirectory()) {
            throw new IOException("Unable to create \"" + $this$mkdirsOrFail + "\" directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void parallel(Sequence<? extends Callable<T>> $this$parallel, Function1<? super T, Unit> cb, int numberOfThreads) {
        Future pill2 = new Future<T>(){

            public boolean isDone() {
                throw new UnsupportedOperationException();
            }

            public T get(long timeout, @NotNull TimeUnit unit) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
                throw new UnsupportedOperationException();
            }

            public T get() {
                throw new UnsupportedOperationException();
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new UnsupportedOperationException();
            }

            public boolean isCancelled() {
                throw new UnsupportedOperationException();
            }
        };
        ArrayBlockingQueue q = new ArrayBlockingQueue(numberOfThreads);
        Thread producer2 = ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>($this$parallel, q, pill2){
            final /* synthetic */ Sequence<Callable<T>> $this_parallel;
            final /* synthetic */ ArrayBlockingQueue<Future<T>> $q;
            final /* synthetic */ parallel.pill.1 $pill;
            {
                this.$this_parallel = $receiver;
                this.$q = $q;
                this.$pill = $pill;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                ExecutorService executorService = Executors.newCachedThreadPool();
                try {
                    for (Callable task : this.$this_parallel) {
                        this.$q.put(executorService.submit(task));
                    }
                    this.$q.put(this.$pill);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    executorService.shutdown();
                }
            }
        }), (int)30, null);
        try {
            Future result;
            while (!Intrinsics.areEqual(result = q.take(), (Object)pill2)) {
                cb.invoke(result.get());
            }
        }
        finally {
            producer2.interrupt();
            producer2.join();
        }
    }

    static /* synthetic */ void parallel$default(KtlintCommandLine ktlintCommandLine, Sequence sequence, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        ktlintCommandLine.parallel(sequence, function1, n);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ReporterProvider> loadReporters(List<String> externalReportersJarPaths) {
        void $this$associateByTo$iv$iv;
        Collection $this$toTypedArray$iv = FileUtilsKt.toFilesURIList(externalReportersJarPaths);
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object = ServiceLoader.load(ReporterProvider.class, new URLClassLoader(uRLArray));
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"load(\n            ReporterProvider::class.java,\n            URLClassLoader(externalReportersJarPaths.toFilesURIList().toTypedArray())\n        )");
        Iterable $this$associateBy$iv = (Iterable)object;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        thisCollection$iv = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ReporterProvider reporterProvider = (ReporterProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getId();
            map.put(string, element$iv$iv);
        }
        object = destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        if (this.getDebug()) {
            Object $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = object2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl5 = false;
                String string = "[DEBUG] Discovered reporter with \"" + (String)entry.getKey() + "\" id.";
                boolean bl6 = false;
                System.out.println((Object)string);
            }
        }
        return object;
    }

    public static final /* synthetic */ AtomicInteger access$getErrorNumber$p(KtlintCommandLine $this) {
        return $this.errorNumber;
    }

    public static final /* synthetic */ int access$getLimit(KtlintCommandLine $this) {
        return $this.getLimit();
    }

    public static final /* synthetic */ List access$process(KtlintCommandLine $this, String fileName, String fileContent, Map ruleSetProviders, Map userData, List baselineErrors) {
        return $this.process(fileName, fileContent, ruleSetProviders, userData, baselineErrors);
    }

    public static final /* synthetic */ void access$report(KtlintCommandLine $this, String fileName, List errList, Reporter reporter) {
        $this.report(fileName, errList, reporter);
    }

    public static final /* synthetic */ AtomicBoolean access$getTripped$p(KtlintCommandLine $this) {
        return $this.tripped;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/KtlintCommandLine$LintErrorWithCorrectionInfo;", "", "err", "Lcom/pinterest/ktlint/core/LintError;", "corrected", "", "(Lcom/pinterest/ktlint/core/LintError;Z)V", "getCorrected", "()Z", "getErr", "()Lcom/pinterest/ktlint/core/LintError;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "ktlint"})
    private static final class LintErrorWithCorrectionInfo {
        @NotNull
        private final LintError err;
        private final boolean corrected;

        public LintErrorWithCorrectionInfo(@NotNull LintError err, boolean corrected) {
            Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
            this.err = err;
            this.corrected = corrected;
        }

        @NotNull
        public final LintError getErr() {
            return this.err;
        }

        public final boolean getCorrected() {
            return this.corrected;
        }

        @NotNull
        public final LintError component1() {
            return this.err;
        }

        public final boolean component2() {
            return this.corrected;
        }

        @NotNull
        public final LintErrorWithCorrectionInfo copy(@NotNull LintError err, boolean corrected) {
            Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
            return new LintErrorWithCorrectionInfo(err, corrected);
        }

        public static /* synthetic */ LintErrorWithCorrectionInfo copy$default(LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo, LintError lintError, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                lintError = lintErrorWithCorrectionInfo.err;
            }
            if ((n & 2) != 0) {
                bl = lintErrorWithCorrectionInfo.corrected;
            }
            return lintErrorWithCorrectionInfo.copy(lintError, bl);
        }

        @NotNull
        public String toString() {
            return "LintErrorWithCorrectionInfo(err=" + this.err + ", corrected=" + this.corrected + ')';
        }

        public int hashCode() {
            int result = this.err.hashCode();
            int n = this.corrected ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LintErrorWithCorrectionInfo)) {
                return false;
            }
            LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo = (LintErrorWithCorrectionInfo)other;
            if (!Intrinsics.areEqual((Object)this.err, (Object)lintErrorWithCorrectionInfo.err)) {
                return false;
            }
            return this.corrected == lintErrorWithCorrectionInfo.corrected;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JA\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/pinterest/ktlint/KtlintCommandLine$ReporterTemplate;", "", "id", "", "artifact", "config", "", "output", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getArtifact", "()Ljava/lang/String;", "getConfig", "()Ljava/util/Map;", "getId", "getOutput", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "ktlint"})
    private static final class ReporterTemplate {
        @NotNull
        private final String id;
        @Nullable
        private final String artifact;
        @NotNull
        private final Map<String, String> config;
        @Nullable
        private final String output;

        public ReporterTemplate(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            this.id = id;
            this.artifact = artifact;
            this.config = config;
            this.output = output;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getArtifact() {
            return this.artifact;
        }

        @NotNull
        public final Map<String, String> getConfig() {
            return this.config;
        }

        @Nullable
        public final String getOutput() {
            return this.output;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.artifact;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.config;
        }

        @Nullable
        public final String component4() {
            return this.output;
        }

        @NotNull
        public final ReporterTemplate copy(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            return new ReporterTemplate(id, artifact, config, output);
        }

        public static /* synthetic */ ReporterTemplate copy$default(ReporterTemplate reporterTemplate, String string, String string2, Map map, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reporterTemplate.id;
            }
            if ((n & 2) != 0) {
                string2 = reporterTemplate.artifact;
            }
            if ((n & 4) != 0) {
                map = reporterTemplate.config;
            }
            if ((n & 8) != 0) {
                string3 = reporterTemplate.output;
            }
            return reporterTemplate.copy(string, string2, map, string3);
        }

        @NotNull
        public String toString() {
            return "ReporterTemplate(id=" + this.id + ", artifact=" + this.artifact + ", config=" + this.config + ", output=" + this.output + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + (this.artifact == null ? 0 : this.artifact.hashCode());
            result = result * 31 + ((Object)this.config).hashCode();
            result = result * 31 + (this.output == null ? 0 : this.output.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReporterTemplate)) {
                return false;
            }
            ReporterTemplate reporterTemplate = (ReporterTemplate)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)reporterTemplate.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.artifact, (Object)reporterTemplate.artifact)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.config, reporterTemplate.config)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.output, (Object)reporterTemplate.output);
        }
    }
}

