/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.internal.FileUtilsKt;
import java.io.File;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0084\u0001\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u001426\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c0\u0016H\u0000\u001ah\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001c0 H\u0000\u001a*\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\b\b\u0002\u0010&\u001a\u00020#H\u0000\u001a\u0014\u0010'\u001a\u00020\u0014*\u00020$2\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a\u001c\u0010)\u001a\n **\u0004\u0018\u00010\u00010\u0001*\u00020+2\u0006\u0010,\u001a\u00020\u0014H\u0000\u001a$\u0010-\u001a\u0010\u0012\f\u0012\n **\u0004\u0018\u00010.0.0\u001e*\f\u0012\u0004\u0012\u00020\u00010\u001ej\u0002`/H\u0000\u001a\u001c\u00100\u001a\u00020\u0001*\u00020$2\u0006\u00101\u001a\u00020\u00012\u0006\u0010&\u001a\u00020#H\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003*\u0018\b\u0000\u00102\"\b\u0012\u0004\u0012\u00020\u00010\u001e2\b\u0012\u0004\u0012\u00020\u00010\u001e\u00a8\u00063"}, d2={"globSeparator", "", "getGlobSeparator", "()Ljava/lang/String;", "tildeRegex", "Lkotlin/text/Regex;", "workDir", "getWorkDir", "expandTilde", "path", "formatFile", "fileName", "fileContents", "ruleSets", "", "Lcom/pinterest/ktlint/core/RuleSet;", "userData", "", "editorConfigPath", "debug", "", "cb", "Lkotlin/Function2;", "Lcom/pinterest/ktlint/core/LintError;", "Lkotlin/ParameterName;", "name", "e", "corrected", "", "lintFile", "", "lintErrorCallback", "Lkotlin/Function1;", "fileSequence", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/Path;", "Ljava/nio/file/FileSystem;", "globs", "rootDir", "isGlobAbsolutePath", "glob", "location", "kotlin.jvm.PlatformType", "Ljava/io/File;", "relative", "toFilesURIList", "Ljava/net/URL;", "Lcom/pinterest/ktlint/internal/JarFiles;", "toGlob", "pattern", "JarFiles", "ktlint"})
public final class FileUtilsKt {
    @NotNull
    private static final String workDir;
    @NotNull
    private static final Regex tildeRegex;

    @NotNull
    public static final String getWorkDir() {
        return workDir;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<Path> fileSequence(@NotNull FileSystem $this$fileSequence, @NotNull List<String> globs, @NotNull Path rootDir) {
        Collection collection;
        Collection pathMatchers;
        Collection destination$iv$iv;
        Collection collection2;
        Object[] $i$f$mapTo2;
        Object object;
        Collection collection3;
        String it;
        Intrinsics.checkNotNullParameter((Object)$this$fileSequence, (String)"<this>");
        Intrinsics.checkNotNullParameter(globs, (String)"globs");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        boolean bl = false;
        List result = new ArrayList();
        Iterable $this$partition$iv = globs;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            boolean bl2;
            it = (String)element$iv;
            boolean bl3 = false;
            try {
                bl2 = Files.isRegularFile(rootDir.resolve(it), new LinkOption[0]);
            }
            catch (InvalidPathException e) {
                bl2 = false;
            }
            if (bl2) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List existingFiles = (List)pair.component1();
        List actualGlobs = (List)pair.component2();
        Iterable $this$mapTo$iv = existingFiles;
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (String)item$iv;
            collection3 = result;
            boolean bl4 = false;
            object = rootDir.resolve(it);
            collection3.add(object);
        }
        $this$mapTo$iv = result;
        $i$f$mapTo2 = false;
        if (!$this$mapTo$iv.isEmpty() && actualGlobs.isEmpty()) {
            return CollectionsKt.asSequence((Iterable)result);
        }
        if (actualGlobs.isEmpty()) {
            $i$f$mapTo2 = new PathMatcher[]{$this$fileSequence.getPathMatcher("glob:**" + FileUtilsKt.getGlobSeparator() + "*.kt"), $this$fileSequence.getPathMatcher("glob:**" + FileUtilsKt.getGlobSeparator() + "*.kts")};
            collection2 = SetsKt.setOf((Object[])$i$f$mapTo2);
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String it2;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Object item$iv;
            $i$f$mapTo2 = actualGlobs;
            boolean $i$f$filterNot = false;
            item$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it2 = (String)element$iv$iv;
                boolean bl5 = false;
                if (StringsKt.startsWith$default((String)it2, (String)"!", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl6 = false;
                object = $this$fileSequence.getPathMatcher(FileUtilsKt.toGlob($this$fileSequence, it2, rootDir));
                collection3.add(object);
            }
            collection2 = pathMatchers = (Collection)((List)destination$iv$iv);
        }
        if (actualGlobs.isEmpty()) {
            collection = SetsKt.emptySet();
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable $i$f$map = actualGlobs;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it3 = (String)element$iv$iv;
                boolean bl7 = false;
                if (!StringsKt.startsWith$default((String)it3, (String)"!", (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it3 = (String)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl8 = false;
                object = $this$fileSequence.getPathMatcher(FileUtilsKt.toGlob($this$fileSequence, StringsKt.removePrefix((String)it3, (CharSequence)"!"), rootDir));
                collection3.add(object);
            }
            collection = (List)destination$iv$iv2;
        }
        Collection negatedPathMatchers = collection;
        Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((Collection<? extends PathMatcher>)negatedPathMatchers, (Collection<? extends PathMatcher>)pathMatchers, (List<Path>)result){
            final /* synthetic */ Collection<PathMatcher> $negatedPathMatchers;
            final /* synthetic */ Collection<PathMatcher> $pathMatchers;
            final /* synthetic */ List<Path> $result;
            {
                this.$negatedPathMatchers = $negatedPathMatchers;
                this.$pathMatchers = $pathMatchers;
                this.$result = $result;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path filePath, @NotNull BasicFileAttributes fileAttrs) {
                PathMatcher it;
                boolean bl;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                    Intrinsics.checkNotNullParameter((Object)fileAttrs, (String)"fileAttrs");
                    Iterable $this$none$iv = this.$negatedPathMatchers;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (PathMatcher)element$iv;
                            boolean bl2 = false;
                            if (!it.matches(filePath)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    boolean bl3;
                    block9: {
                        Iterable $this$any$iv = this.$pathMatchers;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (PathMatcher)element$iv;
                                boolean bl4 = false;
                                if (!it.matches(filePath)) continue;
                                bl3 = true;
                                break block9;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        this.$result.add(filePath);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dirPath, @NotNull BasicFileAttributes dirAttr) {
                Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
                Intrinsics.checkNotNullParameter((Object)dirAttr, (String)"dirAttr");
                return Files.isHidden(dirPath) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }
        });
        return CollectionsKt.asSequence((Iterable)result);
    }

    public static /* synthetic */ Sequence fileSequence$default(FileSystem fileSystem, List list, Path path, int n, Object object) {
        if ((n & 2) != 0) {
            Path path2 = Paths.get(".", new String[0]).toAbsolutePath().normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(\".\").toAbsolutePath().normalize()");
            path = path2;
        }
        return FileUtilsKt.fileSequence(fileSystem, list, path);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isGlobAbsolutePath(FileSystem $this$isGlobAbsolutePath, String glob) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<Path> iterable = $this$isGlobAbsolutePath.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"rootDirectories");
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.toString();
                collection.add(string);
            }
            List rootDirs = (List)destination$iv$iv;
            Iterable $this$any$iv = rootDirs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.startsWith$default((String)StringsKt.removePrefix((String)glob, (CharSequence)"!"), (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final String toGlob(@NotNull FileSystem $this$toGlob, @NotNull String pattern, @NotNull Path rootDir) {
        String string;
        String expandedPath;
        Intrinsics.checkNotNullParameter((Object)$this$toGlob, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        String os = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)os, (String)"os");
        String string2 = expandedPath = StringsKt.startsWith((String)os, (String)"windows", (boolean)true) ? pattern : FileUtilsKt.expandTilde(pattern);
        if (FileUtilsKt.isGlobAbsolutePath($this$toGlob, expandedPath)) {
            string = expandedPath;
        } else {
            String string3 = ((Object)rootDir.toAbsolutePath()).toString();
            boolean bl = false;
            boolean bl2 = false;
            String $this$toGlob_u24lambda_u2d8 = string3;
            boolean bl3 = false;
            String string4 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"separator");
            String normalizedPath = !StringsKt.endsWith$default((String)$this$toGlob_u24lambda_u2d8, (String)string4, (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)$this$toGlob_u24lambda_u2d8, (Object)File.separator) : $this$toGlob_u24lambda_u2d8;
            String rootDirPath = normalizedPath;
            string = Intrinsics.stringPlus((String)rootDirPath, (Object)expandedPath);
        }
        String string5 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"separator");
        String fullPath = StringsKt.replace$default((String)string, (String)string5, (String)FileUtilsKt.getGlobSeparator(), (boolean)false, (int)4, null);
        return Intrinsics.stringPlus((String)"glob:", (Object)fullPath);
    }

    private static final String getGlobSeparator() {
        String os = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)os, (String)"os");
        return StringsKt.startsWith((String)os, (String)"windows", (boolean)true) ? "\\\\" : "/";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<URL> toFilesURIList(@NotNull List<String> $this$toFilesURIList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toFilesURIList, (String)"<this>");
        Iterable $this$map$iv = $this$toFilesURIList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File jarFile = new File(FileUtilsKt.expandTilde((String)it));
            if (!jarFile.exists()) {
                String string2 = "Error: " + (String)it + " does not exist";
                boolean bl2 = false;
                System.out.println((Object)string2);
                int n = 1;
                bl2 = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            URL uRL = jarFile.toURI().toURL();
            collection.add(uRL);
        }
        return (List)destination$iv$iv;
    }

    private static final String expandTilde(String path) {
        CharSequence charSequence = path;
        Regex regex = tildeRegex;
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"user.home\")");
        boolean bl = false;
        return regex.replaceFirst(charSequence, string);
    }

    public static final String location(@NotNull File $this$location, boolean relative) {
        Intrinsics.checkNotNullParameter((Object)$this$location, (String)"<this>");
        return relative ? FilesKt.toRelativeString((File)$this$location, (File)new File(workDir)) : $this$location.getPath();
    }

    public static final void lintFile(@NotNull String fileName, @NotNull String fileContents, @NotNull List<? extends RuleSet> ruleSets, @NotNull Map<String, String> userData, @Nullable String editorConfigPath, boolean debug, @NotNull Function1<? super LintError, Unit> lintErrorCallback) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileContents, (String)"fileContents");
        Intrinsics.checkNotNullParameter(ruleSets, (String)"ruleSets");
        Intrinsics.checkNotNullParameter(userData, (String)"userData");
        Intrinsics.checkNotNullParameter(lintErrorCallback, (String)"lintErrorCallback");
        boolean bl = !StringsKt.endsWith((String)fileName, (String)".kt", (boolean)true);
        KtLint.INSTANCE.lint(new KtLint.ExperimentalParams(fileName, fileContents, (Iterable)ruleSets, userData, (Function2)new Function2<LintError, Boolean, Unit>(lintErrorCallback){
            final /* synthetic */ Function1<LintError, Unit> $lintErrorCallback;
            {
                this.$lintErrorCallback = $lintErrorCallback;
                super(2);
            }

            public final void invoke(@NotNull LintError e, boolean $noName_1) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$lintErrorCallback.invoke((Object)e);
            }
        }, bl, editorConfigPath, debug, null, 256, null));
    }

    public static /* synthetic */ void lintFile$default(String string, String string2, List list, Map map, String string3, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            function1 = lintFile.1.INSTANCE;
        }
        FileUtilsKt.lintFile(string, string2, list, map, string3, bl, (Function1<? super LintError, Unit>)function1);
    }

    @NotNull
    public static final String formatFile(@NotNull String fileName, @NotNull String fileContents, @NotNull Iterable<? extends RuleSet> ruleSets, @NotNull Map<String, String> userData, @Nullable String editorConfigPath, boolean debug, @NotNull Function2<? super LintError, ? super Boolean, Unit> cb) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileContents, (String)"fileContents");
        Intrinsics.checkNotNullParameter(ruleSets, (String)"ruleSets");
        Intrinsics.checkNotNullParameter(userData, (String)"userData");
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        boolean bl = !StringsKt.endsWith((String)fileName, (String)".kt", (boolean)true);
        return KtLint.INSTANCE.format(new KtLint.ExperimentalParams(fileName, fileContents, ruleSets, userData, cb, bl, editorConfigPath, debug, null, 256, null));
    }

    static {
        String string = new File(".").getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(\".\").canonicalPath");
        workDir = string;
        tildeRegex = new Regex("^(!)?~");
    }
}

