/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.pinterest.ktlint.core.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.ParseException;
import com.pinterest.ktlint.core.Reporter;
import com.pinterest.ktlint.core.ReporterProvider;
import com.pinterest.ktlint.core.RuleExecutionException;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.RuleSetProvider;
import com.pinterest.ktlint.core.api.DefaultEditorConfigProperties;
import com.pinterest.ktlint.core.api.EditorConfigOverride;
import com.pinterest.ktlint.core.internal.CurrentBaseline;
import com.pinterest.ktlint.core.internal.CurrentBaselineKt;
import com.pinterest.ktlint.internal.FileUtilsKt;
import com.pinterest.ktlint.internal.KtlintCommandLine;
import com.pinterest.ktlint.internal.KtlintCommandLineKt;
import com.pinterest.ktlint.internal.KtlintVersionProvider;
import com.pinterest.ktlint.internal.LoadRuleSetsKt;
import com.pinterest.ktlint.reporter.plain.internal.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=KtlintVersionProvider.class, mixinStandardHelpOptions=true, headerHeading="\nAn anti-bikeshedding Kotlin linter with built-in formatter.\n(https://github.com/pinterest/ktlint).\n\nUsage:\n  ktlint <flags> [patterns]\n  java -jar ktlint.jar <flags> [patterns]\n\nExamples:\n  # Check the style of all Kotlin files (ending with '.kt' or '.kts') inside the current dir (recursively).\n  #\n  # Hidden folders will be skipped.\n  ktlint\n\n  # Check only certain locations starting from the current directory.\n  #\n  # Prepend ! to negate the pattern, KtLint uses .gitignore pattern style syntax.\n  # Globs are applied starting from the last one.\n  #\n  # Hidden folders will be skipped.\n  # Check all '.kt' files in 'src/' directory, but ignore files ending with 'Test.kt':\n  ktlint \"src/**/*.kt\" \"!src/**/*Test.kt\"\n  # Check all '.kt' files in 'src/' directory, but ignore 'generated' directory and its subdirectories:\n  ktlint \"src/**/*.kt\" \"!src/**/generated/**\"\n\n  # Auto-correct style violations.\n  ktlint -F \"src/**/*.kt\"\n\n  # Using custom reporter jar and overriding report location\n  ktlint --reporter=csv,artifact=/path/to/reporter/csv.jar,output=my-custom-report.csv\nFlags:\n", synopsisHeading="", customSynopsis={""}, sortOptions=false)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u0002lmB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020=H\u0002JH\u0010>\u001a\u00020=2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020A0@2\u0006\u0010B\u001a\u00020C2\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0,\u0018\u00010@2\u0006\u0010E\u001a\u00020FH\u0002J,\u0010G\u001a\u00020=2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020A0@2\u0006\u0010B\u001a\u00020C2\u0006\u0010E\u001a\u00020FH\u0002J\b\u0010H\u001a\u00020FH\u0002J2\u0010I\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 K*\b\u0012\u0002\b\u0003\u0018\u00010J0J0@2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\n0,H\u0002J,\u0010M\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0Nj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`O2\u0006\u0010P\u001a\u00020\nH\u0002JD\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0,2\u0006\u0010S\u001a\u00020\n2\u0006\u0010T\u001a\u00020\n2\u0006\u0010B\u001a\u00020C2\u000e\u0010U\u001a\n\u0012\u0004\u0012\u00020D\u0018\u00010,2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020X0WH\u0002J&\u0010Y\u001a\u00020=2\u0006\u0010S\u001a\u00020\n2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020R0,2\u0006\u0010E\u001a\u00020FH\u0002J\u0006\u0010[\u001a\u00020=J\f\u0010\\\u001a\u00020=*\u00020]H\u0002J<\u0010^\u001a\u00020=\"\u0004\b\u0000\u0010_*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H_0a0`2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u0002H_\u0012\u0004\u0012\u00020=0c2\b\b\u0002\u0010d\u001a\u00020\"H\u0002J\u001a\u0010e\u001a\u00020D*\u00060fj\u0002`g2\b\u0010h\u001a\u0004\u0018\u00010\u0001H\u0002J$\u0010i\u001a\u00020F*\u00020j2\u0016\u0010k\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030J0@H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u001e\u0010\u000e\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\bR\u001e\u0010\u0016\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\bR\u000e\u0010\u001f\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\u00020\"8B@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\"\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\n0&j\b\u0012\u0004\u0012\u00020\n`'8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0006\"\u0004\b*\u0010\bR\u001c\u0010+\u001a\f\u0012\u0004\u0012\u00020\n0,j\u0002`-8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R(\u0010.\u001a\f\u0012\u0004\u0012\u00020\n0,j\u0002`-8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0012\u00103\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0006\"\u0004\b6\u0010\bR\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00109\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/pinterest/ktlint/internal/KtlintCommandLine;", "", "()V", "android", "", "getAndroid", "()Z", "setAndroid", "(Z)V", "baseline", "", "color", "getColor", "setColor", "colorName", "getColorName", "()Ljava/lang/String;", "setColorName", "(Ljava/lang/String;)V", "debug", "getDebug", "setDebug", "disabledRules", "getDisabledRules", "setDisabledRules", "editorConfigPath", "errorNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "experimental", "getExperimental", "setExperimental", "fileNumber", "format", "limit", "", "getLimit", "()I", "patterns", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "relative", "getRelative", "setRelative", "reporters", "", "Lcom/pinterest/ktlint/internal/JarFiles;", "rulesetJarFiles", "getRulesetJarFiles", "()Ljava/util/List;", "setRulesetJarFiles", "(Ljava/util/List;)V", "stdin", "trace", "getTrace", "setTrace", "tripped", "Ljava/util/concurrent/atomic/AtomicBoolean;", "verbose", "configureLogger", "Lmu/KLogger;", "failOnOldRulesetProviderUsage", "", "lintFiles", "ruleSetProviders", "", "Lcom/pinterest/ktlint/core/RuleSetProvider;", "editorConfigOverride", "Lcom/pinterest/ktlint/core/api/EditorConfigOverride;", "Lcom/pinterest/ktlint/core/LintError;", "reporter", "Lcom/pinterest/ktlint/core/Reporter;", "lintStdin", "loadReporter", "loadReporters", "Lcom/pinterest/ktlint/core/ReporterProvider;", "kotlin.jvm.PlatformType", "externalReportersJarPaths", "parseQuery", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "query", "process", "Lcom/pinterest/ktlint/internal/KtlintCommandLine$LintErrorWithCorrectionInfo;", "fileName", "fileContent", "baselineErrors", "ruleSets", "", "Lcom/pinterest/ktlint/core/RuleSet;", "report", "errList", "run", "mkdirsOrFail", "Ljava/io/File;", "parallel", "T", "Lkotlin/sequences/Sequence;", "Ljava/util/concurrent/Callable;", "cb", "Lkotlin/Function1;", "numberOfThreads", "toLintError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "filename", "toReporter", "Lcom/pinterest/ktlint/internal/KtlintCommandLine$ReporterTemplate;", "reporterProviderById", "LintErrorWithCorrectionInfo", "ReporterTemplate", "ktlint"})
public final class KtlintCommandLine {
    @CommandLine.Option(names={"--android", "-a"}, description={"Turn on Android Kotlin Style Guide compatibility"})
    private boolean android;
    @CommandLine.Option(names={"--color"}, description={"Make output colorful"})
    private boolean color;
    @CommandLine.Option(names={"--color-name"}, description={"Customize the output color"})
    @NotNull
    private String colorName = Color.DARK_GRAY.name();
    @CommandLine.Option(names={"--debug"}, description={"Turn on debug output"})
    private boolean debug;
    @CommandLine.Option(names={"--trace"}, description={"Turn on trace output"})
    private boolean trace;
    @CommandLine.Option(names={"--disabled_rules"}, description={"Comma-separated list of rules to globally disable. To disable standard ktlint rule-set use --disabled_rules=standard"})
    @NotNull
    private String disabledRules = "";
    @CommandLine.Option(names={"--format", "-F"}, description={"Fix any deviations from the code style"})
    private boolean format;
    @CommandLine.Option(names={"--limit"}, description={"Maximum number of errors to show (default: show all)"})
    private int limit = -1;
    @CommandLine.Option(names={"--relative"}, description={"Print files relative to the working directory (e.g. dir/file.kt instead of /home/user/project/dir/file.kt)"})
    private boolean relative;
    @CommandLine.Option(names={"--reporter"}, description={"A reporter to use (built-in: plain (default), plain?group_by_file, json, sarif, checkstyle, html). To use a third-party reporter specify a path to a JAR file on the filesystem via ',artifact=' option. To override reporter output, use ',output=' option."})
    @NotNull
    private List<String> reporters = new ArrayList();
    @CommandLine.Option(names={"--ruleset", "-R"}, description={"A path to a JAR file containing additional ruleset(s)"})
    @NotNull
    private List<String> rulesetJarFiles = new ArrayList();
    @CommandLine.Option(names={"--stdin"}, description={"Read file from stdin"})
    private boolean stdin;
    @CommandLine.Option(names={"--verbose", "-v"}, description={"Show error codes"})
    private boolean verbose;
    @CommandLine.Option(names={"--editorconfig"}, description={"Path to .editorconfig"})
    @Nullable
    private String editorConfigPath;
    @CommandLine.Option(names={"--experimental"}, description={"Enabled experimental rules (ktlint-ruleset-experimental)"})
    private boolean experimental;
    @CommandLine.Option(names={"--baseline"}, description={"Defines a baseline file to check against"})
    @NotNull
    private String baseline = "";
    @CommandLine.Parameters(hidden=true)
    @NotNull
    private ArrayList<String> patterns = new ArrayList();
    @NotNull
    private final AtomicBoolean tripped = new AtomicBoolean();
    @NotNull
    private final AtomicInteger fileNumber = new AtomicInteger();
    @NotNull
    private final AtomicInteger errorNumber = new AtomicInteger();

    public final boolean getAndroid() {
        return this.android;
    }

    public final void setAndroid(boolean bl) {
        this.android = bl;
    }

    public final boolean getColor() {
        return this.color;
    }

    public final void setColor(boolean bl) {
        this.color = bl;
    }

    @NotNull
    public final String getColorName() {
        return this.colorName;
    }

    public final void setColorName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.colorName = string;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    public final boolean getTrace() {
        return this.trace;
    }

    public final void setTrace(boolean bl) {
        this.trace = bl;
    }

    @NotNull
    public final String getDisabledRules() {
        return this.disabledRules;
    }

    public final void setDisabledRules(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.disabledRules = string;
    }

    private final int getLimit() {
        return this.limit < 0 ? Integer.MAX_VALUE : this.limit;
    }

    public final boolean getRelative() {
        return this.relative;
    }

    public final void setRelative(boolean bl) {
        this.relative = bl;
    }

    @NotNull
    public final List<String> getRulesetJarFiles() {
        return this.rulesetJarFiles;
    }

    public final void setRulesetJarFiles(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.rulesetJarFiles = list;
    }

    public final boolean getExperimental() {
        return this.experimental;
    }

    public final void setExperimental(boolean bl) {
        this.experimental = bl;
    }

    public final void run() {
        Pair[] pairArray;
        if (this.verbose) {
            this.debug = true;
        }
        KtlintCommandLineKt.access$setLogger$p(this.configureLogger());
        this.failOnOldRulesetProviderUsage();
        long start = System.currentTimeMillis();
        CurrentBaseline baselineResults = CurrentBaselineKt.loadBaseline((String)this.baseline);
        SortedMap<String, RuleSetProvider> ruleSetProviders = LoadRuleSetsKt.loadRuleSets(this.rulesetJarFiles, this.experimental, this.debug, this.disabledRules);
        Reporter reporter = this.loadReporter();
        if (baselineResults.getBaselineGenerationNeeded()) {
            ReporterTemplate baselineReporter = new ReporterTemplate("baseline", null, MapsKt.emptyMap(), this.baseline);
            Map<String, ReporterProvider<?>> reporterProviderById = this.loadReporters(CollectionsKt.emptyList());
            Reporter[] reporterArray = new Reporter[]{reporter, this.toReporter(baselineReporter, reporterProviderById)};
            reporter = Reporter.Companion.from(reporterArray);
        }
        EditorConfigOverride editorConfigOverride = EditorConfigOverride.Companion.getEmptyEditorConfigOverride();
        if (!StringsKt.isBlank((CharSequence)this.disabledRules)) {
            pairArray = new Pair[]{TuplesKt.to((Object)DefaultEditorConfigProperties.INSTANCE.getDisabledRulesProperty(), (Object)this.disabledRules)};
            EditorConfigOverride.Companion.plus(editorConfigOverride, pairArray);
        }
        if (this.android) {
            pairArray = new Pair[]{TuplesKt.to((Object)DefaultEditorConfigProperties.INSTANCE.getCodeStyleSetProperty(), (Object)this.android)};
            EditorConfigOverride.Companion.plus(editorConfigOverride, pairArray);
        }
        reporter.beforeAll();
        if (this.stdin) {
            this.lintStdin((Map<String, ? extends RuleSetProvider>)ruleSetProviders, editorConfigOverride, reporter);
        } else {
            this.lintFiles((Map<String, ? extends RuleSetProvider>)ruleSetProviders, editorConfigOverride, baselineResults.getBaselineRules(), reporter);
        }
        reporter.afterAll();
        KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
        if (kLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            kLogger = null;
        }
        kLogger.debug((Function0)new Function0<Object>(start, this){
            final /* synthetic */ long $start;
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.$start = $start;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return System.currentTimeMillis() - this.$start + "ms / " + KtlintCommandLine.access$getFileNumber$p(this.this$0) + " file(s) / " + KtlintCommandLine.access$getErrorNumber$p(this.this$0) + " error(s)";
            }
        });
        if (this.tripped.get()) {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final KLogger configureLogger() {
        return KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KtLintKLoggerInitializerKt.setDefaultLoggerModifier((KLogger)KotlinLogging.INSTANCE.logger((Function0)configureLogger.1.INSTANCE), (Function1)((Function1)new Function1<KLogger, Unit>(this){
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KLogger logger2) {
                Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
                org.slf4j.Logger logger3 = logger2.getUnderlyingLogger();
                Intrinsics.checkNotNull((Object)logger3, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
                ((Logger)logger3).setLevel(this.this$0.getTrace() ? Level.TRACE : (this.this$0.getDebug() ? Level.DEBUG : Level.INFO));
            }
        })));
    }

    private final void lintFiles(Map<String, ? extends RuleSetProvider> ruleSetProviders, EditorConfigOverride editorConfigOverride, Map<String, ? extends List<LintError>> baseline, Reporter reporter) {
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault()");
        KtlintCommandLine.parallel$default(this, SequencesKt.map((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.map((Sequence)FileUtilsKt.fileSequence$default(fileSystem, this.patterns, null, 2, null), (Function1)lintFiles.1.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(File it) {
                return KtlintCommandLine.access$getErrorNumber$p(this.this$0).get() < KtlintCommandLine.access$getLimit(this.this$0);
            }
        })), (Function1)((Function1)new Function1<File, Callable<Pair<? extends File, ? extends List<? extends LintErrorWithCorrectionInfo>>>>(ruleSetProviders, this, editorConfigOverride, baseline){
            final /* synthetic */ Map<String, RuleSetProvider> $ruleSetProviders;
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ EditorConfigOverride $editorConfigOverride;
            final /* synthetic */ Map<String, List<LintError>> $baseline;
            {
                this.$ruleSetProviders = $ruleSetProviders;
                this.this$0 = $receiver;
                this.$editorConfigOverride = $editorConfigOverride;
                this.$baseline = $baseline;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Callable<Pair<File, List<LintErrorWithCorrectionInfo>>> invoke(File file) {
                void $this$mapTo$iv$iv;
                Map<String, RuleSetProvider> $this$map$iv = this.$ruleSetProviders;
                boolean $i$f$map = false;
                Map<String, RuleSetProvider> map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((RuleSetProvider)it.getValue()).get());
                }
                List ruleSets = (List)destination$iv$iv;
                return () -> lintFiles.3.invoke$lambda-1(file, this.this$0, this.$editorConfigOverride, this.$baseline, ruleSets);
            }

            private static final Pair invoke$lambda-1(File $file, KtlintCommandLine this$0, EditorConfigOverride $editorConfigOverride, Map $baseline, List $ruleSets) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$editorConfigOverride, (String)"$editorConfigOverride");
                Intrinsics.checkNotNullParameter((Object)$ruleSets, (String)"$ruleSets");
                String string = $file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                Intrinsics.checkNotNullExpressionValue((Object)$file, (String)"file");
                Map map = $baseline;
                return TuplesKt.to((Object)$file, (Object)KtlintCommandLine.access$process(this$0, string, FilesKt.readText$default((File)$file, null, (int)1, null), $editorConfigOverride, map != null ? (List)map.get(CurrentBaselineKt.getRelativeRoute((File)$file)) : null, $ruleSets));
            }
        })), (Function1)new Function1<Pair<? extends File, ? extends List<? extends LintErrorWithCorrectionInfo>>, Unit>(this, reporter){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ Reporter $reporter;
            {
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(Pair<? extends File, ? extends List<LintErrorWithCorrectionInfo>> pair) {
                File file = (File)pair.component1();
                List errList = (List)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                String string = FileUtilsKt.location(file, this.this$0.getRelative());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.location(relative)");
                KtlintCommandLine.access$report(this.this$0, string, errList, this.$reporter);
            }
        }, 0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void lintStdin(Map<String, ? extends RuleSetProvider> ruleSetProviders, EditorConfigOverride editorConfigOverride, Reporter reporter) {
        Collection<RuleSet> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        InputStream inputStream = System.in;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"`in`");
        Object object = ByteStreamsKt.readBytes((InputStream)inputStream);
        String string = new String((byte[])object, Charsets.UTF_8);
        object = ruleSetProviders;
        List<LintError> list = null;
        EditorConfigOverride editorConfigOverride2 = editorConfigOverride;
        String string2 = string;
        String string3 = "<stdin>";
        KtlintCommandLine ktlintCommandLine = this;
        String string4 = "<stdin>";
        KtlintCommandLine ktlintCommandLine2 = this;
        boolean $i$f$map = false;
        void var6_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((RuleSetProvider)it.getValue()).get());
        }
        collection = (List)destination$iv$iv;
        ktlintCommandLine2.report(string4, ktlintCommandLine.process(string3, string2, editorConfigOverride2, list, (Iterable<? extends RuleSet>)collection), reporter);
    }

    private final void failOnOldRulesetProviderUsage() {
        ServiceLoader<com.github.shyiko.ktlint.core.RuleSetProvider> serviceLoader = ServiceLoader.load(com.github.shyiko.ktlint.core.RuleSetProvider.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(com.github.shyiko.k\u2026eSetProvider::class.java)");
        if (CollectionsKt.any((Iterable)serviceLoader)) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.error((Function0)failOnOldRulesetProviderUsage.1.INSTANCE);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void report(String fileName, List<LintErrorWithCorrectionInfo> errList, Reporter reporter) {
        this.fileNumber.incrementAndGet();
        int errListLimit = Math.min(errList.size(), Math.max(this.getLimit() - this.errorNumber.get(), 0));
        this.errorNumber.addAndGet(errListLimit);
        reporter.before(fileName);
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)errList, (int)errListLimit);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo = (LintErrorWithCorrectionInfo)element$iv;
            boolean bl = false;
            LintError err = lintErrorWithCorrectionInfo.component1();
            boolean corrected = lintErrorWithCorrectionInfo.component2();
            reporter.onLintError(fileName, !err.getCanBeAutoCorrected() ? LintError.copy$default((LintError)err, (int)0, (int)0, null, (String)(err.getDetail() + " (cannot be auto-corrected)"), (int)7, null) : err, corrected);
        }
        reporter.after(fileName);
    }

    private final List<LintErrorWithCorrectionInfo> process(String fileName, String fileContent, EditorConfigOverride editorConfigOverride, List<LintError> baselineErrors, Iterable<? extends RuleSet> ruleSets) {
        KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
        if (kLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            kLogger = null;
        }
        kLogger.trace((Function0)new Function0<Object>(fileName, this){
            final /* synthetic */ String $fileName;
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.$fileName = $fileName;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String fileLocation = !Intrinsics.areEqual((Object)this.$fileName, (Object)"<stdin>") ? FileUtilsKt.location(new File(this.$fileName), this.this$0.getRelative()) : this.$fileName;
                return "Checking " + fileLocation;
            }
        });
        ArrayList<LintErrorWithCorrectionInfo> result = new ArrayList<LintErrorWithCorrectionInfo>();
        if (this.format) {
            String string;
            try {
                string = FileUtilsKt.formatFile(fileName, fileContent, ruleSets, editorConfigOverride, this.editorConfigPath, this.debug, (Function2<? super LintError, ? super Boolean, Unit>)((Function2)new Function2<LintError, Boolean, Unit>(baselineErrors, result, this){
                    final /* synthetic */ List<LintError> $baselineErrors;
                    final /* synthetic */ ArrayList<LintErrorWithCorrectionInfo> $result;
                    final /* synthetic */ KtlintCommandLine this$0;
                    {
                        this.$baselineErrors = $baselineErrors;
                        this.$result = $result;
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull LintError err, boolean corrected) {
                        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
                        if (!(corrected || this.$baselineErrors != null && CurrentBaselineKt.containsLintError(this.$baselineErrors, (LintError)err))) {
                            this.$result.add(new LintErrorWithCorrectionInfo(err, corrected));
                            KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                        }
                    }
                }));
            }
            catch (Exception e) {
                result.add(new LintErrorWithCorrectionInfo(this.toLintError(e, fileName), false));
                this.tripped.set(true);
                string = fileContent;
            }
            String formattedFileContent2 = string;
            if (this.stdin) {
                System.out.print((Object)formattedFileContent2);
            } else if (fileContent != formattedFileContent2) {
                File file = new File(fileName);
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
                FilesKt.writeText((File)file, (String)formattedFileContent2, (Charset)charset);
            }
        } else {
            try {
                FileUtilsKt.lintFile(fileName, fileContent, ruleSets, editorConfigOverride, this.editorConfigPath, this.debug, (Function1<? super LintError, Unit>)((Function1)new Function1<LintError, Unit>(baselineErrors, result, this){
                    final /* synthetic */ List<LintError> $baselineErrors;
                    final /* synthetic */ ArrayList<LintErrorWithCorrectionInfo> $result;
                    final /* synthetic */ KtlintCommandLine this$0;
                    {
                        this.$baselineErrors = $baselineErrors;
                        this.$result = $result;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull LintError err) {
                        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
                        if (this.$baselineErrors == null || !CurrentBaselineKt.containsLintError(this.$baselineErrors, (LintError)err)) {
                            this.$result.add(new LintErrorWithCorrectionInfo(err, false));
                            KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                        }
                    }
                }));
            }
            catch (Exception e) {
                result.add(new LintErrorWithCorrectionInfo(this.toLintError(e, fileName), false));
                this.tripped.set(true);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Reporter loadReporter() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Collection collection;
        Collection collection2 = this.reporters;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)"plain");
        } else {
            collection = collection2;
        }
        List configuredReporters = (List)collection;
        Iterable $this$map$iv2 = configuredReporters;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            String string;
            String string2;
            String string3;
            Map map;
            String string4;
            block12: {
                String string5;
                Object v1;
                String it;
                Object element$iv;
                List $this$lastOrNull$iv;
                String rawReporterConfig;
                List split;
                block11: {
                    void reporter;
                    String string6 = (String)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    Object object2 = new String[]{","};
                    split = StringsKt.split$default((CharSequence)((CharSequence)reporter), (String[])object2, (boolean)false, (int)0, (int)6, null);
                    String[] stringArray = new String[]{"?"};
                    object2 = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)((CharSequence)split.get(0)), (String[])stringArray, (boolean)false, (int)2, (int)2, null), (Iterable)CollectionsKt.listOf((Object)""));
                    String reporterId = (String)object2.get(0);
                    rawReporterConfig = (String)object2.get(1);
                    List list = split;
                    string4 = reporterId;
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        element$iv = iterator$iv.previous();
                        it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"artifact=", (boolean)false, (int)2, null)) continue;
                        v1 = element$iv;
                        break block11;
                    }
                    v1 = null;
                }
                String string7 = string4;
                if ((String)v1 != null) {
                    void it2;
                    string4 = string7;
                    boolean bl = false;
                    element$iv = new String[]{"="};
                    string5 = (String)StringsKt.split$default((CharSequence)((CharSequence)it2), element$iv, (boolean)false, (int)0, (int)6, null).get(1);
                    string7 = string4;
                } else {
                    string5 = null;
                }
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"verbose", (Object)String.valueOf(this.verbose)), TuplesKt.to((Object)"color", (Object)String.valueOf(this.color)), TuplesKt.to((Object)"color_name", (Object)this.colorName)};
                $this$lastOrNull$iv = split;
                map = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)this.parseQuery(rawReporterConfig));
                string3 = string5;
                string4 = string7;
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    element$iv = iterator$iv.previous();
                    it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"output=", (boolean)false, (int)2, null)) continue;
                    string2 = (String)element$iv;
                    break block12;
                }
                string2 = null;
            }
            String string8 = string2;
            String string9 = string4;
            String string10 = string3;
            Map map2 = map;
            if ((String)string8 != null) {
                void it;
                map = map2;
                string3 = string10;
                string4 = string9;
                boolean bl = false;
                String[] stringArray = new String[]{"="};
                string8 = (String)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                string9 = string4;
                string10 = string3;
                map2 = map;
                string = string8;
            } else {
                string = null;
            }
            String string11 = string;
            Map map3 = map2;
            String string12 = string10;
            String string13 = string9;
            object.add(new ReporterTemplate(string13, string12, map3, string11));
        }
        List tpls = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = tpls;
        object = this;
        boolean $i$f$mapNotNull22 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl3 = false;
            ReporterTemplate it = (ReporterTemplate)element$iv$iv;
            boolean bl4 = false;
            if (it.getArtifact() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Map<String, ReporterProvider<?>> reporterProviderById = super.loadReporters((List)destination$iv$iv2);
        Iterable $i$f$mapNotNull22 = tpls;
        object = Reporter.Companion;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (ReporterTemplate)item$iv$iv;
            Collection collection3 = destination$iv$iv3;
            boolean bl6 = false;
            collection3.add(this.toReporter((ReporterTemplate)it, reporterProviderById));
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Reporter[] reporterArray = thisCollection$iv.toArray(new Reporter[0]);
        Intrinsics.checkNotNull((Object)reporterArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Reporter[] reporterArray2 = reporterArray;
        return object.from(Arrays.copyOf(reporterArray2, reporterArray2.length));
    }

    private final Reporter toReporter(ReporterTemplate $this$toReporter, Map<String, ? extends ReporterProvider<?>> reporterProviderById) {
        PrintStream printStream;
        ReporterProvider<?> reporterProvider = reporterProviderById.get($this$toReporter.getId());
        if (reporterProvider == null) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.error((Function0)new Function0<Object>($this$toReporter, reporterProviderById){
                final /* synthetic */ ReporterTemplate $this_toReporter;
                final /* synthetic */ Map<String, ReporterProvider<?>> $reporterProviderById;
                {
                    this.$this_toReporter = $receiver;
                    this.$reporterProviderById = $reporterProviderById;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "reporter \"" + this.$this_toReporter.getId() + "\" wasn't found (available: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)this.$reporterProviderById.keySet()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
                }
            });
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
        if (kLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            kLogger = null;
        }
        kLogger.debug((Function0)new Function0<Object>($this$toReporter){
            final /* synthetic */ ReporterTemplate $this_toReporter;
            {
                this.$this_toReporter = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string;
                StringBuilder stringBuilder;
                block3: {
                    block2: {
                        stringBuilder = new StringBuilder().append("Initializing \"").append(this.$this_toReporter.getId()).append("\" reporter with ").append(this.$this_toReporter.getConfig());
                        string = this.$this_toReporter.getOutput();
                        if (string == null) break block2;
                        String it = string;
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl = false;
                        String string2 = ", output=" + it;
                        stringBuilder = stringBuilder2;
                        string = string2;
                        if (string2 != null) break block3;
                    }
                    string = "";
                }
                return stringBuilder.append(string).toString();
            }
        });
        if ($this$toReporter.getOutput() != null) {
            File file = new File($this$toReporter.getOutput()).getParentFile();
            if (file != null) {
                this.mkdirsOrFail(file);
            }
            printStream = new PrintStream($this$toReporter.getOutput(), "UTF-8");
        } else {
            printStream = this.stdin ? System.err : System.out;
        }
        PrintStream stream = printStream;
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
        Reporter reporter = reporterProvider.get(stream, $this$toReporter.getConfig());
        boolean bl = false;
        return $this$toReporter.getOutput() != null ? (Reporter)new Reporter(reporter, stream, this, $this$toReporter){
            private final /* synthetic */ Reporter $$delegate_0;
            final /* synthetic */ Reporter $reporter;
            final /* synthetic */ PrintStream $stream;
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ ReporterTemplate $this_toReporter;
            {
                this.$reporter = $reporter;
                this.$stream = $stream;
                this.this$0 = $receiver;
                this.$this_toReporter = $receiver2;
                this.$$delegate_0 = $reporter;
            }

            public void after(@NotNull String file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.$$delegate_0.after(file);
            }

            public void before(@NotNull String file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.$$delegate_0.before(file);
            }

            public void beforeAll() {
                this.$$delegate_0.beforeAll();
            }

            public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)err, (String)"err");
                this.$$delegate_0.onLintError(file, err, corrected);
            }

            public void afterAll() {
                this.$reporter.afterAll();
                this.$stream.close();
                if (KtlintCommandLine.access$getTripped$p(this.this$0).get()) {
                    File file = new File(this.$this_toReporter.getOutput()).getAbsoluteFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(output).absoluteFile");
                    String outputLocation = FileUtilsKt.location(file, this.this$0.getRelative());
                    KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                    if (kLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        kLogger = null;
                    }
                    kLogger.info((Function0)new Function0<Object>(this.$this_toReporter, outputLocation){
                        final /* synthetic */ ReporterTemplate $this_toReporter;
                        final /* synthetic */ String $outputLocation;
                        {
                            this.$this_toReporter = $receiver;
                            this.$outputLocation = $outputLocation;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return '\"' + this.$this_toReporter.getId() + "\" report written to " + this.$outputLocation;
                        }
                    });
                }
            }
        } : reporter;
    }

    private final LintError toLintError(Exception $this$toLintError, Object filename) {
        LintError lintError;
        Exception e = $this$toLintError;
        boolean bl = false;
        Exception exception = e;
        if (exception instanceof ParseException) {
            String string;
            int n = ((ParseException)e).getLine();
            int n2 = ((ParseException)e).getCol();
            StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
            String string2 = e.getMessage();
            if (string2 != null) {
                String string3 = string2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string4 = string3.toLowerCase(locale);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
            } else {
                string = null;
            }
            lintError = new LintError(n, n2, "", stringBuilder.append(string).append(')').toString());
        } else if (exception instanceof RuleExecutionException) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.debug("Internal Error (" + ((RuleExecutionException)e).getRuleId() + ") in file '" + filename + "' at position '" + ((RuleExecutionException)e).getLine() + ':' + ((RuleExecutionException)e).getCol(), (Throwable)e);
            lintError = new LintError(((RuleExecutionException)e).getLine(), ((RuleExecutionException)e).getCol(), "", "Internal Error (" + ((RuleExecutionException)e).getRuleId() + ") in file '" + filename + "' at position '" + ((RuleExecutionException)e).getLine() + ':' + ((RuleExecutionException)e).getCol() + ". Please create a ticket at https://github.com/pinterest/ktlint/issues (if possible, please re-run with the --debug flag to get the stacktrace and provide the source code that triggered an error)");
        } else {
            throw e;
        }
        return lintError;
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashMap<String, String> parseQuery(String query) {
        void $this$fold$iv;
        Object object = new String[]{"&"};
        object = StringsKt.split$default((CharSequence)query, (String[])object, (boolean)false, (int)0, (int)6, null);
        LinkedHashMap<String, String> initial$iv = new LinkedHashMap<String, String>();
        boolean $i$f$fold = false;
        LinkedHashMap<String, String> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void s;
            String string = (String)element$iv;
            LinkedHashMap<String, String> map = accumulator$iv;
            boolean bl = false;
            if (((CharSequence)s).length() > 0) {
                Object object2;
                String[] stringArray = new String[]{"="};
                List e = StringsKt.split$default((CharSequence)((CharSequence)s), (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                boolean bl2 = false;
                LinkedHashMap<String, String> linkedHashMap = map;
                Object e2 = e.get(0);
                int n = 1;
                List list = e;
                if (n <= CollectionsKt.getLastIndex((List)list)) {
                    object2 = list.get(n);
                } else {
                    int n2 = n;
                    Object e3 = e2;
                    LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
                    boolean bl3 = false;
                    String string2 = "true";
                    linkedHashMap = linkedHashMap2;
                    e2 = e3;
                    object2 = string2;
                }
                linkedHashMap.put((String)e2, URLDecoder.decode((String)object2, "UTF-8"));
            }
            accumulator$iv = map;
        }
        return accumulator$iv;
    }

    private final void mkdirsOrFail(File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.isDirectory()) {
            throw new IOException("Unable to create \"" + $this$mkdirsOrFail + "\" directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void parallel(Sequence<? extends Callable<T>> $this$parallel, Function1<? super T, Unit> cb, int numberOfThreads) {
        Future pill2 = new Future<T>(){

            public boolean isDone() {
                throw new UnsupportedOperationException();
            }

            public T get(long timeout, @NotNull TimeUnit unit) {
                Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
                throw new UnsupportedOperationException();
            }

            public T get() {
                throw new UnsupportedOperationException();
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new UnsupportedOperationException();
            }

            public boolean isCancelled() {
                throw new UnsupportedOperationException();
            }
        };
        ArrayBlockingQueue q = new ArrayBlockingQueue(numberOfThreads);
        Thread producer2 = ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>($this$parallel, q, pill2){
            final /* synthetic */ Sequence<Callable<T>> $this_parallel;
            final /* synthetic */ ArrayBlockingQueue<Future<T>> $q;
            final /* synthetic */ parallel.pill.1 $pill;
            {
                this.$this_parallel = $receiver;
                this.$q = $q;
                this.$pill = $pill;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                ExecutorService executorService = Executors.newCachedThreadPool();
                try {
                    for (Callable task : this.$this_parallel) {
                        this.$q.put(executorService.submit(task));
                    }
                    this.$q.put(this.$pill);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    executorService.shutdown();
                }
            }
        }), (int)30, null);
        try {
            Future result;
            while (!Intrinsics.areEqual(result = q.take(), (Object)pill2)) {
                cb.invoke(result.get());
            }
        }
        finally {
            producer2.interrupt();
            producer2.join();
        }
    }

    static /* synthetic */ void parallel$default(KtlintCommandLine ktlintCommandLine, Sequence sequence, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        ktlintCommandLine.parallel(sequence, function1, n);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ReporterProvider<?>> loadReporters(List<String> externalReportersJarPaths) {
        Map map;
        void $this$associateByTo$iv$iv;
        Collection $this$toTypedArray$iv = FileUtilsKt.toFilesURIList(externalReportersJarPaths);
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        Intrinsics.checkNotNull((Object)uRLArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        ServiceLoader<ReporterProvider> serviceLoader = ServiceLoader.load(ReporterProvider.class, new URLClassLoader(uRLArray));
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(\n            Report\u2026toTypedArray())\n        )");
        Iterable $this$associateBy$iv = serviceLoader;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        thisCollection$iv = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ReporterProvider reporterProvider = (ReporterProvider)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getId(), element$iv$iv);
        }
        Map $this$onEach$iv = destination$iv$iv;
        boolean $i$f$onEach = false;
        Map $this$onEach_u24lambda_u2d2$iv = map = $this$onEach$iv;
        boolean bl = false;
        Iterator iterator = $this$onEach_u24lambda_u2d2$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.debug((Function0)new Function0<Object>(entry){
                final /* synthetic */ Map.Entry<String, ReporterProvider<?>> $entry;
                {
                    this.$entry = $entry;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Discovered reporter with \"" + this.$entry.getKey() + "\" id.";
                }
            });
        }
        return map;
    }

    public static final /* synthetic */ AtomicInteger access$getFileNumber$p(KtlintCommandLine $this) {
        return $this.fileNumber;
    }

    public static final /* synthetic */ AtomicInteger access$getErrorNumber$p(KtlintCommandLine $this) {
        return $this.errorNumber;
    }

    public static final /* synthetic */ int access$getLimit(KtlintCommandLine $this) {
        return $this.getLimit();
    }

    public static final /* synthetic */ List access$process(KtlintCommandLine $this, String fileName, String fileContent, EditorConfigOverride editorConfigOverride, List baselineErrors, Iterable ruleSets) {
        return $this.process(fileName, fileContent, editorConfigOverride, baselineErrors, ruleSets);
    }

    public static final /* synthetic */ void access$report(KtlintCommandLine $this, String fileName, List errList, Reporter reporter) {
        $this.report(fileName, errList, reporter);
    }

    public static final /* synthetic */ AtomicBoolean access$getTripped$p(KtlintCommandLine $this) {
        return $this.tripped;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/internal/KtlintCommandLine$LintErrorWithCorrectionInfo;", "", "err", "Lcom/pinterest/ktlint/core/LintError;", "corrected", "", "(Lcom/pinterest/ktlint/core/LintError;Z)V", "getCorrected", "()Z", "getErr", "()Lcom/pinterest/ktlint/core/LintError;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "ktlint"})
    private static final class LintErrorWithCorrectionInfo {
        @NotNull
        private final LintError err;
        private final boolean corrected;

        public LintErrorWithCorrectionInfo(@NotNull LintError err, boolean corrected) {
            Intrinsics.checkNotNullParameter((Object)err, (String)"err");
            this.err = err;
            this.corrected = corrected;
        }

        @NotNull
        public final LintError getErr() {
            return this.err;
        }

        public final boolean getCorrected() {
            return this.corrected;
        }

        @NotNull
        public final LintError component1() {
            return this.err;
        }

        public final boolean component2() {
            return this.corrected;
        }

        @NotNull
        public final LintErrorWithCorrectionInfo copy(@NotNull LintError err, boolean corrected) {
            Intrinsics.checkNotNullParameter((Object)err, (String)"err");
            return new LintErrorWithCorrectionInfo(err, corrected);
        }

        public static /* synthetic */ LintErrorWithCorrectionInfo copy$default(LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo, LintError lintError, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                lintError = lintErrorWithCorrectionInfo.err;
            }
            if ((n & 2) != 0) {
                bl = lintErrorWithCorrectionInfo.corrected;
            }
            return lintErrorWithCorrectionInfo.copy(lintError, bl);
        }

        @NotNull
        public String toString() {
            return "LintErrorWithCorrectionInfo(err=" + this.err + ", corrected=" + this.corrected + ')';
        }

        public int hashCode() {
            int result = this.err.hashCode();
            int n = this.corrected ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LintErrorWithCorrectionInfo)) {
                return false;
            }
            LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo = (LintErrorWithCorrectionInfo)other;
            if (!Intrinsics.areEqual((Object)this.err, (Object)lintErrorWithCorrectionInfo.err)) {
                return false;
            }
            return this.corrected == lintErrorWithCorrectionInfo.corrected;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JA\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/pinterest/ktlint/internal/KtlintCommandLine$ReporterTemplate;", "", "id", "", "artifact", "config", "", "output", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getArtifact", "()Ljava/lang/String;", "getConfig", "()Ljava/util/Map;", "getId", "getOutput", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "ktlint"})
    private static final class ReporterTemplate {
        @NotNull
        private final String id;
        @Nullable
        private final String artifact;
        @NotNull
        private final Map<String, String> config;
        @Nullable
        private final String output;

        public ReporterTemplate(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(config, (String)"config");
            this.id = id;
            this.artifact = artifact;
            this.config = config;
            this.output = output;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getArtifact() {
            return this.artifact;
        }

        @NotNull
        public final Map<String, String> getConfig() {
            return this.config;
        }

        @Nullable
        public final String getOutput() {
            return this.output;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.artifact;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.config;
        }

        @Nullable
        public final String component4() {
            return this.output;
        }

        @NotNull
        public final ReporterTemplate copy(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(config, (String)"config");
            return new ReporterTemplate(id, artifact, config, output);
        }

        public static /* synthetic */ ReporterTemplate copy$default(ReporterTemplate reporterTemplate, String string, String string2, Map map, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reporterTemplate.id;
            }
            if ((n & 2) != 0) {
                string2 = reporterTemplate.artifact;
            }
            if ((n & 4) != 0) {
                map = reporterTemplate.config;
            }
            if ((n & 8) != 0) {
                string3 = reporterTemplate.output;
            }
            return reporterTemplate.copy(string, string2, map, string3);
        }

        @NotNull
        public String toString() {
            return "ReporterTemplate(id=" + this.id + ", artifact=" + this.artifact + ", config=" + this.config + ", output=" + this.output + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + (this.artifact == null ? 0 : this.artifact.hashCode());
            result = result * 31 + ((Object)this.config).hashCode();
            result = result * 31 + (this.output == null ? 0 : this.output.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReporterTemplate)) {
                return false;
            }
            ReporterTemplate reporterTemplate = (ReporterTemplate)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)reporterTemplate.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.artifact, (Object)reporterTemplate.artifact)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.config, reporterTemplate.config)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.output, (Object)reporterTemplate.output);
        }
    }
}

