/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.core.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.core.RuleSetProvider;
import com.pinterest.ktlint.internal.FileUtilsKt;
import com.pinterest.ktlint.internal.LoadRuleSetsKt;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0002\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\f\u0010\r\u001a\u00020\t*\u00020\u000eH\u0002\u001a:\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\u0010*\f\u0012\u0004\u0012\u00020\u000e0\u0005j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"logger", "Lmu/KLogger;", "getRuleSetProvidersByUrl", "Lkotlin/Pair;", "Ljava/net/URL;", "", "Lcom/pinterest/ktlint/core/RuleSetProvider;", "url", "debug", "", "reportWhenMissingCustomRuleSetProvider", "", "ruleSetProviders", "isStandardRuleSetDisabled", "", "loadRuleSets", "Ljava/util/SortedMap;", "Lcom/pinterest/ktlint/internal/JarFiles;", "loadExperimental", "disabledRules", "ktlint"})
public final class LoadRuleSetsKt {
    @NotNull
    private static final KLogger logger = KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE));

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SortedMap<String, RuleSetProvider> loadRuleSets(@NotNull List<String> $this$loadRuleSets, boolean loadExperimental, boolean debug, @NotNull String disabledRules) {
        Map $this$filterKeys$iv;
        void $this$associateByTo$iv$iv;
        Map $this$associateBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Pair it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter($this$loadRuleSets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)disabledRules, (String)"disabledRules");
        Iterable iterable = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)FileUtilsKt.toFilesURIList($this$loadRuleSets), null));
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            URL uRL = (URL)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(LoadRuleSetsKt.getRuleSetProvidersByUrl((URL)it, debug));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            URL url = (URL)it.component1();
            List ruleSetProviders = (List)it.component2();
            if (url != null) {
                LoadRuleSetsKt.reportWhenMissingCustomRuleSetProvider(url, ruleSetProviders);
            }
            Iterable list$iv$iv = ruleSetProviders;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv), (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            RuleSetProvider bl = (RuleSetProvider)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it2.get().getId(), element$iv$iv);
        }
        $this$associateBy$iv = destination$iv$iv2;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it3 = (String)entry$iv.getKey();
            boolean bl = false;
            if (!(loadExperimental || !Intrinsics.areEqual((Object)it3, (Object)"experimental"))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        $i$f$filterKeys = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it4 = (String)entry$iv.getKey();
            boolean bl = false;
            if (!(!LoadRuleSetsKt.isStandardRuleSetDisabled(disabledRules) || !Intrinsics.areEqual((Object)it4, (Object)"standard"))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return MapsKt.toSortedMap((Map)result$iv);
    }

    private static final Pair<URL, List<RuleSetProvider>> getRuleSetProvidersByUrl(URL url, boolean debug) {
        if (url != null && debug) {
            logger.debug((Function0)new Function0<Object>(url){
                final /* synthetic */ URL $url;
                {
                    this.$url = $url;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "JAR ruleset provided with path \"" + this.$url.getPath() + '\"';
                }
            });
        }
        Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object)url);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        Intrinsics.checkNotNull((Object)uRLArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        ServiceLoader<RuleSetProvider> serviceLoader = ServiceLoader.load(RuleSetProvider.class, new URLClassLoader(uRLArray));
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(\n        RuleSetPro\u2026rl).toTypedArray())\n    )");
        List ruleSetProviders = CollectionsKt.toList((Iterable)serviceLoader);
        return TuplesKt.to((Object)url, (Object)CollectionsKt.toList((Iterable)ruleSetProviders));
    }

    private static final void reportWhenMissingCustomRuleSetProvider(URL url, List<? extends RuleSetProvider> ruleSetProviders) {
        RuleSetProvider it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = ruleSetProviders;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (RuleSetProvider)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.get().getId(), (Object)"standard")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (RuleSetProvider)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.get().getId(), (Object)"experimental")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        boolean hasCustomRuleSetProviders = CollectionsKt.any((Iterable)((List)destination$iv$iv));
        if (!hasCustomRuleSetProviders) {
            logger.warn((Function0)new Function0<Object>(url){
                final /* synthetic */ URL $url;
                {
                    this.$url = $url;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return StringsKt.trimIndent((String)("\n            JAR " + this.$url.getPath() + ", provided as command line argument, does not contain a custom ruleset provider.\n                Check following:\n                  - Does the jar contain an implementation of the RuleSetProvider interface?\n                  - Does the jar contain a resource file with name \"com.pinterest.ktlint.core.RuleSetProvider\"?\n                  - Is the resource file located in directory \"src/main/resources/META-INF/services\"?\n                  - Does the resource file contain the fully qualified class name of the class implementing the RuleSetProvider interface?\n            "));
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isStandardRuleSetDisabled(String $this$isStandardRuleSetDisabled) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$isStandardRuleSetDisabled, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).contains("standard");
    }
}

