/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.core.ParseException;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.api.EditorConfigOverride;
import com.pinterest.ktlint.internal.FileUtilsKt;
import com.pinterest.ktlint.internal.KtlintCommandLine;
import com.pinterest.ktlint.internal.KtlintVersionProvider;
import com.pinterest.ktlint.internal.PrintASTSubCommand;
import com.pinterest.ktlint.internal.PrintASTSubCommandKt;
import com.pinterest.ktlint.internal.PrintCommandLineHelpOrVersionUsageKt;
import com.pinterest.ruleset.test.DumpASTRule;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(aliases={"--print-ast"}, versionProvider=KtlintVersionProvider.class, mixinStandardHelpOptions=true, description={"Print AST (useful when writing/debugging rules)", "Usage of \"--print-ast\" command line option is deprecated!"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/pinterest/ktlint/internal/PrintASTSubCommand;", "Ljava/lang/Runnable;", "()V", "astRuleSet", "", "Lcom/pinterest/ktlint/core/RuleSet;", "getAstRuleSet", "()Ljava/util/List;", "astRuleSet$delegate", "Lkotlin/Lazy;", "commandSpec", "Lpicocli/CommandLine$Model$CommandSpec;", "ktlintCommand", "Lcom/pinterest/ktlint/internal/KtlintCommandLine;", "patterns", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "stdin", "", "printAST", "", "fileName", "fileContent", "run", "Companion", "ktlint"})
public final class PrintASTSubCommand
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.ParentCommand
    private KtlintCommandLine ktlintCommand;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec commandSpec;
    @CommandLine.Parameters(description={"include all files under this .gitignore-like patterns"})
    @NotNull
    private ArrayList<String> patterns = new ArrayList();
    @CommandLine.Option(names={"--stdin"}, description={"Read file content from stdin"})
    private boolean stdin;
    @NotNull
    private final Lazy astRuleSet$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends RuleSet>>(this){
        final /* synthetic */ PrintASTSubCommand this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final List<RuleSet> invoke() {
            Rule[] ruleArray = new Rule[1];
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
            KtlintCommandLine ktlintCommandLine = PrintASTSubCommand.access$getKtlintCommand$p(this.this$0);
            if (ktlintCommandLine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
                ktlintCommandLine = null;
            }
            ruleArray[0] = (Rule)new DumpASTRule(printStream, ktlintCommandLine.getColor());
            return CollectionsKt.listOf((Object)new RuleSet("debug", ruleArray));
        }
    }));
    @NotNull
    public static final String COMMAND_NAME = "printAST";

    private final List<RuleSet> getAstRuleSet() {
        Lazy lazy = this.astRuleSet$delegate;
        return (List)lazy.getValue();
    }

    @Override
    public void run() {
        CommandLine.Model.CommandSpec commandSpec = this.commandSpec;
        if (commandSpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandSpec");
            commandSpec = null;
        }
        CommandLine commandLine = commandSpec.commandLine();
        Intrinsics.checkNotNullExpressionValue((Object)commandLine, (String)"commandSpec.commandLine()");
        PrintCommandLineHelpOrVersionUsageKt.printCommandLineHelpOrVersionUsage$default(commandLine, 0, 1, null);
        if (this.stdin) {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"`in`");
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
            this.printAST("<stdin>", new String(byArray, Charsets.UTF_8));
        } else {
            FileSystem fileSystem = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault()");
            Sequence $this$forEach$iv = SequencesKt.map((Sequence)FileUtilsKt.fileSequence$default(fileSystem, this.patterns, null, 2, null), (Function1)run.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.printAST(string, FilesKt.readText$default((File)it, null, (int)1, null));
            }
        }
    }

    private final void printAST(String fileName, String fileContent) {
        PrintASTSubCommandKt.access$getLogger$p().debug((Function0)new Function0<Object>(fileName, this){
            final /* synthetic */ String $fileName;
            final /* synthetic */ PrintASTSubCommand this$0;
            {
                this.$fileName = $fileName;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append("Analyzing ");
                if (!Intrinsics.areEqual((Object)this.$fileName, (Object)"<stdin>")) {
                    File file = new File(this.$fileName);
                    KtlintCommandLine ktlintCommandLine = PrintASTSubCommand.access$getKtlintCommand$p(this.this$0);
                    if (ktlintCommandLine == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
                        ktlintCommandLine = null;
                    }
                    string = FileUtilsKt.location(file, ktlintCommandLine.getRelative());
                } else {
                    string = "stdin";
                }
                return stringBuilder.append(string).toString();
            }
        });
        try {
            Iterable iterable = this.getAstRuleSet();
            EditorConfigOverride editorConfigOverride = EditorConfigOverride.Companion.getEmptyEditorConfigOverride();
            KtlintCommandLine ktlintCommandLine = this.ktlintCommand;
            if (ktlintCommandLine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
                ktlintCommandLine = null;
            }
            FileUtilsKt.lintFile$default(fileName, fileContent, iterable, editorConfigOverride, null, ktlintCommandLine.getDebug(), null, 80, null);
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                String string;
                int n = ((ParseException)e).getLine();
                int n2 = ((ParseException)e).getCol();
                StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
                String string2 = e.getMessage();
                if (string2 != null) {
                    String string3 = string2;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                    String string4 = string3.toLowerCase(locale);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
                } else {
                    string = null;
                }
                throw new ParseException(n, n2, stringBuilder.append(string).append(')').toString());
            }
            throw e;
        }
    }

    public static final /* synthetic */ KtlintCommandLine access$getKtlintCommand$p(PrintASTSubCommand $this) {
        return $this.ktlintCommand;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pinterest/ktlint/internal/PrintASTSubCommand$Companion;", "", "()V", "COMMAND_NAME", "", "ktlint"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

