/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.core.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.internal.FileUtilsKt;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0004\u0018\u00010\u0002H\u0002\u001a\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u0019H\u0002\u001a\f\u0010\u001c\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a*\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u001c\u0010\u001f\u001a\n \r*\u0004\u0018\u00010\u00020\u0002*\u00020 2\u0006\u0010!\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\"\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u0002H\u0002\u001a\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u00162\u0006\u0010$\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\u00020\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"DEFAULT_KOTLIN_FILE_EXTENSIONS", "", "", "DEFAULT_PATTERNS", "", "getDEFAULT_PATTERNS", "()Ljava/util/List;", "LOGGER", "Lmu/KLogger;", "NEGATION_PREFIX", "TILDE_REGEX", "Lkotlin/text/Regex;", "USER_HOME", "kotlin.jvm.PlatformType", "WORK_DIR", "getWORK_DIR", "()Ljava/lang/String;", "onWindowsOS", "", "getOnWindowsOS", "()Z", "expand", "Ljava/nio/file/FileSystem;", "patterns", "rootDir", "Ljava/nio/file/Path;", "expandDoubleStarPatterns", "expandPathToDefaultPatterns", "expandTildeToFullPath", "fileSequence", "Lkotlin/sequences/Sequence;", "location", "Ljava/io/File;", "relative", "normalizeWindowsPattern", "toGlob", "path", "ktlint"})
public final class FileUtilsKt {
    @NotNull
    private static final KLogger LOGGER;
    @NotNull
    private static final String WORK_DIR;
    @NotNull
    private static final Regex TILDE_REGEX;
    @NotNull
    private static final String NEGATION_PREFIX = "!";
    private static final String USER_HOME;
    @NotNull
    private static final Set<String> DEFAULT_KOTLIN_FILE_EXTENSIONS;
    @NotNull
    private static final List<String> DEFAULT_PATTERNS;

    @NotNull
    public static final String getWORK_DIR() {
        return WORK_DIR;
    }

    @NotNull
    public static final List<String> getDEFAULT_PATTERNS() {
        return DEFAULT_PATTERNS;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<Path> fileSequence(@NotNull FileSystem $this$fileSequence, @NotNull List<String> patterns, @NotNull Path rootDir) {
        Collection collection;
        Collection pathMatchers;
        Collection collection2;
        String it;
        void $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Collection collection3;
        Object it2;
        Intrinsics.checkNotNullParameter((Object)$this$fileSequence, (String)"<this>");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        List result = new ArrayList();
        Iterable $this$partition$iv = patterns;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            boolean bl;
            it2 = (String)element$iv;
            boolean bl2 = false;
            try {
                bl = Files.isRegularFile(rootDir.resolve((String)it2), new LinkOption[0]);
            }
            catch (InvalidPathException e) {
                bl = false;
            }
            if (bl) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List existingFiles = (List)pair.component1();
        List patternsExclusiveExistingFiles = (List)pair.component2();
        Iterable $this$mapTo$iv = existingFiles;
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            it2 = (String)item$iv;
            collection3 = result;
            boolean bl = false;
            collection3.add(rootDir.resolve((String)it2));
        }
        if (!((Collection)result).isEmpty() && patternsExclusiveExistingFiles.isEmpty()) {
            return CollectionsKt.asSequence((Iterable)result);
        }
        List<String> globs = FileUtilsKt.expand($this$fileSequence, patternsExclusiveExistingFiles, rootDir);
        if (globs.isEmpty()) {
            Iterable iterable = DEFAULT_PATTERNS;
            $i$f$map = false;
            it2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add($this$fileSequence.getPathMatcher("glob:" + it));
            }
            collection2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            Iterable $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            $this$map$iv = globs;
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)NEGATION_PREFIX, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add($this$fileSequence.getPathMatcher(it));
            }
            collection2 = pathMatchers = (Collection)((List)destination$iv$iv);
        }
        if (globs.isEmpty()) {
            collection = SetsKt.emptySet();
        } else {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable $i$f$map2 = globs;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it3 = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it3, (String)NEGATION_PREFIX, (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map3 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                String it3 = (String)item$iv$iv;
                collection3 = destination$iv$iv2;
                boolean bl = false;
                collection3.add($this$fileSequence.getPathMatcher(StringsKt.removePrefix((String)it3, (CharSequence)NEGATION_PREFIX)));
            }
            collection = (List)destination$iv$iv2;
        }
        Collection negatedPathMatchers = collection;
        LOGGER.debug((Function0)new Function0<Object>(rootDir, (Collection<? extends PathMatcher>)pathMatchers, (Collection<? extends PathMatcher>)negatedPathMatchers){
            final /* synthetic */ Path $rootDir;
            final /* synthetic */ Collection<PathMatcher> $pathMatchers;
            final /* synthetic */ Collection<PathMatcher> $negatedPathMatchers;
            {
                this.$rootDir = $rootDir;
                this.$pathMatchers = $pathMatchers;
                this.$negatedPathMatchers = $negatedPathMatchers;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                PathMatcher it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = this.$pathMatchers;
                StringBuilder stringBuilder = new StringBuilder().append("\n        Start walkFileTree for rootDir: '").append(this.$rootDir).append("'\n           include:\n        ");
                boolean $i$f$map = false;
                void var3_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    PathMatcher pathMatcher = (PathMatcher)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add("      - " + it);
                }
                $this$map$iv = this.$negatedPathMatchers;
                stringBuilder = stringBuilder.append((List)destination$iv$iv).append("\n           exclude:\n        ");
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (PathMatcher)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add("      - " + it);
                }
                return StringsKt.trimIndent((String)stringBuilder.append((List)destination$iv$iv).append("\n        ").toString());
            }
        });
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((Collection<? extends PathMatcher>)negatedPathMatchers, (Collection<? extends PathMatcher>)pathMatchers, (List<Path>)result){
            final /* synthetic */ Collection<PathMatcher> $negatedPathMatchers;
            final /* synthetic */ Collection<PathMatcher> $pathMatchers;
            final /* synthetic */ List<Path> $result;
            {
                this.$negatedPathMatchers = $negatedPathMatchers;
                this.$pathMatchers = $pathMatchers;
                this.$result = $result;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public FileVisitResult visitFile(@NotNull Path filePath, @NotNull BasicFileAttributes fileAttrs) {
                PathMatcher it;
                boolean bl;
                Path path2;
                block11: {
                    Path path3;
                    Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                    Intrinsics.checkNotNullParameter((Object)fileAttrs, (String)"fileAttrs");
                    if (FileUtilsKt.access$getOnWindowsOS()) {
                        Path path4;
                        Path it2 = path4 = Paths.get(StringsKt.replace$default((String)((Object)filePath.toAbsolutePath()).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), new String[0]);
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it2, (Object)filePath)) {
                            FileUtilsKt.access$getLOGGER$p().trace((Function0)new Function0<Object>(filePath, it2){
                                final /* synthetic */ Path $filePath;
                                final /* synthetic */ Path $it;
                                {
                                    this.$filePath = $filePath;
                                    this.$it = $it;
                                    super(0);
                                }

                                @Nullable
                                public final Object invoke() {
                                    return "On WindowsOS transform '" + this.$filePath + "' to '" + this.$it + '\'';
                                }
                            });
                        }
                        path3 = path4;
                    } else {
                        path3 = filePath;
                    }
                    path2 = path3;
                    Iterable $this$none$iv = this.$negatedPathMatchers;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (PathMatcher)element$iv;
                            boolean bl3 = false;
                            if (!it.matches(path2)) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    boolean bl4;
                    block12: {
                        Iterable $this$any$iv = this.$pathMatchers;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (PathMatcher)element$iv;
                                boolean bl5 = false;
                                if (!it.matches(path2)) continue;
                                bl4 = true;
                                break block12;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        FileUtilsKt.access$getLOGGER$p().trace((Function0)new Function0<Object>(path2){
                            final /* synthetic */ Path $path;
                            {
                                this.$path = $path;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "- File: " + this.$path + ": Include";
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                        this.$result.add(path2);
                        return FileVisitResult.CONTINUE;
                    }
                }
                FileUtilsKt.access$getLOGGER$p().trace((Function0)new Function0<Object>(path2){
                    final /* synthetic */ Path $path;
                    {
                        this.$path = $path;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "- File: " + this.$path + ": Ignore";
                    }
                });
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dirPath, @NotNull BasicFileAttributes dirAttr) {
                FileVisitResult fileVisitResult;
                Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
                Intrinsics.checkNotNullParameter((Object)dirAttr, (String)"dirAttr");
                if (Files.isHidden(dirPath)) {
                    FileUtilsKt.access$getLOGGER$p().trace((Function0)new Function0<Object>(dirPath){
                        final /* synthetic */ Path $dirPath;
                        {
                            this.$dirPath = $dirPath;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "- Dir: " + this.$dirPath + ": Ignore";
                        }
                    });
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                } else {
                    FileUtilsKt.access$getLOGGER$p().trace((Function0)new Function0<Object>(dirPath){
                        final /* synthetic */ Path $dirPath;
                        {
                            this.$dirPath = $dirPath;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "- Dir: " + this.$dirPath + ": Traverse";
                        }
                    });
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }
        });
        long duration2 = System.currentTimeMillis() - start$iv;
        LOGGER.debug((Function0)new Function0<Object>((List<Path>)result, duration2){
            final /* synthetic */ List<Path> $result;
            final /* synthetic */ long $duration;
            {
                this.$result = $result;
                this.$duration = $duration;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Discovered " + ((Collection)this.$result).size() + " files to be processed in " + this.$duration + " ms";
            }
        });
        return CollectionsKt.asSequence((Iterable)result);
    }

    public static /* synthetic */ Sequence fileSequence$default(FileSystem fileSystem, List list, Path path2, int n, Object object) {
        if ((n & 2) != 0) {
            Path path3 = Paths.get(".", new String[0]).toAbsolutePath().normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(\".\").toAbsolutePath().normalize()");
            path2 = path3;
        }
        return FileUtilsKt.fileSequence(fileSystem, list, path2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> expand(FileSystem $this$expand, List<String> patterns, Path rootDir) {
        void $this$flatMapTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = patterns;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if ((FileUtilsKt.getOnWindowsOS() ? FileUtilsKt.normalizeWindowsPattern(it2) : it2) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileUtilsKt.expandTildeToFullPath(it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (FileUtilsKt.getOnWindowsOS()) {
                String string2;
                String string3 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"separator");
                String transformedPath = string2 = StringsKt.replace$default((String)it, (String)string3, (String)"/", (boolean)false, (int)4, null);
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)transformedPath)) {
                    LOGGER.trace((Function0)new Function0<Object>(it, transformedPath){
                        final /* synthetic */ String $it;
                        final /* synthetic */ String $transformedPath;
                        {
                            this.$it = $it;
                            this.$transformedPath = $transformedPath;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "On WindowsOS transform '" + this.$it + "' to '" + this.$transformedPath + '\'';
                        }
                    });
                }
                string = string2;
            } else {
                string = it;
            }
            collection.add(string);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String path2 = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = FileUtilsKt.toGlob($this$expand, path2, rootDir);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> toGlob(FileSystem $this$toGlob, String path2, Path rootDir) {
        String originalPattern;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection<String> it;
        Iterable<Path> resolvedPath;
        String negation = StringsKt.startsWith$default((String)path2, (String)NEGATION_PREFIX, (boolean)false, (int)2, null) ? NEGATION_PREFIX : "";
        String pathWithoutNegationPrefix = StringsKt.removePrefix((String)path2, (CharSequence)NEGATION_PREFIX);
        try {
            Collection collection2;
            Collection<String> collection3;
            resolvedPath = rootDir.resolve(pathWithoutNegationPrefix).normalize();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedPath, (String)"resolvedPath");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory((Path)resolvedPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                collection3 = FileUtilsKt.expandPathToDefaultPatterns((Path)resolvedPath);
                it = collection3;
                boolean bl = false;
                LOGGER.trace((Function0)new Function0<Object>(resolvedPath, it){
                    final /* synthetic */ Path $resolvedPath;
                    final /* synthetic */ List<String> $it;
                    {
                        this.$resolvedPath = $resolvedPath;
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Expanding resolved directory path '" + this.$resolvedPath + "' to patterns: [" + this.$it + ']';
                    }
                });
                collection2 = collection3;
            } else {
                collection3 = FileUtilsKt.expandDoubleStarPatterns(resolvedPath.toString());
                it = collection3;
                boolean bl = false;
                LOGGER.trace((Function0)new Function0<Object>(resolvedPath, it){
                    final /* synthetic */ Path $resolvedPath;
                    final /* synthetic */ Set<String> $it;
                    {
                        this.$resolvedPath = $resolvedPath;
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Expanding resolved path '" + this.$resolvedPath + "` to patterns: [" + this.$it + ']';
                    }
                });
                collection2 = collection3;
            }
            resolvedPath = collection2;
        }
        catch (InvalidPathException e) {
            Collection collection4;
            if (FileUtilsKt.getOnWindowsOS()) {
                Set<String> it2 = it = FileUtilsKt.expandDoubleStarPatterns(pathWithoutNegationPrefix);
                boolean bl = false;
                LOGGER.trace((Function0)new Function0<Object>(pathWithoutNegationPrefix, it2){
                    final /* synthetic */ String $pathWithoutNegationPrefix;
                    final /* synthetic */ Set<String> $it;
                    {
                        this.$pathWithoutNegationPrefix = $pathWithoutNegationPrefix;
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "On WindowsOS: expanding unresolved path '" + this.$pathWithoutNegationPrefix + "` to patterns: [" + this.$it + ']';
                    }
                });
                collection4 = it;
            } else {
                collection4 = CollectionsKt.emptyList();
            }
            resolvedPath = collection4;
        }
        Iterable<Path> expandedPatterns2 = resolvedPath;
        resolvedPath = expandedPatterns2;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (FileUtilsKt.getOnWindowsOS()) {
                String string3;
                String string4 = $this$toGlob.getSeparator();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this.separator");
                String transformedPattern = string3 = UtilKt.prefixIfNot((String)StringsKt.removePrefix((String)StringsKt.substringAfter$default((String)StringsKt.replace$default((String)originalPattern, (String)string4, (String)"/", (boolean)false, (int)4, null), (String)":", null, (int)2, null), (CharSequence)"/"), (String)"**/");
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)transformedPattern, (Object)originalPattern)) {
                    LOGGER.trace((Function0)new Function0<Object>(originalPattern, transformedPattern){
                        final /* synthetic */ String $originalPattern;
                        final /* synthetic */ String $transformedPattern;
                        {
                            this.$originalPattern = $originalPattern;
                            this.$transformedPattern = $transformedPattern;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "On WindowsOS, transform '" + this.$originalPattern + "' to '" + this.$transformedPattern + '\'';
                        }
                    });
                }
                string = string3;
            } else {
                string = originalPattern;
            }
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            originalPattern = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(negation + "glob:" + (String)it3);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> expandDoubleStarPatterns(String $this$expandDoubleStarPatterns) {
        void $this$filterTo$iv$iv;
        List list;
        List list2;
        Object[] objectArray = new String[]{$this$expandDoubleStarPatterns};
        Set paths = SetsKt.mutableSetOf((Object[])objectArray);
        String string = $this$expandDoubleStarPatterns;
        if (string != null) {
            String[] stringArray = new String[]{"/"};
            list2 = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List parts = list;
        Iterable $this$filter$iv = parts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it, (Object)"**")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            String doubleStarPart = (String)element$iv;
            boolean bl = false;
            String $this$expandDoubleStarPatterns_u24lambda_u2423_u24lambda_u2422 = $this$expandDoubleStarPatterns;
            boolean bl2 = false;
            Iterable bl3 = parts;
            boolean $i$f$filter2 = false;
            void var13_17 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                if (!(it != doubleStarPart)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            String expandedPath = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            paths.addAll((Collection)FileUtilsKt.expandDoubleStarPatterns(expandedPath));
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)paths));
    }

    /*
     * WARNING - void declaration
     */
    private static final String normalizeWindowsPattern(String $this$normalizeWindowsPattern) {
        String string;
        if (FileUtilsKt.getOnWindowsOS()) {
            String[] stringArray;
            List list;
            String string2;
            Deque parts = new LinkedList();
            if ($this$normalizeWindowsPattern != null && (string2 = StringsKt.replace$default((String)$this$normalizeWindowsPattern, (String)"\\", (String)"/", (boolean)false, (int)4, null)) != null && (list = StringsKt.split$default((CharSequence)string2, (String[])(stringArray = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$forEach$iv;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                Iterable iterable = list;
                boolean $i$f$filterNot = false;
                Iterator iterator = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)".")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)"..")) {
                        if (parts.isEmpty()) {
                            LOGGER.warn((Function0)new Function0<Object>($this$normalizeWindowsPattern){
                                final /* synthetic */ String $this_normalizeWindowsPattern;
                                {
                                    this.$this_normalizeWindowsPattern = $receiver;
                                    super(0);
                                }

                                @Nullable
                                public final Object invoke() {
                                    return "On WindowsOS the pattern '" + this.$this_normalizeWindowsPattern + "' can not be used as it refers to a path outside of the current directory";
                                }
                            });
                            return null;
                        }
                        Object e = parts.peekLast();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"parts.peekLast()");
                        if (StringsKt.contains$default((CharSequence)((CharSequence)e), (char)'*', (boolean)false, (int)2, null)) {
                            LOGGER.warn((Function0)new Function0<Object>($this$normalizeWindowsPattern, (Deque<String>)parts){
                                final /* synthetic */ String $this_normalizeWindowsPattern;
                                final /* synthetic */ Deque<String> $parts;
                                {
                                    this.$this_normalizeWindowsPattern = $receiver;
                                    this.$parts = $parts;
                                    super(0);
                                }

                                @Nullable
                                public final Object invoke() {
                                    return "On WindowsOS the pattern '" + this.$this_normalizeWindowsPattern + "' can not be used as '/..' follows the wildcard pattern " + this.$parts.peekLast();
                                }
                            });
                            return null;
                        }
                        parts.removeLast();
                        continue;
                    }
                    parts.addLast(it);
                }
            }
            string = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = $this$normalizeWindowsPattern;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> expandPathToDefaultPatterns(Path $this$expandPathToDefaultPatterns) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = DEFAULT_KOTLIN_FILE_EXTENSIONS;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{$this$expandPathToDefaultPatterns + "/*." + it, $this$expandPathToDefaultPatterns + "/**/*." + it};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String expandTildeToFullPath(@NotNull String $this$expandTildeToFullPath) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$expandTildeToFullPath, (String)"<this>");
        if (FileUtilsKt.getOnWindowsOS()) {
            charSequence = $this$expandTildeToFullPath;
        } else {
            CharSequence charSequence2 = $this$expandTildeToFullPath;
            Regex regex = TILDE_REGEX;
            String string = USER_HOME;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"USER_HOME");
            String string2 = string;
            CharSequence it = charSequence2 = regex.replaceFirst(charSequence2, string2);
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)$this$expandTildeToFullPath)) {
                LOGGER.trace((Function0)new Function0<Object>($this$expandTildeToFullPath, (String)it){
                    final /* synthetic */ String $this_expandTildeToFullPath;
                    final /* synthetic */ String $it;
                    {
                        this.$this_expandTildeToFullPath = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "On non-WindowsOS expand '" + this.$this_expandTildeToFullPath + "' to '" + this.$it + '\'';
                    }
                });
            }
            charSequence = charSequence2;
        }
        return charSequence;
    }

    private static final boolean getOnWindowsOS() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        return StringsKt.startsWith((String)string, (String)"windows", (boolean)true);
    }

    public static final String location(@NotNull File $this$location, boolean relative) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$location, (String)"<this>");
        if (relative) {
            Path path2 = $this$location.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.toPath()");
            Path path3 = Paths.get(WORK_DIR, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(path)");
            string = ((Object)PathsKt.relativeToOrSelf((Path)path2, (Path)path3)).toString();
        } else {
            string = $this$location.getPath();
        }
        return string;
    }

    public static final /* synthetic */ boolean access$getOnWindowsOS() {
        return FileUtilsKt.getOnWindowsOS();
    }

    public static final /* synthetic */ KLogger access$getLOGGER$p() {
        return LOGGER;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        LOGGER = KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KotlinLogging.INSTANCE.logger((Function0)LOGGER.1.INSTANCE));
        String string = new File(".").getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(\".\").canonicalPath");
        WORK_DIR = string;
        TILDE_REGEX = new Regex("^(!)?~");
        USER_HOME = System.getProperty("user.home");
        Object[] objectArray = new String[]{"kt", "kts"};
        DEFAULT_KOTLIN_FILE_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
        Iterable $this$map$iv = DEFAULT_KOTLIN_FILE_EXTENSIONS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("**/*." + (String)it);
        }
        DEFAULT_PATTERNS = (List)var3_3;
    }
}

