/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.core.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.core.RuleProvider;
import com.pinterest.ktlint.core.RuleSetProviderV2;
import com.pinterest.ktlint.internal.LoadRuleProvidersKt;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a,\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"KTLINT_RULE_SETS", "", "", "LOGGER", "Lmu/KLogger;", "getRuleProvidersFromJar", "", "", "Lcom/pinterest/ktlint/core/RuleProvider;", "url", "Ljava/net/URL;", "debug", "", "loadRuleProviders", "ktlint"})
public final class LoadRuleProvidersKt {
    @NotNull
    private static final KLogger LOGGER = KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KotlinLogging.INSTANCE.logger((Function0)LOGGER.1.INSTANCE));
    @NotNull
    private static final List<String> KTLINT_RULE_SETS;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<RuleProvider> loadRuleProviders(@NotNull List<URL> $this$loadRuleProviders, boolean debug) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$loadRuleProviders, (String)"<this>");
        Iterable $this$flatMap$iv = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)$this$loadRuleProviders, null));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            URL it = (URL)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = LoadRuleProvidersKt.getRuleProvidersFromJar(it, debug).values();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Set<RuleProvider>> getRuleProvidersFromJar(URL url, boolean debug) {
        Map map;
        if (url != null && debug) {
            LOGGER.debug((Function0)new Function0<Object>(url){
                final /* synthetic */ URL $url;
                {
                    this.$url = $url;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "JAR ruleset provided with path \"" + this.$url.getPath() + '\"';
                }
            });
        }
        try {
            void $this$associateTo$iv$iv;
            void $this$filterTo$iv$iv;
            Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object)url);
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ServiceLoader<RuleSetProviderV2> serviceLoader = ServiceLoader.load(RuleSetProviderV2.class, new URLClassLoader(thisCollection$iv.toArray(new URL[0])));
            Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(\n                Ru\u2026edArray()),\n            )");
            Iterable $this$filter$iv = serviceLoader;
            boolean $i$f$filter = false;
            Iterable $i$f$toTypedArray22 = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RuleSetProviderV2 it = (RuleSetProviderV2)element$iv$iv;
                boolean bl = false;
                if (!(url == null || !KTLINT_RULE_SETS.contains(it.getId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                RuleSetProviderV2 ruleSetProviderV2 = (RuleSetProviderV2)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)ruleSetProviderV2.getId(), (Object)ruleSetProviderV2.getRuleProviders());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map ruleSetIdMap = map = destination$iv$iv2;
            boolean bl = false;
            if (url != null && ruleSetIdMap.isEmpty()) {
                LOGGER.warn((Function0)new Function0<Object>(url){
                    final /* synthetic */ URL $url;
                    {
                        this.$url = $url;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return StringsKt.trimIndent((String)("\n                        JAR " + this.$url.getPath() + ", provided as command line argument, does not contain a custom ruleset provider.\n                            Check following:\n                              - Does the jar contain an implementation of the RuleSetProviderV2 interface?\n                              - Does the jar contain a resource file with name \"com.pinterest.ktlint.core.RuleSetProviderV2\"?\n                              - Is the resource file located in directory \"src/main/resources/META-INF/services\"?\n                              - Does the resource file contain the fully qualified class name of the class implementing the RuleSetProviderV2 interface?\n                        "));
                    }
                });
            }
        }
        catch (ServiceConfigurationError e) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    static {
        Object[] objectArray = new String[]{"standard", "experimental"};
        KTLINT_RULE_SETS = CollectionsKt.listOf((Object[])objectArray);
    }
}

