/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.core.KtLintRuleEngine;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.RuleProvider;
import com.pinterest.ktlint.core.api.KtLintParseException;
import com.pinterest.ktlint.internal.FileUtilsKt;
import com.pinterest.ktlint.internal.KtlintCommandLine;
import com.pinterest.ktlint.internal.KtlintVersionProvider;
import com.pinterest.ktlint.internal.PrintASTSubCommand;
import com.pinterest.ktlint.internal.PrintASTSubCommandKt;
import com.pinterest.ktlint.internal.PrintCommandLineHelpOrVersionUsageKt;
import com.pinterest.ruleset.test.DumpASTRule;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(aliases={"--print-ast"}, versionProvider=KtlintVersionProvider.class, mixinStandardHelpOptions=true, description={"Print AST (useful when writing/debugging rules)", "Usage of \"--print-ast\" command line option is deprecated!"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pinterest/ktlint/internal/PrintASTSubCommand;", "Ljava/lang/Runnable;", "()V", "commandSpec", "Lpicocli/CommandLine$Model$CommandSpec;", "ktlintCommand", "Lcom/pinterest/ktlint/internal/KtlintCommandLine;", "patterns", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "stdin", "", "printAST", "", "fileContent", "fileName", "run", "Companion", "ktlint"})
public final class PrintASTSubCommand
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.ParentCommand
    private KtlintCommandLine ktlintCommand;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec commandSpec;
    @CommandLine.Parameters(description={"include all files under this .gitignore-like patterns"})
    @NotNull
    private ArrayList<String> patterns = new ArrayList();
    @CommandLine.Option(names={"--stdin"}, description={"Read file content from stdin"})
    private boolean stdin;
    @NotNull
    public static final String COMMAND_NAME = "printAST";

    @Override
    public void run() {
        CommandLine.Model.CommandSpec commandSpec = this.commandSpec;
        if (commandSpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandSpec");
            commandSpec = null;
        }
        CommandLine commandLine = commandSpec.commandLine();
        Intrinsics.checkNotNullExpressionValue((Object)commandLine, (String)"commandSpec.commandLine()");
        PrintCommandLineHelpOrVersionUsageKt.printCommandLineHelpOrVersionUsage$default(commandLine, 0, 1, null);
        if (this.stdin) {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"`in`");
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
            PrintASTSubCommand.printAST$default(this, new String(byArray, Charsets.UTF_8), null, 2, null);
        } else {
            FileSystem fileSystem = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault()");
            Sequence $this$forEach$iv = SequencesKt.map((Sequence)FileUtilsKt.fileSequence$default(fileSystem, this.patterns, null, 2, null), (Function1)run.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String string2 = FilesKt.readText$default((File)it, null, (int)1, null);
                this.printAST(string2, string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void printAST(String fileContent, String fileName) {
        if (fileName != null) {
            PrintASTSubCommandKt.access$getLOGGER$p().debug((Function0)new Function0<Object>(fileName, this){
                final /* synthetic */ String $fileName;
                final /* synthetic */ PrintASTSubCommand this$0;
                {
                    this.$fileName = $fileName;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Analyzing ");
                    File file = new File(this.$fileName);
                    KtlintCommandLine ktlintCommandLine = PrintASTSubCommand.access$getKtlintCommand$p(this.this$0);
                    if (ktlintCommandLine == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
                        ktlintCommandLine = null;
                    }
                    return stringBuilder.append(FileUtilsKt.location(file, ktlintCommandLine.getRelative())).toString();
                }
            });
        }
        try {
            Path path2;
            KtLintRuleEngine ktLintRuleEngine = new KtLintRuleEngine(SetsKt.setOf((Object)new RuleProvider((Function0)new Function0<Rule>(this){
                final /* synthetic */ PrintASTSubCommand this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Rule invoke() {
                    PrintStream printStream = System.out;
                    Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
                    KtlintCommandLine ktlintCommandLine = PrintASTSubCommand.access$getKtlintCommand$p(this.this$0);
                    if (ktlintCommandLine == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
                        ktlintCommandLine = null;
                    }
                    return (Rule)new DumpASTRule(printStream, ktlintCommandLine.getColor());
                }
            })), null, null, false, 14, null);
            String string = fileContent;
            String string2 = fileName;
            if (string2 != null) {
                void it;
                String string3 = string2;
                String string4 = string;
                KtLintRuleEngine ktLintRuleEngine2 = ktLintRuleEngine;
                boolean bl = false;
                Path path3 = Paths.get((String)it, new String[0]);
                ktLintRuleEngine = ktLintRuleEngine2;
                string = string4;
                path2 = path3;
            } else {
                path2 = null;
            }
            KtLintRuleEngine.lint$default((KtLintRuleEngine)ktLintRuleEngine, (String)string, path2, null, (int)4, null);
        }
        catch (Exception e) {
            if (e instanceof KtLintParseException) {
                String string;
                int n = ((KtLintParseException)e).getLine();
                int n2 = ((KtLintParseException)e).getCol();
                StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
                String string5 = e.getMessage();
                if (string5 != null) {
                    String string6 = string5;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                    String string7 = string6.toLowerCase(locale);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase(locale)");
                } else {
                    string = null;
                }
                throw new KtLintParseException(n, n2, stringBuilder.append(string).append(')').toString());
            }
            throw e;
        }
    }

    static /* synthetic */ void printAST$default(PrintASTSubCommand printASTSubCommand, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        printASTSubCommand.printAST(string, string2);
    }

    public static final /* synthetic */ KtlintCommandLine access$getKtlintCommand$p(PrintASTSubCommand $this) {
        return $this.ktlintCommand;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pinterest/ktlint/internal/PrintASTSubCommand$Companion;", "", "()V", "COMMAND_NAME", "", "ktlint"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

