/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.internal;

import com.pinterest.ktlint.core.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.core.RuleProvider;
import com.pinterest.ktlint.core.RuleSetProviderV2;
import com.pinterest.ktlint.internal.LoadRuleProvidersKt;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u001a\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006H\u0002\u001a*\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a&\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a,\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006*\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\f\u001a\u00020\rH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"KTLINT_RULE_SETS", "", "", "LOGGER", "Lmu/KLogger;", "getKtlintRulesets", "", "", "Lcom/pinterest/ktlint/core/RuleProvider;", "getRuleProvidersFromCustomRuleSetJar", "url", "Ljava/net/URL;", "debug", "", "loadRulesetsFrom", "getRuleProvidersFromCustomRuleSetJars", "loadRuleProviders", "ktlint"})
@SourceDebugExtension(value={"SMAP\nLoadRuleProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadRuleProviders.kt\ncom/pinterest/ktlint/internal/LoadRuleProvidersKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,76:1\n37#2,2:77\n1179#3,2:79\n1253#3,4:81\n1360#3:85\n1446#3,5:86\n1179#3,2:91\n1253#3,4:93\n467#4,7:97\n*S KotlinDebug\n*F\n+ 1 LoadRuleProviders.kt\ncom/pinterest/ktlint/internal/LoadRuleProvidersKt\n*L\n34#1:77,2\n35#1:79,2\n35#1:81,4\n45#1:85\n45#1:86,5\n46#1:91,2\n46#1:93,4\n56#1:97,7\n*E\n"})
public final class LoadRuleProvidersKt {
    @NotNull
    private static final KLogger LOGGER = KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KotlinLogging.INSTANCE.logger((Function0)LOGGER.1.INSTANCE));
    @NotNull
    private static final List<String> KTLINT_RULE_SETS;

    @NotNull
    public static final Set<RuleProvider> loadRuleProviders(@NotNull List<URL> $this$loadRuleProviders, boolean debug) {
        Intrinsics.checkNotNullParameter($this$loadRuleProviders, (String)"<this>");
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)MapsKt.plus(LoadRuleProvidersKt.getKtlintRulesets(), LoadRuleProvidersKt.getRuleProvidersFromCustomRuleSetJars($this$loadRuleProviders, debug)).values()));
    }

    private static final Map<String, Set<RuleProvider>> getKtlintRulesets() {
        return LoadRuleProvidersKt.loadRulesetsFrom$default(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Set<RuleProvider>> loadRulesetsFrom(URL url) {
        Map map;
        try {
            void $this$associateTo$iv$iv;
            Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object)url);
            boolean $i$f$toTypedArray = false;
            Iterable thisCollection$iv = $this$toTypedArray$iv;
            ServiceLoader<RuleSetProviderV2> serviceLoader = ServiceLoader.load(RuleSetProviderV2.class, new URLClassLoader(thisCollection$iv.toArray(new URL[0])));
            Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(\n                Ru\u2026edArray()),\n            )");
            Iterable $this$associate$iv = serviceLoader;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            thisCollection$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                RuleSetProviderV2 ruleSetProviderV2 = (RuleSetProviderV2)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)ruleSetProviderV2.getId(), (Object)ruleSetProviderV2.getRuleProviders());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        }
        catch (ServiceConfigurationError e) {
            LOGGER.warn((Function0)new Function0<Object>(url, e){
                final /* synthetic */ URL $url;
                final /* synthetic */ ServiceConfigurationError $e;
                {
                    this.$url = $url;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Error while loading rule set JAR '").append(this.$url).append("':\n");
                    this.$e.printStackTrace();
                    return stringBuilder.append(Unit.INSTANCE).toString();
                }
            });
            map = MapsKt.emptyMap();
        }
        return map;
    }

    static /* synthetic */ Map loadRulesetsFrom$default(URL uRL, int n, Object object) {
        if ((n & 1) != 0) {
            uRL = null;
        }
        return LoadRuleProvidersKt.loadRulesetsFrom(uRL);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Set<RuleProvider>> getRuleProvidersFromCustomRuleSetJars(List<URL> $this$getRuleProvidersFromCustomRuleSetJars, boolean debug) {
        void $this$associateTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = CollectionsKt.distinct((Iterable)$this$getRuleProvidersFromCustomRuleSetJars);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            URL it = (URL)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = LoadRuleProvidersKt.getRuleProvidersFromCustomRuleSetJar(it, debug).entrySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private static final Map<String, Set<RuleProvider>> getRuleProvidersFromCustomRuleSetJar(URL url, boolean debug) {
        Map map;
        if (debug) {
            LOGGER.debug((Function0)new Function0<Object>(url){
                final /* synthetic */ URL $url;
                {
                    this.$url = $url;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "JAR ruleset provided with path \"" + this.$url.getPath() + '\"';
                }
            });
        }
        Map<String, Set<RuleProvider>> $this$filterKeys$iv = LoadRuleProvidersKt.loadRulesetsFrom(url);
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, Set<RuleProvider>> result$iv = new LinkedHashMap<String, Set<RuleProvider>>();
        for (Map.Entry<String, Set<RuleProvider>> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!(!KTLINT_RULE_SETS.contains(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map ruleSetIdMap = map = (Map)result$iv;
        boolean bl = false;
        if (ruleSetIdMap.isEmpty()) {
            LOGGER.warn((Function0)new Function0<Object>(url){
                final /* synthetic */ URL $url;
                {
                    this.$url = $url;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return StringsKt.trimIndent((String)("\n                    JAR " + this.$url.getPath() + ", provided as command line argument, does not contain a custom ruleset provider.\n                        Check following:\n                          - Does the jar contain an implementation of the RuleSetProviderV2 interface?\n                          - Does the jar contain a resource file with name \"com.pinterest.ktlint.core.RuleSetProviderV2\"?\n                          - Is the resource file located in directory \"src/main/resources/META-INF/services\"?\n                          - Does the resource file contain the fully qualified class name of the class implementing the RuleSetProviderV2 interface?\n                    "));
                }
            });
        }
        return map;
    }

    static {
        Object[] objectArray = new String[]{"standard", "experimental"};
        KTLINT_RULE_SETS = CollectionsKt.listOf((Object[])objectArray);
    }
}

