/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.api;

import com.pinterest.ktlint.cli.api.Baseline;
import com.pinterest.ktlint.cli.api.BaselineKt;
import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.rule.engine.core.api.RuleId;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0013H\u0002J\u0014\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/pinterest/ktlint/cli/api/BaselineLoader;", "", "path", "", "(Ljava/lang/String;)V", "ruleReferenceWithoutRuleSetIdPrefix", "", "getRuleReferenceWithoutRuleSetIdPrefix", "()I", "setRuleReferenceWithoutRuleSetIdPrefix", "(I)V", "load", "Lcom/pinterest/ktlint/cli/api/Baseline;", "parseBaseline", "", "", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "Ljava/io/InputStream;", "parseBaselineErrorElement", "Lorg/w3c/dom/Element;", "parseBaselineFileElement", "parseDocument", "Lorg/w3c/dom/Document;", "kotlin.jvm.PlatformType", "ktlint-cli"})
@SourceDebugExtension(value={"SMAP\nBaseline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Baseline.kt\ncom/pinterest/ktlint/cli/api/BaselineLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
final class BaselineLoader {
    @NotNull
    private final String path;
    private int ruleReferenceWithoutRuleSetIdPrefix;

    public BaselineLoader(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.path = path2;
    }

    public final int getRuleReferenceWithoutRuleSetIdPrefix() {
        return this.ruleReferenceWithoutRuleSetIdPrefix;
    }

    public final void setRuleReferenceWithoutRuleSetIdPrefix(int n) {
        this.ruleReferenceWithoutRuleSetIdPrefix = n;
    }

    @NotNull
    public final Baseline load() {
        File file;
        File file2;
        if (!(!StringsKt.isBlank((CharSequence)this.path))) {
            boolean bl = false;
            String string = "Path for loading baseline may not be blank or empty";
            throw new IllegalArgumentException(string.toString());
        }
        File it = file2 = Paths.get(this.path, new String[0]).toFile();
        boolean bl = false;
        File file3 = file = it.exists() ? file2 : null;
        if (file != null) {
            File baselineFile = file;
            boolean bl2 = false;
            try {
                Object object = this.path;
                Map<String, List<KtlintCliError>> map = this.parseBaseline(new FileInputStream(baselineFile));
                Baseline.Status status = Baseline.Status.VALID;
                Object it2 = object = new Baseline((String)object, status, map);
                boolean bl3 = false;
                if (this.ruleReferenceWithoutRuleSetIdPrefix > 0) {
                    BaselineKt.access$getLOGGER$p().warn((Function0)new Function0<Object>(this){
                        final /* synthetic */ BaselineLoader this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Baseline file '" + BaselineLoader.access$getPath$p(this.this$0) + "' contains " + this.this$0.getRuleReferenceWithoutRuleSetIdPrefix() + " reference(s) to rule ids without a rule set id. For those references the rule set id 'standard' is assumed. It is advised to regenerate this baseline file.";
                        }
                    });
                }
                return object;
            }
            catch (IOException e) {
                BaselineKt.access$getLOGGER$p().error((Function0)new Function0<Object>(this){
                    final /* synthetic */ BaselineLoader this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to parse baseline file: " + BaselineLoader.access$getPath$p(this.this$0);
                    }
                });
            }
            catch (ParserConfigurationException e) {
                BaselineKt.access$getLOGGER$p().error((Function0)new Function0<Object>(this){
                    final /* synthetic */ BaselineLoader this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to parse baseline file: " + BaselineLoader.access$getPath$p(this.this$0);
                    }
                });
            }
            catch (SAXException e) {
                BaselineKt.access$getLOGGER$p().error((Function0)new Function0<Object>(this){
                    final /* synthetic */ BaselineLoader this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to parse baseline file: " + BaselineLoader.access$getPath$p(this.this$0);
                    }
                });
            }
            try {
                baselineFile.delete();
            }
            catch (IOException e) {
                BaselineKt.access$getLOGGER$p().error((Function0)new Function0<Object>(this){
                    final /* synthetic */ BaselineLoader this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to delete baseline file: " + BaselineLoader.access$getPath$p(this.this$0);
                    }
                });
            }
            return new Baseline(this.path, Baseline.Status.INVALID, null, 4, null);
        }
        return new Baseline(this.path, Baseline.Status.NOT_FOUND, null, 4, null);
    }

    private final Map<String, List<KtlintCliError>> parseBaseline(InputStream $this$parseBaseline) {
        HashMap lintErrorsPerFile = new HashMap();
        NodeList $this$parseBaseline_u24lambda_u245 = this.parseDocument($this$parseBaseline).getElementsByTagName("file");
        boolean bl = false;
        int n = $this$parseBaseline_u24lambda_u245.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = $this$parseBaseline_u24lambda_u245.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element $this$parseBaseline_u24lambda_u245_u24lambda_u244 = (Element)node;
            boolean bl2 = false;
            Path path2 = Paths.get($this$parseBaseline_u24lambda_u245_u24lambda_u244.getAttribute("name"), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(getAttribute(\"name\"))");
            String fileName = ((Object)path2.toAbsolutePath()).toString();
            ((Map)lintErrorsPerFile).put(fileName, this.parseBaselineFileElement($this$parseBaseline_u24lambda_u245_u24lambda_u244));
        }
        return lintErrorsPerFile;
    }

    private final Document parseDocument(InputStream $this$parseDocument) {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse($this$parseDocument);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtlintCliError> parseBaselineFileElement(Element $this$parseBaselineFileElement) {
        List ktlintCliErrorsInFileElement = new ArrayList();
        NodeList $this$parseBaselineFileElement_u24lambda_u247 = $this$parseBaselineFileElement.getElementsByTagName("error");
        boolean bl = false;
        int n = $this$parseBaselineFileElement_u24lambda_u247.getLength();
        for (int i = 0; i < n; ++i) {
            void $this$parseBaselineFileElement_u24lambda_u247_u24lambda_u246;
            Node node = $this$parseBaselineFileElement_u24lambda_u247.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element element = (Element)node;
            List list = ktlintCliErrorsInFileElement;
            boolean bl2 = false;
            list.add(this.parseBaselineErrorElement((Element)$this$parseBaselineFileElement_u24lambda_u247_u24lambda_u246));
        }
        return ktlintCliErrorsInFileElement;
    }

    /*
     * WARNING - void declaration
     */
    private final KtlintCliError parseBaselineErrorElement(Element $this$parseBaselineErrorElement) {
        String string;
        void ruleId;
        String string2 = $this$parseBaselineErrorElement.getAttribute("line");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttribute(\"line\")");
        int n = Integer.parseInt(string2);
        String string3 = $this$parseBaselineErrorElement.getAttribute("column");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttribute(\"column\")");
        String string4 = $this$parseBaselineErrorElement.getAttribute("source");
        int n2 = Integer.parseInt(string3);
        int n3 = n;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)ruleId, (String)"ruleId");
        String prefixedRuleId = string = RuleId.Companion.prefixWithStandardRuleSetIdWhenMissing((String)ruleId);
        boolean bl2 = false;
        if (!Intrinsics.areEqual((Object)prefixedRuleId, (Object)ruleId)) {
            int n4 = this.ruleReferenceWithoutRuleSetIdPrefix;
            this.ruleReferenceWithoutRuleSetIdPrefix = n4 + 1;
        }
        String string5 = string;
        KtlintCliError.Status status = KtlintCliError.Status.BASELINE_IGNORED;
        String string6 = "";
        String string7 = string5;
        int n5 = n2;
        int n6 = n3;
        return new KtlintCliError(n6, n5, string7, string6, status);
    }

    public static final /* synthetic */ String access$getPath$p(BaselineLoader $this) {
        return $this.path;
    }
}

