/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.reporter.baseline;

import com.pinterest.ktlint.cli.reporter.baseline.Baseline;
import com.pinterest.ktlint.cli.reporter.baseline.BaselineKt;
import com.pinterest.ktlint.cli.reporter.baseline.BaselineLoaderException;
import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.rule.engine.core.api.RuleId;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011*\u00020\u0014H\u0002J\u0019\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016*\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u0013*\u00020\u001aH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/pinterest/ktlint/cli/reporter/baseline/BaselineLoader;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "baselinePath", "Ljava/io/File;", "ruleReferenceWithoutRuleSetIdPrefix", "", "getRuleReferenceWithoutRuleSetIdPrefix", "()I", "setRuleReferenceWithoutRuleSetIdPrefix", "(I)V", "load", "Lcom/pinterest/ktlint/cli/reporter/baseline/Baseline;", "parseBaseline", "", "", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "Ljava/io/InputStream;", "parseDocument", "Lorg/w3c/dom/Document;", "kotlin.jvm.PlatformType", "(Ljava/io/InputStream;)Lorg/w3c/dom/Document;", "parseBaselineFileElement", "Lorg/w3c/dom/Element;", "parseBaselineErrorElement", "delete", "", "ktlint-cli-reporter-baseline"})
@SourceDebugExtension(value={"SMAP\nBaseline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Baseline.kt\ncom/pinterest/ktlint/cli/reporter/baseline/BaselineLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
final class BaselineLoader {
    @NotNull
    private final String path;
    @Nullable
    private final File baselinePath;
    private int ruleReferenceWithoutRuleSetIdPrefix;

    /*
     * WARNING - void declaration
     */
    public BaselineLoader(@NotNull String path) {
        void it;
        File file;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        File file2 = file = Paths.get(this.path, new String[0]).toFile();
        BaselineLoader baselineLoader = this;
        boolean bl = false;
        boolean bl2 = it.exists();
        baselineLoader.baselinePath = bl2 ? file : null;
    }

    public final int getRuleReferenceWithoutRuleSetIdPrefix() {
        return this.ruleReferenceWithoutRuleSetIdPrefix;
    }

    public final void setRuleReferenceWithoutRuleSetIdPrefix(int n) {
        this.ruleReferenceWithoutRuleSetIdPrefix = n;
    }

    @NotNull
    public final Baseline load() {
        if (!(!StringsKt.isBlank((CharSequence)this.path))) {
            boolean bl = false;
            String string = "Path for loading baseline may not be blank or empty";
            throw new IllegalArgumentException(string.toString());
        }
        File file = this.baselinePath;
        if (file != null) {
            File baselineFile = file;
            boolean bl = false;
            try {
                Object object = this.path;
                Map<String, List<KtlintCliError>> map = this.parseBaseline(new FileInputStream(baselineFile));
                Baseline.Status status = Baseline.Status.VALID;
                Object it = object = new Baseline((String)object, status, map);
                boolean bl2 = false;
                if (this.ruleReferenceWithoutRuleSetIdPrefix > 0) {
                    BaselineKt.access$getLOGGER$p().warn(() -> BaselineLoader.load$lambda$4$lambda$3$lambda$2(this));
                }
                return object;
            }
            catch (IOException e) {
                throw new BaselineLoaderException("Unable to parse baseline file: " + this.path, e);
            }
            catch (ParserConfigurationException e) {
                throw new BaselineLoaderException("Unable to parse baseline file: " + this.path, e);
            }
            catch (SAXException e) {
                throw new BaselineLoaderException("Unable to parse baseline file: " + this.path, e);
            }
        }
        return new Baseline(this.path, Baseline.Status.NOT_FOUND, null, 4, null);
    }

    private final Map<String, List<KtlintCliError>> parseBaseline(InputStream $this$parseBaseline) {
        HashMap lintErrorsPerFile = new HashMap();
        NodeList $this$parseBaseline_u24lambda_u246 = this.parseDocument($this$parseBaseline).getElementsByTagName("file");
        boolean bl = false;
        int n = $this$parseBaseline_u24lambda_u246.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = $this$parseBaseline_u24lambda_u246.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element $this$parseBaseline_u24lambda_u246_u24lambda_u245 = (Element)node;
            boolean bl2 = false;
            String fileName = $this$parseBaseline_u24lambda_u246_u24lambda_u245.getAttribute("name");
            ((Map)lintErrorsPerFile).put(fileName, this.parseBaselineFileElement($this$parseBaseline_u24lambda_u246_u24lambda_u245));
        }
        return lintErrorsPerFile;
    }

    private final Document parseDocument(InputStream $this$parseDocument) {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse($this$parseDocument);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtlintCliError> parseBaselineFileElement(Element $this$parseBaselineFileElement) {
        List ktlintCliErrorsInFileElement = new ArrayList();
        NodeList $this$parseBaselineFileElement_u24lambda_u248 = $this$parseBaselineFileElement.getElementsByTagName("error");
        boolean bl = false;
        int n = $this$parseBaselineFileElement_u24lambda_u248.getLength();
        for (int i = 0; i < n; ++i) {
            void $this$parseBaselineFileElement_u24lambda_u248_u24lambda_u247;
            Node node = $this$parseBaselineFileElement_u24lambda_u248.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element element = (Element)node;
            List list = ktlintCliErrorsInFileElement;
            boolean bl2 = false;
            list.add(this.parseBaselineErrorElement((Element)$this$parseBaselineFileElement_u24lambda_u248_u24lambda_u247));
        }
        return ktlintCliErrorsInFileElement;
    }

    /*
     * WARNING - void declaration
     */
    private final KtlintCliError parseBaselineErrorElement(Element $this$parseBaselineErrorElement) {
        String string;
        void ruleId;
        String string2 = $this$parseBaselineErrorElement.getAttribute("line");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttribute(...)");
        int n = Integer.parseInt(string2);
        String string3 = $this$parseBaselineErrorElement.getAttribute("column");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttribute(...)");
        String string4 = $this$parseBaselineErrorElement.getAttribute("source");
        int n2 = Integer.parseInt(string3);
        int n3 = n;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)ruleId);
        String prefixedRuleId = string = RuleId.Companion.prefixWithStandardRuleSetIdWhenMissing((String)ruleId);
        boolean bl2 = false;
        if (!Intrinsics.areEqual((Object)prefixedRuleId, (Object)ruleId)) {
            int n4 = this.ruleReferenceWithoutRuleSetIdPrefix;
            this.ruleReferenceWithoutRuleSetIdPrefix = n4 + 1;
        }
        String string5 = string;
        KtlintCliError.Status status = KtlintCliError.Status.BASELINE_IGNORED;
        String string6 = "";
        String string7 = string5;
        int n5 = n2;
        int n6 = n3;
        return new KtlintCliError(n6, n5, string7, string6, status);
    }

    public final void delete() {
        try {
            File file = this.baselinePath;
            if (file != null) {
                file.delete();
            }
        }
        catch (IOException e) {
            throw new BaselineLoaderException("Unable to delete baseline file: " + this.path, e);
        }
    }

    private static final Object load$lambda$4$lambda$3$lambda$2(BaselineLoader this$0) {
        return "Baseline file '" + this$0.path + "' contains " + this$0.ruleReferenceWithoutRuleSetIdPrefix + " reference(s) to rule ids without a rule set id. For those references the rule set id 'standard' is assumed. It is advised to regenerate this baseline file.";
    }
}

