/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.reporter.baseline;

import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.Reporter;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0007H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/reporter/baseline/BaselineReporter;", "Lcom/pinterest/ktlint/core/Reporter;", "out", "Ljava/io/PrintStream;", "(Ljava/io/PrintStream;)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/pinterest/ktlint/core/LintError;", "getOut", "()Ljava/io/PrintStream;", "afterAll", "", "onLintError", "file", "err", "corrected", "", "escapeXMLAttrValue", "ktlint-reporter-baseline"})
public final class BaselineReporter
implements Reporter {
    @NotNull
    private final PrintStream out;
    @NotNull
    private final ConcurrentHashMap<String, List<LintError>> acc;

    public BaselineReporter(@NotNull PrintStream out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        this.out = out;
        this.acc = new ConcurrentHashMap();
    }

    @NotNull
    public final PrintStream getOut() {
        return this.out;
    }

    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
        if (!corrected) {
            ConcurrentMap $this$getOrPut$iv = this.acc;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(file);
            if (object == null) {
                boolean bl = false;
                List list = new ArrayList();
                boolean bl2 = false;
                boolean bl3 = false;
                List default$iv = list;
                boolean bl4 = false;
                object = $this$getOrPut$iv.putIfAbsent(file, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((List)object).add(err);
        }
    }

    public void afterAll() {
        this.out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.out.println("<baseline version=\"1.0\">");
        Object object = this.acc.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"acc.entries");
        Iterable $this$sortedBy$iv = (Iterable)object;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Iterator iterator = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = (String)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        }).iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3 = object = (Map.Entry)iterator.next();
            boolean bl2 = false;
            String file = (String)object3.getKey();
            Object object4 = object;
            boolean bl3 = false;
            List errList = (List)object4.getValue();
            try {
                Path rootPath = Paths.get("", new String[0]).toAbsolutePath();
                Path filePath = Paths.get(file, new String[0]);
                object2 = StringsKt.replace$default((String)((Object)rootPath.relativize(filePath)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            }
            catch (IllegalArgumentException e) {
                String string = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"{\n                file\n            }");
                object2 = string;
            }
            String fileName = object2;
            this.out.println("\t<file name=\"" + this.escapeXMLAttrValue(fileName) + "\">");
            for (LintError lintError : errList) {
                int line = lintError.component1();
                int col = lintError.component2();
                String ruleId = lintError.component3();
                this.out.println("\t\t<error line=\"" + line + "\" column=\"" + col + "\" source=\"" + ruleId + "\" />");
            }
            this.out.println("\t</file>");
        }
        this.out.println("</baseline>");
    }

    private final String escapeXMLAttrValue(String $this$escapeXMLAttrValue) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeXMLAttrValue, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"\"", (String)"&quot;", (boolean)false, (int)4, null), (String)"'", (String)"&apos;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    public void after(@NotNull String file) {
        Reporter.DefaultImpls.after((Reporter)this, (String)file);
    }

    public void before(@NotNull String file) {
        Reporter.DefaultImpls.before((Reporter)this, (String)file);
    }

    public void beforeAll() {
        Reporter.DefaultImpls.beforeAll((Reporter)this);
    }
}

