/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.reporter.baseline;

import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.Reporter;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=80, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\u00020\t*\u00020\tH\u0002J\u001e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR6\u0010\u0010\u001a*\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\r \u0012*\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00130\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/pinterest/ktlint/reporter/baseline/BaselineReporter;", "Lcom/pinterest/ktlint/core/Reporter;", "out", "Ljava/io/PrintStream;", "<init>", "(Ljava/io/PrintStream;)V", "afterAll", "", "escapeXMLAttrValue", "", "onLintError", "file", "err", "Lcom/pinterest/ktlint/core/LintError;", "corrected", "", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "kotlin.jvm.PlatformType", "", "getOut", "()Ljava/io/PrintStream;", "ktlint-reporter-baseline"})
public final class BaselineReporter
implements Reporter {
    @NotNull
    private final PrintStream out;
    @NotNull
    private final ConcurrentHashMap<String, List<LintError>> acc;

    public BaselineReporter(@NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.acc = new ConcurrentHashMap();
    }

    @NotNull
    public final PrintStream getOut() {
        return this.out;
    }

    public final void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        if (!corrected) {
            ConcurrentMap $this$getOrPut$iv = this.acc;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(file);
            if (object == null) {
                boolean bl = false;
                List default$iv = new ArrayList();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(file, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((List)object).add(err);
        }
    }

    public final void afterAll() {
        this.out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.out.println("<baseline version=\"1.0\">");
        Set<Map.Entry<String, List<LintError>>> set = this.acc.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"acc.entries");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        })) {
            Object object;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"file");
            String file = (String)entry.getKey();
            List errList = (List)entry.getValue();
            try {
                Path rootPath = Paths.get("", new String[0]).toAbsolutePath();
                Path filePath = Paths.get(file, new String[0]);
                object = StringsKt.replace$default((String)((Object)rootPath.relativize(filePath)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            }
            catch (IllegalArgumentException e) {
                object = file;
            }
            String fileName = object;
            StringBuilder stringBuilder = new StringBuilder().append("    <file name=\"");
            Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
            this.out.println(stringBuilder.append(this.escapeXMLAttrValue(fileName)).append("\">").toString());
            for (LintError lintError : errList) {
                int line = lintError.component1();
                int col = lintError.component2();
                String ruleId = lintError.component3();
                this.out.println("        <error line=\"" + line + "\" column=\"" + col + "\" source=\"" + ruleId + "\" />");
            }
            this.out.println("    </file>");
        }
        this.out.println("</baseline>");
    }

    private final String escapeXMLAttrValue(String $this$escapeXMLAttrValue) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeXMLAttrValue, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"\"", (String)"&quot;", (boolean)false, (int)4, null), (String)"'", (String)"&apos;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    public void after(@NotNull String file) {
        Reporter.DefaultImpls.after((Reporter)this, (String)file);
    }

    public void before(@NotNull String file) {
        Reporter.DefaultImpls.before((Reporter)this, (String)file);
    }

    public void beforeAll() {
        Reporter.DefaultImpls.beforeAll((Reporter)this);
    }
}

