/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.reporter.json;

import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.Reporter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0007H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/reporter/json/JsonReporter;", "Lcom/pinterest/ktlint/core/Reporter;", "out", "Ljava/io/PrintStream;", "(Ljava/io/PrintStream;)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/pinterest/ktlint/core/LintError;", "getOut", "()Ljava/io/PrintStream;", "afterAll", "", "onLintError", "file", "err", "corrected", "", "escapeJsonValue", "ktlint-reporter-json"})
public final class JsonReporter
implements Reporter {
    @NotNull
    private final PrintStream out;
    @NotNull
    private final ConcurrentHashMap<String, List<LintError>> acc;

    public JsonReporter(@NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.acc = new ConcurrentHashMap();
    }

    @NotNull
    public final PrintStream getOut() {
        return this.out;
    }

    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        if (!corrected) {
            ConcurrentMap $this$getOrPut$iv = this.acc;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(file);
            if (object == null) {
                boolean bl = false;
                List default$iv = new ArrayList();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(file, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((List)object).add(err);
        }
    }

    public void afterAll() {
        this.out.println("[");
        int indexLast = this.acc.size() - 1;
        Set<Map.Entry<String, List<LintError>>> set = this.acc.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"acc.entries");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        Iterator iterator = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        }).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Map.Entry entry = (Map.Entry)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            String file = (String)entry.getKey();
            List errList = (List)entry.getValue();
            this.out.println("    {");
            StringBuilder stringBuilder = new StringBuilder().append("        \"file\": \"");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            this.out.println(stringBuilder.append(this.escapeJsonValue(file)).append("\",").toString());
            this.out.println("        \"errors\": [");
            int errIndexLast = errList.size() - 1;
            Iterator iterator2 = errList.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int errIndex = n2++;
                LintError err = (LintError)iterator2.next();
                int line = err.component1();
                int col = err.component2();
                String ruleId = err.component3();
                String detail = err.component4();
                this.out.println("            {");
                this.out.println("                \"line\": " + line + ',');
                this.out.println("                \"column\": " + col + ',');
                this.out.println("                \"message\": \"" + this.escapeJsonValue(detail) + "\",");
                this.out.println("                \"rule\": \"" + ruleId + '\"');
                this.out.println("            }" + (errIndex != errIndexLast ? "," : ""));
            }
            this.out.println("        ]");
            this.out.println("    }" + (index != indexLast ? "," : ""));
        }
        this.out.println("]");
    }

    private final String escapeJsonValue(String $this$escapeJsonValue) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeJsonValue, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\b", (String)"\\b", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
    }

    public void after(@NotNull String file) {
        Reporter.DefaultImpls.after((Reporter)this, (String)file);
    }

    public void before(@NotNull String file) {
        Reporter.DefaultImpls.before((Reporter)this, (String)file);
    }

    public void beforeAll() {
        Reporter.DefaultImpls.beforeAll((Reporter)this);
    }
}

